/*
 * Decompiled with CFR 0.152.
 */
package com.vertispan.tsdefs.visitors;

import com.vertispan.tsdefs.HasProcessorEnv;
import com.vertispan.tsdefs.builders.HasTypeArguments;
import com.vertispan.tsdefs.builders.JavaToTsTypeConverter;
import com.vertispan.tsdefs.builders.TsElement;
import com.vertispan.tsdefs.model.TsType;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class TypeArgumentsVisitor<T>
extends TsElement {
    private final TypeMirror type;

    public TypeArgumentsVisitor(TypeMirror typeMirror, HasProcessorEnv env) {
        super(typeMirror, env);
        this.type = typeMirror;
    }

    public void visit(HasTypeArguments<T> builder) {
        DeclaredType classDeclaredType = (DeclaredType)this.type;
        List<? extends TypeMirror> typeArguments = classDeclaredType.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            typeArguments.stream().map(typeMirror -> {
                TsType type = TsElement.of(typeMirror, this.env).getType();
                Element typeElement = this.env.types().asElement((TypeMirror)typeMirror);
                if (typeElement.getKind().equals((Object)ElementKind.TYPE_PARAMETER)) {
                    List<? extends TypeMirror> bounds = ((TypeParameterElement)typeElement).getBounds();
                    bounds.stream().filter(boundType -> !JavaToTsTypeConverter.isSameType(boundType, Object.class, this.env)).map(boundType -> TsElement.of(boundType, this.env).getType()).forEach(type::addBounds);
                }
                return type;
            }).forEach(builder::addTypeArgument);
        }
    }
}

