/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.MapMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TMap;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.ErrorCode;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.QueryDesc;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UpdateSessionsResp
implements TBase,
Serializable,
Cloneable,
Comparable<UpdateSessionsResp> {
    private static final TStruct STRUCT_DESC = new TStruct("UpdateSessionsResp");
    private static final TField CODE_FIELD_DESC = new TField("code", 8, 1);
    private static final TField LEADER_FIELD_DESC = new TField("leader", 12, 2);
    private static final TField KILLED_QUERIES_FIELD_DESC = new TField("killed_queries", 13, 3);
    public ErrorCode code;
    public HostAddr leader;
    public Map<Long, Map<Long, QueryDesc>> killed_queries;
    public static final int CODE = 1;
    public static final int LEADER = 2;
    public static final int KILLED_QUERIES = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public UpdateSessionsResp() {
    }

    public UpdateSessionsResp(ErrorCode code, HostAddr leader, Map<Long, Map<Long, QueryDesc>> killed_queries) {
        this();
        this.code = code;
        this.leader = leader;
        this.killed_queries = killed_queries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateSessionsResp(UpdateSessionsResp other) {
        if (other.isSetCode()) {
            this.code = TBaseHelper.deepCopy(other.code);
        }
        if (other.isSetLeader()) {
            this.leader = TBaseHelper.deepCopy(other.leader);
        }
        if (other.isSetKilled_queries()) {
            this.killed_queries = TBaseHelper.deepCopy(other.killed_queries);
        }
    }

    @Override
    public UpdateSessionsResp deepCopy() {
        return new UpdateSessionsResp(this);
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public UpdateSessionsResp setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public void unsetCode() {
        this.code = null;
    }

    public boolean isSetCode() {
        return this.code != null;
    }

    public void setCodeIsSet(boolean __value) {
        if (!__value) {
            this.code = null;
        }
    }

    public HostAddr getLeader() {
        return this.leader;
    }

    public UpdateSessionsResp setLeader(HostAddr leader) {
        this.leader = leader;
        return this;
    }

    public void unsetLeader() {
        this.leader = null;
    }

    public boolean isSetLeader() {
        return this.leader != null;
    }

    public void setLeaderIsSet(boolean __value) {
        if (!__value) {
            this.leader = null;
        }
    }

    public Map<Long, Map<Long, QueryDesc>> getKilled_queries() {
        return this.killed_queries;
    }

    public UpdateSessionsResp setKilled_queries(Map<Long, Map<Long, QueryDesc>> killed_queries) {
        this.killed_queries = killed_queries;
        return this;
    }

    public void unsetKilled_queries() {
        this.killed_queries = null;
    }

    public boolean isSetKilled_queries() {
        return this.killed_queries != null;
    }

    public void setKilled_queriesIsSet(boolean __value) {
        if (!__value) {
            this.killed_queries = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetCode();
                    break;
                }
                this.setCode((ErrorCode)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetLeader();
                    break;
                }
                this.setLeader((HostAddr)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetKilled_queries();
                    break;
                }
                this.setKilled_queries((Map)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCode();
            }
            case 2: {
                return this.getLeader();
            }
            case 3: {
                return this.getKilled_queries();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof UpdateSessionsResp)) {
            return false;
        }
        UpdateSessionsResp that = (UpdateSessionsResp)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetCode(), that.isSetCode(), this.code, that.code)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetLeader(), that.isSetLeader(), this.leader, that.leader)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetKilled_queries(), that.isSetKilled_queries(), this.killed_queries, that.killed_queries);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.code, this.leader, this.killed_queries});
    }

    @Override
    public int compareTo(UpdateSessionsResp other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetCode()).compareTo(other.isSetCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.code, other.code);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader()).compareTo(other.isSetLeader());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader, other.leader);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKilled_queries()).compareTo(other.isSetKilled_queries());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.killed_queries, other.killed_queries);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 8) {
                        this.code = ErrorCode.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.leader = new HostAddr();
                        this.leader.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map330 = iprot.readMapBegin();
                        this.killed_queries = new HashMap<Long, Map<Long, QueryDesc>>(Math.max(0, 2 * _map330.size));
                        int _i331 = 0;
                        while (_map330.size < 0 ? iprot.peekMap() : _i331 < _map330.size) {
                            long _key332 = iprot.readI64();
                            TMap _map334 = iprot.readMapBegin();
                            HashMap<Long, QueryDesc> _val333 = new HashMap<Long, QueryDesc>(Math.max(0, 2 * _map334.size));
                            int _i335 = 0;
                            while (_map334.size < 0 ? iprot.peekMap() : _i335 < _map334.size) {
                                long _key336 = iprot.readI64();
                                QueryDesc _val337 = new QueryDesc();
                                _val337.read(iprot);
                                _val333.put(_key336, _val337);
                                ++_i335;
                            }
                            iprot.readMapEnd();
                            this.killed_queries.put(_key332, _val333);
                            ++_i331;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.code != null) {
            oprot.writeFieldBegin(CODE_FIELD_DESC);
            oprot.writeI32(this.code == null ? 0 : this.code.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader != null) {
            oprot.writeFieldBegin(LEADER_FIELD_DESC);
            this.leader.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.killed_queries != null) {
            oprot.writeFieldBegin(KILLED_QUERIES_FIELD_DESC);
            oprot.writeMapBegin(new TMap(10, 13, this.killed_queries.size()));
            for (Map.Entry<Long, Map<Long, QueryDesc>> _iter338 : this.killed_queries.entrySet()) {
                oprot.writeI64(_iter338.getKey());
                oprot.writeMapBegin(new TMap(10, 12, _iter338.getValue().size()));
                for (Map.Entry<Long, QueryDesc> _iter339 : _iter338.getValue().entrySet()) {
                    oprot.writeI64(_iter339.getKey());
                    _iter339.getValue().write(oprot);
                }
                oprot.writeMapEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("UpdateSessionsResp");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("code");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCode() == null) {
            sb.append("null");
        } else {
            String code_name;
            String string = code_name = this.getCode() == null ? "null" : this.getCode().name();
            if (code_name != null) {
                sb.append(code_name);
                sb.append(" (");
            }
            sb.append(this.getCode());
            if (code_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("killed_queries");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getKilled_queries() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getKilled_queries(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("code", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(2, new FieldMetaData("leader", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("killed_queries", 3, new MapMetaData(13, new FieldValueMetaData(10), new MapMetaData(13, new FieldValueMetaData(10), new StructMetaData(12, QueryDesc.class)))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(UpdateSessionsResp.class, metaDataMap);
    }

    public static class Builder {
        private ErrorCode code;
        private HostAddr leader;
        private Map<Long, Map<Long, QueryDesc>> killed_queries;

        public Builder setCode(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder setLeader(HostAddr leader) {
            this.leader = leader;
            return this;
        }

        public Builder setKilled_queries(Map<Long, Map<Long, QueryDesc>> killed_queries) {
            this.killed_queries = killed_queries;
            return this;
        }

        public UpdateSessionsResp build() {
            UpdateSessionsResp result = new UpdateSessionsResp();
            result.setCode(this.code);
            result.setLeader(this.leader);
            result.setKilled_queries(this.killed_queries);
            return result;
        }
    }
}

