/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.net;

import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.SSLParam;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.graph.exception.IOErrorException;
import com.vesoft.nebula.client.graph.net.Connection;
import com.vesoft.nebula.client.graph.net.LoadBalancer;
import com.vesoft.nebula.client.graph.net.SyncConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinLoadBalancer
implements LoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoundRobinLoadBalancer.class);
    private static final int S_OK = 0;
    private static final int S_BAD = 1;
    private final List<HostAddress> addresses = new ArrayList<HostAddress>();
    private final Map<HostAddress, Integer> serversStatus = new ConcurrentHashMap<HostAddress, Integer>();
    private final double minClusterHealthRate;
    private final int timeout;
    private final AtomicInteger pos = new AtomicInteger(0);
    private final int delayTime = 60;
    private final ScheduledExecutorService schedule = Executors.newScheduledThreadPool(1);
    private SSLParam sslParam;
    private boolean enabledSsl = false;
    private boolean useHttp2 = false;
    private Map<String, String> customHeaders;
    private String version = null;

    public RoundRobinLoadBalancer(List<HostAddress> addresses, int timeout, double minClusterHealthRate, String version) {
        this(addresses, timeout, minClusterHealthRate, false, new HashMap<String, String>(), version);
    }

    public RoundRobinLoadBalancer(List<HostAddress> addresses, int timeout, double minClusterHealthRate, boolean useHttp2, Map<String, String> headers, String version) {
        this.timeout = timeout;
        for (HostAddress addr : addresses) {
            this.addresses.add(addr);
            this.serversStatus.put(addr, 1);
        }
        this.minClusterHealthRate = minClusterHealthRate;
        this.useHttp2 = useHttp2;
        this.customHeaders = headers;
        this.version = version;
        this.schedule.scheduleAtFixedRate(this::scheduleTask, 0L, 60L, TimeUnit.SECONDS);
    }

    public RoundRobinLoadBalancer(List<HostAddress> addresses, int timeout, SSLParam sslParam, double minClusterHealthRate, String version) {
        this(addresses, timeout, sslParam, minClusterHealthRate, false, new HashMap<String, String>(), version);
    }

    public RoundRobinLoadBalancer(List<HostAddress> addresses, int timeout, SSLParam sslParam, double minClusterHealthRate, boolean useHttp2, Map<String, String> headers, String version) {
        this(addresses, timeout, minClusterHealthRate, useHttp2, headers, version);
        this.sslParam = sslParam;
        this.enabledSsl = true;
    }

    @Override
    public void close() {
        if (!this.schedule.isShutdown()) {
            this.schedule.shutdownNow();
        }
    }

    @Override
    public HostAddress getAddress() {
        int tryCount = 0;
        while (++tryCount <= this.addresses.size()) {
            int newPos = this.pos.getAndIncrement() % this.addresses.size();
            HostAddress addr = this.addresses.get(newPos);
            if (this.serversStatus.get(addr) != 0) continue;
            return addr;
        }
        return null;
    }

    @Override
    public void updateServersStatus() {
        for (HostAddress hostAddress : this.addresses) {
            if (this.ping(hostAddress)) {
                this.serversStatus.put(hostAddress, 0);
                continue;
            }
            this.serversStatus.put(hostAddress, 1);
        }
    }

    public boolean ping(HostAddress addr) {
        try {
            SyncConnection connection = new SyncConnection();
            if (this.enabledSsl) {
                ((Connection)connection).open(addr, this.timeout, this.sslParam, this.useHttp2, this.customHeaders, this.version);
            } else {
                ((Connection)connection).open(addr, this.timeout, this.useHttp2, this.customHeaders, this.version);
            }
            boolean pong = ((Connection)connection).ping();
            ((Connection)connection).close();
            return pong;
        }
        catch (IOErrorException e) {
            return false;
        }
        catch (ClientServerIncompatibleException e) {
            LOGGER.error("version verify failed, ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isServersOK() {
        this.updateServersStatus();
        double numServersWithOkStatus = 0.0;
        for (HostAddress hostAddress : this.addresses) {
            if (this.serversStatus.get(hostAddress) != 0) continue;
            numServersWithOkStatus += 1.0;
        }
        double okServersRate = numServersWithOkStatus / (double)this.addresses.size();
        return okServersRate >= this.minClusterHealthRate;
    }

    private void scheduleTask() {
        this.updateServersStatus();
    }
}

