/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift.transport;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

public class OkHttp3Util {
    private static OkHttpClient client;

    private OkHttp3Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getClient(int connectTimeout, int readTimeout, SSLSocketFactory sslFactory, TrustManager trustManager) {
        if (client != null) return client;
        Class<OkHttp3Util> clazz = OkHttp3Util.class;
        synchronized (OkHttp3Util.class) {
            if (client != null) return client;
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)readTimeout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
            if (sslFactory != null) {
                clientBuilder.sslSocketFactory(sslFactory, (X509TrustManager)trustManager);
                clientBuilder.protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
            } else {
                clientBuilder.protocols(Arrays.asList(Protocol.H2_PRIOR_KNOWLEDGE));
            }
            client = clientBuilder.build();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return client;
        }
    }

    public static void close() {
        if (client != null) {
            client.connectionPool().evictAll();
            client.dispatcher().executorService().shutdown();
            client = null;
        }
    }
}

