/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.graph.data;

import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.proto.common.Record;
import com.vesoft.nebula.proto.common.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class NRecord {
    private Record record;

    public NRecord(Record record) {
        this.record = record;
    }

    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("null map key");
        }
        return this.record.containsValues(key);
    }

    public ValueWrapper getValue(String key) {
        if (!this.containsKey(key)) {
            return null;
        }
        return new ValueWrapper(this.record.getValuesOrDefault(key, null));
    }

    public boolean isEmpty() {
        return this.record.getValuesCount() == 0;
    }

    public int size() {
        return this.record.getValuesCount();
    }

    public Map<String, ValueWrapper> getValuesMap() {
        HashMap<String, ValueWrapper> values = new HashMap<String, ValueWrapper>();
        for (Map.Entry<String, Value> entry : this.record.getValuesMap().entrySet()) {
            values.put(entry.getKey(), new ValueWrapper(entry.getValue()));
        }
        return values;
    }

    public String toString() {
        return this.record.getValuesMap().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NRecord that = (NRecord)o;
        return this.record.getValuesMap().equals(that.record.getValuesMap());
    }

    public int hashCode() {
        return Objects.hash(this.record.getValuesMap());
    }
}

