/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.connector;

import com.vesoft.nebula.connector.NebulaConnectionConfig$;
import com.vesoft.nebula.connector.ssl.CASSLSignParams;
import com.vesoft.nebula.connector.ssl.SSLSignType$;
import com.vesoft.nebula.connector.ssl.SelfSSLSignParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\tec\u0001B\u0001\u0003\u0001-\u0011aCT3ck2\f7i\u001c8oK\u000e$\u0018n\u001c8D_:4\u0017n\u001a\u0006\u0003\u0007\u0011\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005\u00151\u0011A\u00028fEVd\u0017M\u0003\u0002\b\u0011\u00051a/Z:pMRT\u0011!C\u0001\u0004G>l7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t-\u0001\u0011\t\u0011)A\u0005/\u0005YQ.\u001a;b\u0003\u0012$'/Z:t!\tA2D\u0004\u0002\u000e3%\u0011!DD\u0001\u0007!J,G-\u001a4\n\u0005qi\"AB*ue&twM\u0003\u0002\u001b\u001d!Aq\u0004\u0001B\u0001B\u0003%q#\u0001\u0007he\u0006\u0004\b.\u00113ee\u0016\u001c8\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003\u001d!\u0018.\\3pkR\u0004\"!D\u0012\n\u0005\u0011r!aA%oi\"Aa\u0005\u0001B\u0001B\u0003%!%A\bd_:tWm\u0019;j_:\u0014V\r\u001e:z\u0011!A\u0003A!A!\u0002\u0013\u0011\u0013\u0001D3yK\u000e,H/\u001a*fiJL\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u001b\u0015t\u0017M\u00197f\u001b\u0016$\u0018mU*M!\tiA&\u0003\u0002.\u001d\t9!i\\8mK\u0006t\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u001d\u0015t\u0017M\u00197f\u000fJ\f\u0007\u000f[*T\u0019\"A\u0011\u0007\u0001B\u0001B\u0003%1&\u0001\tf]\u0006\u0014G.Z*u_J\fw-Z*T\u0019\"A1\u0007\u0001B\u0001B\u0003%A'\u0001\u0005tS\u001etG+\u001f9f!\t)4H\u0004\u00027s5\tqG\u0003\u00029\u0005\u0005\u00191o\u001d7\n\u0005i:\u0014aC*T\u0019NKwM\u001c+za\u0016L!\u0001P\u001f\u0003\u000bY\u000bG.^3\n\u0005yr!aC#ok6,'/\u0019;j_:D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!Q\u0001\fG\u0006\u001c\u0016n\u001a8QCJ\fW\u000e\u0005\u00027\u0005&\u00111i\u000e\u0002\u0010\u0007\u0006\u001b6\u000bT*jO:\u0004\u0016M]1ng\"AQ\t\u0001B\u0001B\u0003%a)A\u0007tK247+[4o!\u0006\u0014\u0018-\u001c\t\u0003m\u001dK!\u0001S\u001c\u0003#M+GNZ*T\u0019NKwM\u001c)be\u0006l7\u000fC\u0003K\u0001\u0011\u00051*\u0001\u0004=S:LGO\u0010\u000b\r\u0019:{\u0005+\u0015*T)V3v\u000b\u0017\t\u0003\u001b\u0002i\u0011A\u0001\u0005\u0006-%\u0003\ra\u0006\u0005\u0006?%\u0003\ra\u0006\u0005\u0006C%\u0003\rA\t\u0005\u0006M%\u0003\rA\t\u0005\u0006Q%\u0003\rA\t\u0005\u0006U%\u0003\ra\u000b\u0005\u0006_%\u0003\ra\u000b\u0005\u0006c%\u0003\ra\u000b\u0005\u0006g%\u0003\r\u0001\u000e\u0005\u0006\u0001&\u0003\r!\u0011\u0005\u0006\u000b&\u0003\rA\u0012\u0005\u00065\u0002!\taW\u0001\u000fO\u0016$X*\u001a;b\u0003\u0012$'/Z:t+\u00059\u0002\"B/\u0001\t\u0003Y\u0016aD4fi\u001e\u0013\u0018\r\u001d5BI\u0012\u0014Xm]:\t\u000b}\u0003A\u0011\u00011\u0002\u0015\u001d,G\u000fV5nK>,H/F\u0001#\u0011\u0015\u0011\u0007\u0001\"\u0001a\u0003I9W\r^\"p]:,7\r^5p]J+GO]=\t\u000b\u0011\u0004A\u0011\u00011\u0002\u0019\u001d,G/\u0012=fGJ+GO]=\t\u000b\u0019\u0004A\u0011A4\u0002!\u001d,G/\u00128bE2,W*\u001a;b'NcU#A\u0016\t\u000b%\u0004A\u0011A4\u0002#\u001d,G/\u00128bE2,wI]1qQN\u001bF\nC\u0003l\u0001\u0011\u0005q-A\nhKR,e.\u00192mKN#xN]1hKN\u001bF\nC\u0003n\u0001\u0011\u0005a.A\u0006hKR\u001c\u0016n\u001a8UsB,W#A8\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018\u0001\u00027b]\u001eT\u0011\u0001^\u0001\u0005U\u00064\u0018-\u0003\u0002\u001dc\")q\u000f\u0001C\u00017\u0006qq-\u001a;DCNKwM\u001c)be\u0006l\u0007\"B=\u0001\t\u0003Y\u0016\u0001E4fiN+GNZ*jO:\u0004\u0016M]1n\u000f\u0015Y(\u0001#\u0001}\u0003YqUMY;mC\u000e{gN\\3di&|gnQ8oM&<\u0007CA'~\r\u0015\t!\u0001#\u0001\u007f'\riHB\u0005\u0005\u0007\u0015v$\t!!\u0001\u0015\u0003q4a!!\u0002~\u0001\u0005\u001d!!D\"p]\u001aLwMQ;jY\u0012,'oE\u0002\u0002\u00041AqASA\u0002\t\u0003\tY\u0001\u0006\u0002\u0002\u000eA!\u0011qBA\u0002\u001b\u0005i\bBCA\n\u0003\u0007\u0011\r\u0011\"\u0003\u0002\u0016\u0005\u0019AjT$\u0016\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0006g24GG\u001b\u0006\u0003\u0003C\t1a\u001c:h\u0013\u0011\t)#a\u0007\u0003\r1{wmZ3s\u0011%\tI#a\u0001!\u0002\u0013\t9\"\u0001\u0003M\u001f\u001e\u0003\u0003B\u0003\f\u0002\u0004\u0001\u0007\t\u0019!C\t7\"a\u0011qFA\u0002\u0001\u0004\u0005\r\u0011\"\u0005\u00022\u0005yQ.\u001a;b\u0003\u0012$'/Z:t?\u0012*\u0017\u000f\u0006\u0003\u00024\u0005e\u0002cA\u0007\u00026%\u0019\u0011q\u0007\b\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003w\ti#!AA\u0002]\t1\u0001\u001f\u00132\u0011!\ty$a\u0001!B\u00139\u0012\u0001D7fi\u0006\fE\r\u001a:fgN\u0004\u0003BC\u0010\u0002\u0004\u0001\u0007\t\u0019!C\t7\"a\u0011QIA\u0002\u0001\u0004\u0005\r\u0011\"\u0005\u0002H\u0005\u0001rM]1qQ\u0006#GM]3tg~#S-\u001d\u000b\u0005\u0003g\tI\u0005C\u0005\u0002<\u0005\r\u0013\u0011!a\u0001/!A\u0011QJA\u0002A\u0003&q#A\u0007he\u0006\u0004\b.\u00113ee\u0016\u001c8\u000f\t\u0005\tC\u0005\r\u0001\u0019!C\tA\"Q\u00111KA\u0002\u0001\u0004%\t\"!\u0016\u0002\u0017QLW.Z8vi~#S-\u001d\u000b\u0005\u0003g\t9\u0006C\u0005\u0002<\u0005E\u0013\u0011!a\u0001E!A\u00111LA\u0002A\u0003&!%\u0001\u0005uS6,w.\u001e;!\u0011!1\u00131\u0001a\u0001\n#\u0001\u0007BCA1\u0003\u0007\u0001\r\u0011\"\u0005\u0002d\u0005\u00192m\u001c8oK\u000e$\u0018n\u001c8SKR\u0014\u0018p\u0018\u0013fcR!\u00111GA3\u0011%\tY$a\u0018\u0002\u0002\u0003\u0007!\u0005\u0003\u0005\u0002j\u0005\r\u0001\u0015)\u0003#\u0003A\u0019wN\u001c8fGRLwN\u001c*fiJL\b\u0005\u0003\u0005)\u0003\u0007\u0001\r\u0011\"\u0005a\u0011)\ty'a\u0001A\u0002\u0013E\u0011\u0011O\u0001\u0011Kb,7-\u001e;f%\u0016$(/_0%KF$B!a\r\u0002t!I\u00111HA7\u0003\u0003\u0005\rA\t\u0005\t\u0003o\n\u0019\u0001)Q\u0005E\u0005iQ\r_3dkR,'+\u001a;ss\u0002B\u0001BKA\u0002\u0001\u0004%\tb\u001a\u0005\u000b\u0003{\n\u0019\u00011A\u0005\u0012\u0005}\u0014!E3oC\ndW-T3uCN\u001bFj\u0018\u0013fcR!\u00111GAA\u0011%\tY$a\u001f\u0002\u0002\u0003\u00071\u0006\u0003\u0005\u0002\u0006\u0006\r\u0001\u0015)\u0003,\u00039)g.\u00192mK6+G/Y*T\u0019\u0002B\u0001bLA\u0002\u0001\u0004%\tb\u001a\u0005\u000b\u0003\u0017\u000b\u0019\u00011A\u0005\u0012\u00055\u0015AE3oC\ndWm\u0012:ba\"\u001c6\u000bT0%KF$B!a\r\u0002\u0010\"I\u00111HAE\u0003\u0003\u0005\ra\u000b\u0005\t\u0003'\u000b\u0019\u0001)Q\u0005W\u0005yQM\\1cY\u0016<%/\u00199i'Nc\u0005\u0005\u0003\u00052\u0003\u0007\u0001\r\u0011\"\u0005h\u0011)\tI*a\u0001A\u0002\u0013E\u00111T\u0001\u0015K:\f'\r\\3Ti>\u0014\u0018mZ3T'2{F%Z9\u0015\t\u0005M\u0012Q\u0014\u0005\n\u0003w\t9*!AA\u0002-B\u0001\"!)\u0002\u0004\u0001\u0006KaK\u0001\u0012K:\f'\r\\3Ti>\u0014\u0018mZ3T'2\u0003\u0003\u0002DAS\u0003\u0007\u0001\r\u00111A\u0005\u0012\u0005\u001d\u0016aC:tYNKwM\u001c+za\u0016,\u0012\u0001\u000e\u0005\r\u0003W\u000b\u0019\u00011AA\u0002\u0013E\u0011QV\u0001\u0010gNd7+[4o)f\u0004Xm\u0018\u0013fcR!\u00111GAX\u0011%\tY$!+\u0002\u0002\u0003\u0007A\u0007\u0003\u0005\u00024\u0006\r\u0001\u0015)\u00035\u00031\u00198\u000f\\*jO:$\u0016\u0010]3!\u0011%\u0001\u00151\u0001a\u0001\n#\t9,F\u0001B\u0011)\tY,a\u0001A\u0002\u0013E\u0011QX\u0001\u0010G\u0006\u001c\u0016n\u001a8QCJ\fWn\u0018\u0013fcR!\u00111GA`\u0011%\tY$!/\u0002\u0002\u0003\u0007\u0011\t\u0003\u0005\u0002D\u0006\r\u0001\u0015)\u0003B\u00031\u0019\u0017mU5h]B\u000b'/Y7!\u0011%)\u00151\u0001a\u0001\n#\t9-F\u0001G\u0011)\tY-a\u0001A\u0002\u0013E\u0011QZ\u0001\u0012g\u0016dgmU5h]B\u000b'/Y7`I\u0015\fH\u0003BA\u001a\u0003\u001fD\u0011\"a\u000f\u0002J\u0006\u0005\t\u0019\u0001$\t\u0011\u0005M\u00171\u0001Q!\n\u0019\u000bab]3mMNKwM\u001c)be\u0006l\u0007\u0005\u0003\u0005\u0002X\u0006\rA\u0011AAm\u0003=9\u0018\u000e\u001e5NKR\f\u0017\t\u001a3sKN\u001cH\u0003BA\u0007\u00037DaAFAk\u0001\u00049\u0002\u0002CAp\u0003\u0007!\t!!9\u0002!]LG\u000f[$sCBD\u0017\t\u001a3sKN\u001cH\u0003BA\u0007\u0003GDaaHAo\u0001\u00049\u0002\u0002CAt\u0003\u0007!\t!!;\u0002\u0017]LG\u000f\u001b+j[\u0016|W\u000f\u001e\u000b\u0005\u0003\u001b\tY\u000f\u0003\u0004\"\u0003K\u0004\rA\t\u0005\t\u0003_\f\u0019\u0001\"\u0001\u0002r\u0006\u0019r/\u001b;i\u0007>tWM\\2uS>t'+\u001a;ssR!\u0011QBAz\u0011\u00191\u0013Q\u001ea\u0001E!A\u0011q_A\u0002\t\u0003\tI0\u0001\txSRDW\t_3dkR,'+\u001a;ssR!\u0011QBA~\u0011\u0019A\u0013Q\u001fa\u0001E!A\u0011q`A\u0002\t\u0003\u0011\t!A\txSRDWI\\1cY\u0016lU\r^1T'2#B!!\u0004\u0003\u0004!1!&!@A\u0002-B\u0001Ba\u0002\u0002\u0004\u0011\u0005!\u0011B\u0001\u0013o&$\b.\u00128bE2,wI]1qQN\u001bF\n\u0006\u0003\u0002\u000e\t-\u0001BB\u0018\u0003\u0006\u0001\u00071\u0006\u0003\u0005\u0003\u0010\u0005\rA\u0011\u0001B\t\u0003Q9\u0018\u000e\u001e5F]\u0006\u0014G.Z*u_J\fw-Z*T\u0019R!\u0011Q\u0002B\n\u0011\u0019\t$Q\u0002a\u0001W!A!qCA\u0002\t\u0003\u0011I\"A\bxSRD7k\u0015'TS\u001etG+\u001f9f)\u0011\tiAa\u0007\t\rM\u0012)\u00021\u00015\u0011!\u0011y\"a\u0001\u0005\u0002\t\u0005\u0012AE<ji\"\u001c\u0015mU*M'&<g\u000eU1sC6$\u0002\"!\u0004\u0003$\t\u001d\"1\u0006\u0005\b\u0005K\u0011i\u00021\u0001\u0018\u00035\u0019\u0017m\u0011:u\r&dW\rU1uQ\"9!\u0011\u0006B\u000f\u0001\u00049\u0012aC2si\u001aKG.\u001a)bi\"DqA!\f\u0003\u001e\u0001\u0007q#A\u0006lKf4\u0015\u000e\\3QCRD\u0007\u0002\u0003B\u0019\u0003\u0007!\tAa\r\u0002)]LG\u000f[*fY\u001a\u001c6\u000bT*jO:\u0004\u0016M]1n)!\tiA!\u000e\u00038\te\u0002b\u0002B\u0015\u0005_\u0001\ra\u0006\u0005\b\u0005[\u0011y\u00031\u0001\u0018\u0011\u001d\u0011YDa\fA\u0002]\t\u0001\u0002]1tg^|'\u000f\u001a\u0005\t\u0005\u007f\t\u0019\u0001\"\u0001\u0003B\u0005)1\r[3dWR\u0011\u00111\u0007\u0005\t\u0005\u000b\n\u0019\u0001\"\u0001\u0003H\u0005)!-^5mIR\tA\nC\u0004\u0003Lu$\t!a\u0003\u0002\u000f\t,\u0018\u000e\u001c3fe\"I!qJ?\u0002\u0002\u0013%!\u0011K\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003TA\u0019\u0001O!\u0016\n\u0007\t]\u0013O\u0001\u0004PE*,7\r\u001e")
public class NebulaConnectionConfig
implements Serializable {
    private final String metaAddress;
    private final String graphAddress;
    private final int timeout;
    private final int connectionRetry;
    private final int executeRetry;
    private final boolean enableMetaSSL;
    private final boolean enableGraphSSL;
    private final boolean enableStorageSSL;
    private final Enumeration.Value signType;
    private final CASSLSignParams caSignParam;
    private final SelfSSLSignParams selfSignParam;

    public static ConfigBuilder builder() {
        return NebulaConnectionConfig$.MODULE$.builder();
    }

    public String getMetaAddress() {
        return this.metaAddress;
    }

    public String getGraphAddress() {
        return this.graphAddress;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getConnectionRetry() {
        return this.connectionRetry;
    }

    public int getExecRetry() {
        return this.executeRetry;
    }

    public boolean getEnableMetaSSL() {
        return this.enableMetaSSL;
    }

    public boolean getEnableGraphSSL() {
        return this.enableGraphSSL;
    }

    public boolean getEnableStorageSSL() {
        return this.enableStorageSSL;
    }

    public String getSignType() {
        return this.signType.toString();
    }

    public String getCaSignParam() {
        return new StringBuilder().append((Object)this.caSignParam.caCrtFilePath()).append((Object)",").append((Object)this.caSignParam.crtFilePath()).append((Object)",").append((Object)this.caSignParam.keyFilePath()).toString();
    }

    public String getSelfSignParam() {
        return new StringBuilder().append((Object)this.selfSignParam.crtFilePath()).append((Object)",").append((Object)this.selfSignParam.keyFilePath()).append((Object)",").append((Object)this.selfSignParam.password()).toString();
    }

    public NebulaConnectionConfig(String metaAddress, String graphAddress, int timeout, int connectionRetry, int executeRetry, boolean enableMetaSSL, boolean enableGraphSSL, boolean enableStorageSSL, Enumeration.Value signType, CASSLSignParams caSignParam, SelfSSLSignParams selfSignParam) {
        this.metaAddress = metaAddress;
        this.graphAddress = graphAddress;
        this.timeout = timeout;
        this.connectionRetry = connectionRetry;
        this.executeRetry = executeRetry;
        this.enableMetaSSL = enableMetaSSL;
        this.enableGraphSSL = enableGraphSSL;
        this.enableStorageSSL = enableStorageSSL;
        this.signType = signType;
        this.caSignParam = caSignParam;
        this.selfSignParam = selfSignParam;
    }

    public static class ConfigBuilder {
        private final Logger LOG = LoggerFactory.getLogger(this.getClass());
        private String metaAddress;
        private String graphAddress;
        private int timeout = 6000;
        private int connectionRetry = 1;
        private int executeRetry = 1;
        private boolean enableMetaSSL = false;
        private boolean enableGraphSSL = false;
        private boolean enableStorageSSL = false;
        private Enumeration.Value sslSignType;
        private CASSLSignParams caSignParam = null;
        private SelfSSLSignParams selfSignParam = null;

        private Logger LOG() {
            return this.LOG;
        }

        public String metaAddress() {
            return this.metaAddress;
        }

        public void metaAddress_$eq(String x$1) {
            this.metaAddress = x$1;
        }

        public String graphAddress() {
            return this.graphAddress;
        }

        public void graphAddress_$eq(String x$1) {
            this.graphAddress = x$1;
        }

        public int timeout() {
            return this.timeout;
        }

        public void timeout_$eq(int x$1) {
            this.timeout = x$1;
        }

        public int connectionRetry() {
            return this.connectionRetry;
        }

        public void connectionRetry_$eq(int x$1) {
            this.connectionRetry = x$1;
        }

        public int executeRetry() {
            return this.executeRetry;
        }

        public void executeRetry_$eq(int x$1) {
            this.executeRetry = x$1;
        }

        public boolean enableMetaSSL() {
            return this.enableMetaSSL;
        }

        public void enableMetaSSL_$eq(boolean x$1) {
            this.enableMetaSSL = x$1;
        }

        public boolean enableGraphSSL() {
            return this.enableGraphSSL;
        }

        public void enableGraphSSL_$eq(boolean x$1) {
            this.enableGraphSSL = x$1;
        }

        public boolean enableStorageSSL() {
            return this.enableStorageSSL;
        }

        public void enableStorageSSL_$eq(boolean x$1) {
            this.enableStorageSSL = x$1;
        }

        public Enumeration.Value sslSignType() {
            return this.sslSignType;
        }

        public void sslSignType_$eq(Enumeration.Value x$1) {
            this.sslSignType = x$1;
        }

        public CASSLSignParams caSignParam() {
            return this.caSignParam;
        }

        public void caSignParam_$eq(CASSLSignParams x$1) {
            this.caSignParam = x$1;
        }

        public SelfSSLSignParams selfSignParam() {
            return this.selfSignParam;
        }

        public void selfSignParam_$eq(SelfSSLSignParams x$1) {
            this.selfSignParam = x$1;
        }

        public ConfigBuilder withMetaAddress(String metaAddress) {
            this.metaAddress_$eq(metaAddress);
            return this;
        }

        public ConfigBuilder withGraphAddress(String graphAddress) {
            this.graphAddress_$eq(graphAddress);
            return this;
        }

        public ConfigBuilder withTimeout(int timeout) {
            this.timeout_$eq(timeout);
            return this;
        }

        public ConfigBuilder withConenctionRetry(int connectionRetry) {
            this.connectionRetry_$eq(connectionRetry);
            return this;
        }

        public ConfigBuilder withExecuteRetry(int executeRetry) {
            this.executeRetry_$eq(executeRetry);
            return this;
        }

        public ConfigBuilder withEnableMetaSSL(boolean enableMetaSSL) {
            this.enableMetaSSL_$eq(enableMetaSSL);
            return this;
        }

        public ConfigBuilder withEnableGraphSSL(boolean enableGraphSSL) {
            this.enableGraphSSL_$eq(enableGraphSSL);
            return this;
        }

        public ConfigBuilder withEnableStorageSSL(boolean enableStorageSSL) {
            this.enableStorageSSL_$eq(enableStorageSSL);
            return this;
        }

        public ConfigBuilder withSSLSignType(Enumeration.Value signType) {
            this.sslSignType_$eq(signType);
            return this;
        }

        public ConfigBuilder withCaSSLSignParam(String caCrtFilePath, String crtFilePath, String keyFilePath) {
            this.caSignParam_$eq(new CASSLSignParams(caCrtFilePath, crtFilePath, keyFilePath));
            return this;
        }

        public ConfigBuilder withSelfSSLSignParam(String crtFilePath, String keyFilePath, String password) {
            this.selfSignParam_$eq(new SelfSSLSignParams(crtFilePath, keyFilePath, password));
            return this;
        }

        public void check() {
            Predef$.MODULE$.assert(this.metaAddress() != null && !this.metaAddress().isEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "config address is empty.";
                }
            });
            Predef$.MODULE$.assert(this.timeout() > 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "timeout must be larger than 0";
                }
            });
            Predef$.MODULE$.assert(this.connectionRetry() > 0 && this.executeRetry() > 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "retry must be larger than 0.";
                }
            });
            if (this.enableMetaSSL()) {
                this.LOG().info("enableMetaSSL is true, then enableGraphSSL will be invalid for now.");
            }
            if (this.enableMetaSSL() || this.enableGraphSSL() || this.enableStorageSSL()) {
                Predef$.MODULE$.assert(!this.enableStorageSSL() || this.enableStorageSSL() && this.enableMetaSSL(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "ssl priority order: storage > meta = graph please make sure meta ssl is enabled when storage ssl is enabled.";
                    }
                });
                Enumeration.Value value = this.sslSignType();
                Enumeration.Value value2 = SSLSignType$.MODULE$.CA();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    Predef$.MODULE$.assert(this.caSignParam() != null && this.caSignParam().caCrtFilePath() != null && this.caSignParam().crtFilePath() != null && this.caSignParam().keyFilePath() != null, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "ssl sign type is CA, param can not be null";
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value4 = SSLSignType$.MODULE$.SELF();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        Predef$.MODULE$.assert(this.selfSignParam() != null && this.selfSignParam().crtFilePath() != null && this.selfSignParam().keyFilePath() != null && this.selfSignParam().password() != null, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "ssl sign type is SELF, param can not be null";
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Predef$.MODULE$.assert(false, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "SSLSignType config is null";
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        }

        public NebulaConnectionConfig build() {
            this.check();
            return new NebulaConnectionConfig(this.metaAddress(), this.graphAddress(), this.timeout(), this.connectionRetry(), this.executeRetry(), this.enableMetaSSL(), this.enableGraphSSL(), this.enableStorageSSL(), this.sslSignType(), this.caSignParam(), this.selfSignParam());
        }
    }
}

