/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.connector;

import com.vesoft.nebula.PropertyType;
import com.vesoft.nebula.client.graph.data.DateTimeWrapper;
import com.vesoft.nebula.client.graph.data.DurationWrapper;
import com.vesoft.nebula.client.graph.data.TimeWrapper;
import com.vesoft.nebula.connector.NebulaOptions;
import com.vesoft.nebula.meta.ColumnDef;
import com.vesoft.nebula.meta.ColumnTypeDef;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class NebulaUtils$ {
    public static final NebulaUtils$ MODULE$;
    private final Logger LOG;
    private NebulaOptions nebulaOptions;
    private Map<String, String> parameters;

    static {
        new NebulaUtils$();
    }

    private Logger LOG() {
        return this.LOG;
    }

    public NebulaOptions nebulaOptions() {
        return this.nebulaOptions;
    }

    public void nebulaOptions_$eq(NebulaOptions x$1) {
        this.nebulaOptions = x$1;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public void parameters_$eq(Map<String, String> x$1) {
        this.parameters = x$1;
    }

    public DataType convertDataType(ColumnTypeDef columnTypeDef) {
        PropertyType propertyType;
        block9: {
            LongType$ longType$;
            block5: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                propertyType = columnTypeDef.getType();
                                boolean bl = PropertyType.VID.equals(propertyType) ? true : (PropertyType.INT8.equals(propertyType) ? true : (PropertyType.INT16.equals(propertyType) ? true : (PropertyType.INT32.equals(propertyType) ? true : PropertyType.INT64.equals(propertyType))));
                                if (!bl) break block4;
                                longType$ = LongType$.MODULE$;
                                break block5;
                            }
                            if (!PropertyType.BOOL.equals(propertyType)) break block6;
                            longType$ = BooleanType$.MODULE$;
                            break block5;
                        }
                        boolean bl = PropertyType.FLOAT.equals(propertyType) ? true : PropertyType.DOUBLE.equals(propertyType);
                        if (!bl) break block7;
                        longType$ = DoubleType$.MODULE$;
                        break block5;
                    }
                    if (!PropertyType.TIMESTAMP.equals(propertyType)) break block8;
                    longType$ = LongType$.MODULE$;
                    break block5;
                }
                boolean bl = PropertyType.FIXED_STRING.equals(propertyType) ? true : (PropertyType.STRING.equals(propertyType) ? true : (PropertyType.DATE.equals(propertyType) ? true : (PropertyType.TIME.equals(propertyType) ? true : (PropertyType.DATETIME.equals(propertyType) ? true : (PropertyType.GEOGRAPHY.equals(propertyType) ? true : PropertyType.DURATION.equals(propertyType))))));
                if (!bl) break block9;
                longType$ = StringType$.MODULE$;
            }
            return longType$;
        }
        if (PropertyType.UNKNOWN.equals(propertyType)) {
            throw new IllegalArgumentException("unsupported data type");
        }
        throw new MatchError((Object)propertyType);
    }

    public DataType getColDataType(List<ColumnDef> columnDefs, String columnName) {
        Object object = new Object();
        try {
            columnDefs.foreach((Function1)new Serializable(columnName, object){
                public static final long serialVersionUID = 0L;
                private final String columnName$1;
                private final Object nonLocalReturnKey1$1;

                public final void apply(ColumnDef columnDef) {
                    if (this.columnName$1.equals(new String(columnDef.getName()))) {
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)NebulaUtils$.MODULE$.convertDataType(columnDef.getType()));
                    }
                }
                {
                    this.columnName$1 = columnName$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"column ", " does not exist in schema"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnName})));
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return (DataType)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
    }

    public Function3<Object, InternalRow, Object, BoxedUnit>[] makeGetters(StructType schema) {
        return (Function3[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function3<Object, InternalRow, Object, BoxedUnit> apply(StructField field) {
                return NebulaUtils$.MODULE$.com$vesoft$nebula$connector$NebulaUtils$$makeGetter(field.dataType());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function3.class)));
    }

    public Function3<Object, InternalRow, Object, BoxedUnit> com$vesoft$nebula$connector$NebulaUtils$$makeGetter(DataType dataType) {
        Object object;
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Object prop, InternalRow row, int pos) {
                    row.setBoolean(pos, BoxesRunTime.unboxToBoolean((Object)prop));
                }
            };
        } else {
            boolean bl = TimestampType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2);
            if (bl) {
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Object prop, InternalRow row, int pos) {
                        row.setLong(pos, BoxesRunTime.unboxToLong((Object)prop));
                    }
                };
            } else {
                boolean bl2 = FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2);
                object = bl2 ? new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Object prop, InternalRow row, int pos) {
                        row.setDouble(pos, BoxesRunTime.unboxToDouble((Object)prop));
                    }
                } : (IntegerType$.MODULE$.equals(dataType2) ? new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Object prop, InternalRow row, int pos) {
                        row.setInt(pos, BoxesRunTime.unboxToInt((Object)prop));
                    }
                } : new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Object prop, InternalRow row, int pos) {
                        if (prop instanceof DateTimeWrapper) {
                            row.update(pos, (Object)UTF8String.fromString((String)((DateTimeWrapper)prop).getUTCDateTimeStr()));
                        } else if (prop instanceof TimeWrapper) {
                            row.update(pos, (Object)UTF8String.fromString((String)((TimeWrapper)prop).getUTCTimeStr()));
                        } else if (prop instanceof DurationWrapper) {
                            row.update(pos, (Object)UTF8String.fromString((String)((DurationWrapper)prop).getDurationString()));
                        } else {
                            row.update(pos, (Object)UTF8String.fromString((String)String.valueOf(prop)));
                        }
                    }
                });
            }
        }
        return object;
    }

    public boolean isNumic(String str) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                String newStr = str.startsWith("-") ? str.substring(1) : str;
                Predef$.MODULE$.charArrayOps(newStr.toCharArray()).foreach((Function1)new Serializable(object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(char c) {
                        if (Character.isDigit(c)) {
                            return;
                        }
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey2$1, false);
                    }
                    {
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    /*
     * WARNING - void declaration
     */
    public String escapeUtil(String str) {
        void var2_2;
        String s = str;
        if (s.contains("\\")) {
            s = s.replaceAll("\\\\", "\\\\\\\\");
        }
        if (s.contains("\t")) {
            s = s.replaceAll("\t", "\\\\t");
        }
        if (s.contains("\n")) {
            s = s.replaceAll("\n", "\\\\n");
        }
        if (s.contains("\"")) {
            s = s.replaceAll("\"", "\\\\\"");
        }
        if (s.contains("'")) {
            s = s.replaceAll("'", "\\\\'");
        }
        if (s.contains("\r")) {
            s = s.replaceAll("\r", "\\\\r");
        }
        if (s.contains("\b")) {
            s = s.replaceAll("\b", "\\\\b");
        }
        return var2_2;
    }

    private NebulaUtils$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
        this.parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

