/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.connector.writer;

import com.vesoft.nebula.PropertyType;
import com.vesoft.nebula.connector.DataTypeEnum$;
import com.vesoft.nebula.connector.KeyPolicy$;
import com.vesoft.nebula.connector.NebulaTemplate$;
import com.vesoft.nebula.connector.NebulaUtils$;
import com.vesoft.nebula.connector.package;
import com.vesoft.nebula.connector.writer.NebulaExecutor$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class NebulaExecutor$ {
    public static final NebulaExecutor$ MODULE$;

    static {
        new NebulaExecutor$();
    }

    public String extraID(StructType schema, InternalRow record, int index, Option<Enumeration.Value> policy, boolean isVidStringType) {
        String string;
        DataType[] types = (DataType[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField field) {
                return field.dataType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
        String vid = record.get(index, types[index]).toString();
        if (policy.isEmpty()) {
            if (isVidStringType) {
                string = new StringOps(Predef$.MODULE$.augmentString(NebulaUtils$.MODULE$.escapeUtil(vid))).mkString("\"", "", "\"");
            } else {
                Predef$.MODULE$.assert(NebulaUtils$.MODULE$.isNumic(vid));
                string = vid;
            }
        } else {
            string = vid;
        }
        return string;
    }

    public long extraRank(StructType schema, InternalRow record, int rankIndex) {
        DataType[] types = (DataType[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField field) {
                return field.dataType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
        String rank = record.get(rankIndex, types[rankIndex]).toString();
        Predef$.MODULE$.assert(NebulaUtils$.MODULE$.isNumic(rank), (Function0)new Serializable(rank){
            public static final long serialVersionUID = 0L;
            private final String rank$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rank must be numeric, but your rank is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rank$1}));
            }
            {
                this.rank$1 = rank$1;
            }
        });
        return new StringOps(Predef$.MODULE$.augmentString(rank)).toLong();
    }

    public List<Object> assignVertexPropValues(StructType schema, InternalRow record, int vertexIndex, boolean vidAsProp, Map<String, Integer> fieldTypeMap) {
        IndexedSeq values = (IndexedSeq)Predef$.MODULE$.refArrayOps((Object[])schema.fields()).indices().withFilter((Function1)new Serializable(vertexIndex, vidAsProp){
            public static final long serialVersionUID = 0L;
            private final int vertexIndex$1;
            private final boolean vidAsProp$1;

            public final boolean apply(int index) {
                return this.apply$mcZI$sp(index);
            }

            public boolean apply$mcZI$sp(int index) {
                return this.vidAsProp$1 || index != this.vertexIndex$1;
            }
            {
                this.vertexIndex$1 = vertexIndex$1;
                this.vidAsProp$1 = vidAsProp$1;
            }
        }).map((Function1)new Serializable(schema, record, fieldTypeMap){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;
            private final InternalRow record$1;
            private final Map fieldTypeMap$1;

            public final Object apply(int index) {
                return NebulaExecutor$.MODULE$.com$vesoft$nebula$connector$writer$NebulaExecutor$$extraValue(this.record$1, this.schema$1, index, (Map<String, Integer>)this.fieldTypeMap$1);
            }
            {
                this.schema$1 = schema$1;
                this.record$1 = record$1;
                this.fieldTypeMap$1 = fieldTypeMap$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return values.toList();
    }

    public List<Object> assignEdgeValues(StructType schema, InternalRow record, int srcIndex, int dstIndex, int rankIndex, boolean srcAsProp, boolean dstAsProp, boolean rankAsProp, Map<String, Integer> fieldTypeMap) {
        IndexedSeq values = (IndexedSeq)Predef$.MODULE$.refArrayOps((Object[])schema.fields()).indices().withFilter((Function1)new Serializable(srcIndex, dstIndex, rankIndex, srcAsProp, dstAsProp, rankAsProp){
            public static final long serialVersionUID = 0L;
            private final int srcIndex$1;
            private final int dstIndex$1;
            private final int rankIndex$1;
            private final boolean srcAsProp$1;
            private final boolean dstAsProp$1;
            private final boolean rankAsProp$1;

            public final boolean apply(int index) {
                return this.apply$mcZI$sp(index);
            }

            public boolean apply$mcZI$sp(int index) {
                return !(!this.srcAsProp$1 && index == this.srcIndex$1 || !this.dstAsProp$1 && index == this.dstIndex$1 || !this.rankAsProp$1 && index == this.rankIndex$1);
            }
            {
                this.srcIndex$1 = srcIndex$1;
                this.dstIndex$1 = dstIndex$1;
                this.rankIndex$1 = rankIndex$1;
                this.srcAsProp$1 = srcAsProp$1;
                this.dstAsProp$1 = dstAsProp$1;
                this.rankAsProp$1 = rankAsProp$1;
            }
        }).map((Function1)new Serializable(schema, record, fieldTypeMap){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;
            private final InternalRow record$2;
            private final Map fieldTypeMap$2;

            public final Object apply(int index) {
                return NebulaExecutor$.MODULE$.com$vesoft$nebula$connector$writer$NebulaExecutor$$extraValue(this.record$2, this.schema$2, index, (Map<String, Integer>)this.fieldTypeMap$2);
            }
            {
                this.schema$2 = schema$2;
                this.record$2 = record$2;
                this.fieldTypeMap$2 = fieldTypeMap$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return values.toList();
    }

    public Object com$vesoft$nebula$connector$writer$NebulaExecutor$$extraValue(InternalRow record, StructType schema, int index, Map<String, Integer> fieldTypeMap) {
        if (record.isNullAt(index)) {
            return null;
        }
        DataType[] types = (DataType[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField field) {
                return field.dataType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
        Object propValue = record.get(index, types[index]);
        String propValueTypeClassName = propValue.getClass().getName();
        String simpleName = propValueTypeClassName.substring(propValueTypeClassName.lastIndexOf(".") + 1, propValueTypeClassName.length());
        String fieldName = schema.fields()[index].name();
        PropertyType propertyType = PropertyType.findByValue((int)Predef$.MODULE$.Integer2int((Integer)fieldTypeMap.apply((Object)fieldName)));
        boolean bl = PropertyType.STRING.equals(propertyType) ? true : PropertyType.FIXED_STRING.equals(propertyType);
        Object object = bl ? new StringOps(Predef$.MODULE$.augmentString(NebulaUtils$.MODULE$.escapeUtil(propValue.toString()))).mkString("\"", "", "\"") : (PropertyType.DATE.equals(propertyType) ? new StringBuilder().append((Object)"date(\"").append(propValue).append((Object)"\")").toString() : (PropertyType.DATETIME.equals(propertyType) ? new StringBuilder().append((Object)"datetime(\"").append(propValue).append((Object)"\")").toString() : (PropertyType.TIME.equals(propertyType) ? new StringBuilder().append((Object)"time(\"").append(propValue).append((Object)"\")").toString() : (PropertyType.TIMESTAMP.equals(propertyType) ? (NebulaUtils$.MODULE$.isNumic(propValue.toString()) ? (simpleName.equalsIgnoreCase("UTF8String") ? propValue.toString() : propValue) : new StringBuilder().append((Object)"timestamp(\"").append(propValue).append((Object)"\")").toString()) : (PropertyType.GEOGRAPHY.equals(propertyType) ? new StringBuilder().append((Object)"ST_GeogFromText(\"").append(propValue).append((Object)"\")").toString() : (simpleName.equalsIgnoreCase("UTF8String") ? propValue.toString() : propValue))))));
        return object;
    }

    public List<String> assignVertexPropNames(StructType schema, int vertexIndex, boolean vidAsProp) {
        IndexedSeq propNames = (IndexedSeq)schema.indices().withFilter((Function1)new Serializable(vertexIndex, vidAsProp){
            public static final long serialVersionUID = 0L;
            private final int vertexIndex$2;
            private final boolean vidAsProp$2;

            public final boolean apply(int index) {
                return this.apply$mcZI$sp(index);
            }

            public boolean apply$mcZI$sp(int index) {
                return this.vidAsProp$2 || index != this.vertexIndex$2;
            }
            {
                this.vertexIndex$2 = vertexIndex$2;
                this.vidAsProp$2 = vidAsProp$2;
            }
        }).map((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$3;

            public final String apply(int index) {
                return this.schema$3.fields()[index].name();
            }
            {
                this.schema$3 = schema$3;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return propNames.toList();
    }

    public List<String> assignEdgePropNames(StructType schema, int srcIndex, int dstIndex, int rankIndex, boolean srcAsProp, boolean dstAsProp, boolean rankAsProp) {
        IndexedSeq propNames = (IndexedSeq)schema.indices().withFilter((Function1)new Serializable(srcIndex, dstIndex, rankIndex, srcAsProp, dstAsProp, rankAsProp){
            public static final long serialVersionUID = 0L;
            private final int srcIndex$2;
            private final int dstIndex$2;
            private final int rankIndex$2;
            private final boolean srcAsProp$2;
            private final boolean dstAsProp$2;
            private final boolean rankAsProp$2;

            public final boolean apply(int index) {
                return this.apply$mcZI$sp(index);
            }

            public boolean apply$mcZI$sp(int index) {
                return !(!this.srcAsProp$2 && index == this.srcIndex$2 || !this.dstAsProp$2 && index == this.dstIndex$2 || !this.rankAsProp$2 && index == this.rankIndex$2);
            }
            {
                this.srcIndex$2 = srcIndex$2;
                this.dstIndex$2 = dstIndex$2;
                this.rankIndex$2 = rankIndex$2;
                this.srcAsProp$2 = srcAsProp$2;
                this.dstAsProp$2 = dstAsProp$2;
                this.rankAsProp$2 = rankAsProp$2;
            }
        }).map((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$4;

            public final String apply(int index) {
                return this.schema$4.fields()[index].name();
            }
            {
                this.schema$4 = schema$4;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return propNames.toList();
    }

    public String toExecuteSentence(String tagName, package.NebulaVertices vertices) {
        return new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.BATCH_INSERT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataTypeEnum$.MODULE$.VERTEX().toString(), tagName, vertices.propertyNames(), ((TraversableOnce)vertices.values().map((Function1)new Serializable(vertices){
            public static final long serialVersionUID = 0L;
            private final package.NebulaVertices vertices$1;

            public final String apply(package.NebulaVertex vertex) {
                block6: {
                    String string;
                    block3: {
                        String string2;
                        block5: {
                            Enumeration.Value value;
                            block4: {
                                block2: {
                                    if (!this.vertices$1.policy().isEmpty()) break block2;
                                    string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.VERTEX_VALUE_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vertex.vertexIDSlice(), vertex.propertyValues()}));
                                    break block3;
                                }
                                value = (Enumeration.Value)this.vertices$1.policy().get();
                                Enumeration.Value value2 = KeyPolicy$.MODULE$.HASH();
                                Enumeration.Value value3 = value;
                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                                string2 = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.VERTEX_VALUE_TEMPLATE_WITH_POLICY())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.HASH().toString(), vertex.vertexIDSlice(), vertex.propertyValues()}));
                                break block5;
                            }
                            Enumeration.Value value4 = KeyPolicy$.MODULE$.UUID();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                            string2 = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.VERTEX_VALUE_TEMPLATE_WITH_POLICY())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.UUID().toString(), vertex.vertexIDSlice(), vertex.propertyValues()}));
                        }
                        string = string2;
                    }
                    return string;
                }
                throw new IllegalArgumentException("Not Support");
            }
            {
                this.vertices$1 = vertices$1;
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ")}));
    }

    public String toExecuteSentence(String edgeName, package.NebulaEdges edges) {
        String values = ((TraversableOnce)edges.values().map((Function1)new Serializable(edges){
            public static final long serialVersionUID = 0L;
            private final package.NebulaEdges edges$1;

            public final String apply(package.NebulaEdge edge) {
                block5: {
                    block9: {
                        String string;
                        String source;
                        block7: {
                            Option<Enumeration.Value> option;
                            block8: {
                                Some some;
                                boolean bl;
                                block6: {
                                    String string2;
                                    block3: {
                                        Option<Enumeration.Value> option2;
                                        block4: {
                                            Some some2;
                                            boolean bl2;
                                            block2: {
                                                bl2 = false;
                                                some2 = null;
                                                option2 = this.edges$1.getSourcePolicy();
                                                if (!(option2 instanceof Some)) break block2;
                                                bl2 = true;
                                                some2 = (Some)option2;
                                                Enumeration.Value value = (Enumeration.Value)some2.x();
                                                Enumeration.Value value2 = KeyPolicy$.MODULE$.HASH();
                                                Enumeration.Value value3 = value;
                                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                                string2 = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.HASH().toString(), edge.source()}));
                                                break block3;
                                            }
                                            if (!bl2) break block4;
                                            Enumeration.Value value = (Enumeration.Value)some2.x();
                                            Enumeration.Value value4 = KeyPolicy$.MODULE$.UUID();
                                            Enumeration.Value value5 = value;
                                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                                            string2 = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.UUID().toString(), edge.source()}));
                                            break block3;
                                        }
                                        if (!None$.MODULE$.equals(option2)) break block5;
                                        string2 = edge.source();
                                    }
                                    source = string2;
                                    bl = false;
                                    some = null;
                                    option = this.edges$1.getTargetPolicy();
                                    if (!(option instanceof Some)) break block6;
                                    bl = true;
                                    some = (Some)option;
                                    Enumeration.Value value = (Enumeration.Value)some.x();
                                    Enumeration.Value value6 = KeyPolicy$.MODULE$.HASH();
                                    Enumeration.Value value7 = value;
                                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block6;
                                    string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.HASH().toString(), edge.target()}));
                                    break block7;
                                }
                                if (!bl) break block8;
                                Enumeration.Value value = (Enumeration.Value)some.x();
                                Enumeration.Value value8 = KeyPolicy$.MODULE$.UUID();
                                Enumeration.Value value9 = value;
                                if (value8 != null ? !value8.equals(value9) : value9 != null) break block8;
                                string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.UUID().toString(), edge.target()}));
                                break block7;
                            }
                            if (!None$.MODULE$.equals(option)) break block9;
                            string = edge.target();
                        }
                        String target = string;
                        return edge.rank().isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.EDGE_VALUE_WITHOUT_RANKING_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source, target, edge.propertyValues()})) : new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.EDGE_VALUE_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source, target, edge.rank().get(), edge.propertyValues()}));
                    }
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target policy ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.edges$1.getTargetPolicy().get()})));
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source policy ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.edges$1.getSourcePolicy().get()})));
            }
            {
                this.edges$1 = edges$1;
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ");
        return new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.BATCH_INSERT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataTypeEnum$.MODULE$.EDGE().toString(), edgeName, edges.propertyNames(), values}));
    }

    public String toUpdateExecuteStatement(String tagName, package.NebulaVertices nebulaVertices) {
        return ((TraversableOnce)nebulaVertices.values().map((Function1)new Serializable(tagName, nebulaVertices){
            public static final long serialVersionUID = 0L;
            private final String tagName$1;
            public final package.NebulaVertices nebulaVertices$1;

            public final String apply(package.NebulaVertex vertex) {
                block5: {
                    String string;
                    Object[] objectArray;
                    StringOps stringOps;
                    IntRef index;
                    block3: {
                        Option<Enumeration.Value> option;
                        block4: {
                            Some some;
                            boolean bl;
                            block2: {
                                index = IntRef.create((int)0);
                                stringOps = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.UPDATE_VERTEX_TEMPLATE()));
                                objectArray = new Object[4];
                                objectArray[0] = DataTypeEnum$.MODULE$.VERTEX().toString().toUpperCase();
                                objectArray[1] = this.tagName$1;
                                bl = false;
                                some = null;
                                option = this.nebulaVertices$1.policy();
                                if (!(option instanceof Some)) break block2;
                                bl = true;
                                some = (Some)option;
                                Enumeration.Value value = (Enumeration.Value)some.x();
                                Enumeration.Value value2 = KeyPolicy$.MODULE$.HASH();
                                Enumeration.Value value3 = value;
                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.HASH().toString(), vertex.vertexIDSlice()}));
                                break block3;
                            }
                            if (!bl) break block4;
                            Enumeration.Value value = (Enumeration.Value)some.x();
                            Enumeration.Value value4 = KeyPolicy$.MODULE$.UUID();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                            string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.UUID().toString(), vertex.vertexIDSlice()}));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block5;
                        string = vertex.vertexIDSlice();
                    }
                    objectArray[2] = string;
                    objectArray[3] = ((TraversableOnce)vertex.values().map((Function1)new Serializable(this, index){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.toUpdateExecuteStatement.1 $outer;
                        private final IntRef index$1;

                        /*
                         * WARNING - void declaration
                         */
                        public final String apply(Object value) {
                            void var2_2;
                            String updateValue = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.UPDATE_VALUE_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConversions$.MODULE$.seqAsJavaList(this.$outer.nebulaVertices$1.propNames()).get(this.index$1.elem), value}));
                            ++this.index$1.elem;
                            return var2_2;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.index$1 = index$1;
                        }
                    }, List$.MODULE$.canBuildFrom())).mkString(",");
                    return stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vertex id policy ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nebulaVertices$1.policy().get()})));
            }
            {
                this.tagName$1 = tagName$1;
                this.nebulaVertices$1 = nebulaVertices$1;
            }
        }, List$.MODULE$.canBuildFrom())).mkString(";");
    }

    public String toUpdateExecuteStatement(String edgeName, package.NebulaEdges nebulaEdges) {
        return ((TraversableOnce)nebulaEdges.values().map((Function1)new Serializable(edgeName, nebulaEdges){
            public static final long serialVersionUID = 0L;
            private final String edgeName$1;
            public final package.NebulaEdges nebulaEdges$1;

            public final String apply(package.NebulaEdge edge) {
                block5: {
                    block9: {
                        String string;
                        Object[] objectArray;
                        StringOps stringOps;
                        Object rank;
                        IntRef index;
                        block7: {
                            Option<Enumeration.Value> option;
                            block8: {
                                Some some;
                                boolean bl;
                                block6: {
                                    String string2;
                                    block3: {
                                        Option<Enumeration.Value> option2;
                                        block4: {
                                            Some some2;
                                            boolean bl2;
                                            block2: {
                                                index = IntRef.create((int)0);
                                                rank = edge.rank().isEmpty() ? BoxesRunTime.boxToInteger((int)0) : edge.rank().get();
                                                stringOps = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.UPDATE_EDGE_TEMPLATE()));
                                                objectArray = new Object[6];
                                                objectArray[0] = DataTypeEnum$.MODULE$.EDGE().toString().toUpperCase();
                                                objectArray[1] = this.edgeName$1;
                                                bl2 = false;
                                                some2 = null;
                                                option2 = this.nebulaEdges$1.getSourcePolicy();
                                                if (!(option2 instanceof Some)) break block2;
                                                bl2 = true;
                                                some2 = (Some)option2;
                                                Enumeration.Value value = (Enumeration.Value)some2.x();
                                                Enumeration.Value value2 = KeyPolicy$.MODULE$.HASH();
                                                Enumeration.Value value3 = value;
                                                if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                                                string2 = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.HASH().toString(), edge.source()}));
                                                break block3;
                                            }
                                            if (!bl2) break block4;
                                            Enumeration.Value value = (Enumeration.Value)some2.x();
                                            Enumeration.Value value4 = KeyPolicy$.MODULE$.UUID();
                                            Enumeration.Value value5 = value;
                                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                                            string2 = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.UUID().toString(), edge.source()}));
                                            break block3;
                                        }
                                        if (!None$.MODULE$.equals(option2)) break block5;
                                        string2 = edge.source();
                                    }
                                    objectArray[2] = string2;
                                    bl = false;
                                    some = null;
                                    option = this.nebulaEdges$1.getTargetPolicy();
                                    if (!(option instanceof Some)) break block6;
                                    bl = true;
                                    some = (Some)option;
                                    Enumeration.Value value = (Enumeration.Value)some.x();
                                    Enumeration.Value value6 = KeyPolicy$.MODULE$.HASH();
                                    Enumeration.Value value7 = value;
                                    if (value6 != null ? !value6.equals(value7) : value7 != null) break block6;
                                    string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.HASH().toString(), edge.target()}));
                                    break block7;
                                }
                                if (!bl) break block8;
                                Enumeration.Value value = (Enumeration.Value)some.x();
                                Enumeration.Value value8 = KeyPolicy$.MODULE$.UUID();
                                Enumeration.Value value9 = value;
                                if (value8 != null ? !value8.equals(value9) : value9 != null) break block8;
                                string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.UUID().toString(), edge.target()}));
                                break block7;
                            }
                            if (!None$.MODULE$.equals(option)) break block9;
                            string = edge.target();
                        }
                        objectArray[3] = string;
                        objectArray[4] = rank;
                        objectArray[5] = ((TraversableOnce)edge.values().map((Function1)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.toUpdateExecuteStatement.2 $outer;
                            private final IntRef index$2;

                            /*
                             * WARNING - void declaration
                             */
                            public final String apply(Object value) {
                                void var2_2;
                                String updateValue = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.UPDATE_VALUE_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConversions$.MODULE$.seqAsJavaList(this.$outer.nebulaEdges$1.propNames()).get(this.index$2.elem), value}));
                                ++this.index$2.elem;
                                return var2_2;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.index$2 = index$2;
                            }
                        }, List$.MODULE$.canBuildFrom())).mkString(",");
                        return stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    }
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target policy ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nebulaEdges$1.getTargetPolicy().get()})));
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source policy ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nebulaEdges$1.getTargetPolicy().get()})));
            }
            {
                this.edgeName$1 = edgeName$1;
                this.nebulaEdges$1 = nebulaEdges$1;
            }
        }, List$.MODULE$.canBuildFrom())).mkString(";");
    }

    public String toDeleteExecuteStatement(package.NebulaVertices vertices, boolean deleteEdge) {
        return deleteEdge ? new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.DELETE_VERTEX_WITH_EDGE_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genDeleteVertexInfo(vertices)})) : new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.DELETE_VERTEX_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genDeleteVertexInfo(vertices)}));
    }

    private String genDeleteVertexInfo(package.NebulaVertices vertices) {
        return ((TraversableOnce)vertices.values().map((Function1)new Serializable(vertices){
            public static final long serialVersionUID = 0L;
            private final package.NebulaVertices vertices$2;

            public final String apply(package.NebulaVertex value) {
                block5: {
                    String string;
                    block3: {
                        Option<Enumeration.Value> option;
                        block4: {
                            Some some;
                            boolean bl;
                            block2: {
                                bl = false;
                                some = null;
                                option = this.vertices$2.policy();
                                if (!(option instanceof Some)) break block2;
                                bl = true;
                                some = (Some)option;
                                Enumeration.Value value2 = (Enumeration.Value)some.x();
                                Enumeration.Value value3 = KeyPolicy$.MODULE$.HASH();
                                Enumeration.Value value4 = value2;
                                if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                                string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.HASH().toString(), value.vertexIDSlice()}));
                                break block3;
                            }
                            if (!bl) break block4;
                            Enumeration.Value value5 = (Enumeration.Value)some.x();
                            Enumeration.Value value6 = KeyPolicy$.MODULE$.UUID();
                            Enumeration.Value value7 = value5;
                            if (value6 != null ? !value6.equals(value7) : value7 != null) break block4;
                            string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.UUID().toString(), value.vertexIDSlice()}));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block5;
                        string = value.vertexIDSlice();
                    }
                    return string;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vertex policy ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.vertices$2.policy().get()})));
            }
            {
                this.vertices$2 = vertices$2;
            }
        }, List$.MODULE$.canBuildFrom())).mkString(",");
    }

    public String toDeleteExecuteStatement(String edgeName, package.NebulaEdges edges) {
        return new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.DELETE_EDGE_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{edgeName, ((TraversableOnce)edges.values().map((Function1)new Serializable(edges){
            public static final long serialVersionUID = 0L;
            private final package.NebulaEdges edges$2;

            public final String apply(package.NebulaEdge value) {
                block5: {
                    block9: {
                        String string;
                        Object[] objectArray;
                        StringOps stringOps;
                        block7: {
                            Option<Enumeration.Value> option;
                            block8: {
                                Some some;
                                boolean bl;
                                block6: {
                                    String string2;
                                    block3: {
                                        Option<Enumeration.Value> option2;
                                        block4: {
                                            Some some2;
                                            boolean bl2;
                                            block2: {
                                                stringOps = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.EDGE_ENDPOINT_TEMPLATE()));
                                                objectArray = new Object[3];
                                                bl2 = false;
                                                some2 = null;
                                                option2 = this.edges$2.getSourcePolicy();
                                                if (!(option2 instanceof Some)) break block2;
                                                bl2 = true;
                                                some2 = (Some)option2;
                                                Enumeration.Value value2 = (Enumeration.Value)some2.x();
                                                Enumeration.Value value3 = KeyPolicy$.MODULE$.HASH();
                                                Enumeration.Value value4 = value2;
                                                if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                                                string2 = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.HASH().toString(), value.source()}));
                                                break block3;
                                            }
                                            if (!bl2) break block4;
                                            Enumeration.Value value5 = (Enumeration.Value)some2.x();
                                            Enumeration.Value value6 = KeyPolicy$.MODULE$.UUID();
                                            Enumeration.Value value7 = value5;
                                            if (value6 != null ? !value6.equals(value7) : value7 != null) break block4;
                                            string2 = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.UUID().toString(), value.source()}));
                                            break block3;
                                        }
                                        if (!None$.MODULE$.equals(option2)) break block5;
                                        string2 = value.source();
                                    }
                                    objectArray[0] = string2;
                                    bl = false;
                                    some = null;
                                    option = this.edges$2.getTargetPolicy();
                                    if (!(option instanceof Some)) break block6;
                                    bl = true;
                                    some = (Some)option;
                                    Enumeration.Value value8 = (Enumeration.Value)some.x();
                                    Enumeration.Value value9 = KeyPolicy$.MODULE$.HASH();
                                    Enumeration.Value value10 = value8;
                                    if (value9 != null ? !value9.equals(value10) : value10 != null) break block6;
                                    string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.HASH().toString(), value.target()}));
                                    break block7;
                                }
                                if (!bl) break block8;
                                Enumeration.Value value11 = (Enumeration.Value)some.x();
                                Enumeration.Value value12 = KeyPolicy$.MODULE$.UUID();
                                Enumeration.Value value13 = value11;
                                if (value12 != null ? !value12.equals(value13) : value13 != null) break block8;
                                string = new StringOps(Predef$.MODULE$.augmentString(NebulaTemplate$.MODULE$.ENDPOINT_TEMPLATE())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KeyPolicy$.MODULE$.UUID().toString(), value.target()}));
                                break block7;
                            }
                            if (!None$.MODULE$.equals(option)) break block9;
                            string = value.target();
                        }
                        objectArray[1] = string;
                        objectArray[2] = value.rank().isEmpty() ? BoxesRunTime.boxToInteger((int)0) : value.rank().get();
                        return stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                    }
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target vertex policy ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.edges$2.getTargetPolicy().get()})));
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source vertex policy ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.edges$2.getSourcePolicy().get()})));
            }
            {
                this.edges$2 = edges$2;
            }
        }, List$.MODULE$.canBuildFrom())).mkString(",")}));
    }

    public List<String> escapePropName(List<String> nebulaFields) {
        ListBuffer propNames = new ListBuffer();
        nebulaFields.foreach((Function1)new Serializable(propNames){
            public static final long serialVersionUID = 0L;
            private final ListBuffer propNames$1;

            public final void apply(String key) {
                StringBuilder sb = new StringBuilder();
                sb.append("`");
                sb.append(key);
                sb.append("`");
                this.propNames$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sb.toString()}));
            }
            {
                this.propNames$1 = propNames$1;
            }
        });
        return propNames.toList();
    }

    private NebulaExecutor$() {
        MODULE$ = this;
    }
}

