/*
 * Decompiled with CFR 0.152.
 */
package com.viafoura.metrics.datadog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TagUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TagUtils.class);

    TagUtils() {
    }

    public static List<String> mergeTags(List<String> tags1, List<String> tags2) {
        if (tags1 == null || tags1.isEmpty()) {
            return tags2;
        }
        if (tags2 == null || tags2.isEmpty()) {
            return tags1;
        }
        ArrayList<String> newTags = new ArrayList<String>();
        newTags.addAll(tags1);
        newTags.addAll(tags2);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : newTags) {
            int delimiterIndex = string.indexOf(":");
            int tagLength = string.length();
            if (tagLength < 1 || delimiterIndex <= 0 || delimiterIndex == tagLength - 1) {
                LOG.warn("Invalid tag: " + string);
                continue;
            }
            String key = string.substring(0, delimiterIndex);
            String value = string.substring(delimiterIndex + 1);
            map.put(key, value);
        }
        newTags.clear();
        for (Map.Entry entry : map.entrySet()) {
            newTags.add(entry.getKey() + ":" + entry.getValue());
        }
        return newTags;
    }
}

