/*
 * Decompiled with CFR 0.152.
 */
package com.vicrab.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import com.vicrab.Vicrab;
import com.vicrab.environment.VicrabEnvironment;
import com.vicrab.event.Event;
import com.vicrab.event.EventBuilder;
import com.vicrab.event.interfaces.ExceptionInterface;
import com.vicrab.event.interfaces.MessageInterface;
import com.vicrab.event.interfaces.StackTraceInterface;
import com.vicrab.event.interfaces.VicrabException;
import com.vicrab.event.interfaces.VicrabInterface;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VicrabAppender
extends AppenderBase<ILoggingEvent> {
    public static final String LOGBACK_MARKER = "logback-Marker";
    public static final String THREAD_NAME = "Vicrab-Threadname";
    @Deprecated
    protected Level minLevel;

    public VicrabAppender() {
        this.addFilter(new DropVicrabFilter());
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> arguments = new ArrayList<String>(parameters.length);
        for (Object argument : parameters) {
            arguments.add(argument != null ? argument.toString() : null);
        }
        return arguments;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual(Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual(Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    protected void append(ILoggingEvent iLoggingEvent) {
        if (this.isNotLoggable(iLoggingEvent) || VicrabEnvironment.isManagingThread()) {
            return;
        }
        VicrabEnvironment.startManagingThread();
        try {
            if (this.minLevel != null && !iLoggingEvent.getLevel().isGreaterOrEqual(this.minLevel)) {
                return;
            }
            EventBuilder eventBuilder = this.createEventBuilder(iLoggingEvent);
            Vicrab.capture((EventBuilder)eventBuilder);
        }
        catch (Exception e) {
            this.addError("An exception occurred while creating a new event in Vicrab", e);
        }
        finally {
            VicrabEnvironment.stopManagingThread();
        }
    }

    private boolean isNotLoggable(ILoggingEvent iLoggingEvent) {
        return this.minLevel != null && !iLoggingEvent.getLevel().isGreaterOrEqual(this.minLevel);
    }

    protected EventBuilder createEventBuilder(ILoggingEvent iLoggingEvent) {
        EventBuilder eventBuilder = new EventBuilder().withSdkIntegration("logback").withTimestamp(new Date(iLoggingEvent.getTimeStamp())).withMessage(iLoggingEvent.getFormattedMessage()).withLogger(iLoggingEvent.getLoggerName()).withLevel(VicrabAppender.formatLevel(iLoggingEvent.getLevel())).withExtra(THREAD_NAME, (Object)iLoggingEvent.getThreadName());
        if (iLoggingEvent.getArgumentArray() != null) {
            eventBuilder.withVicrabInterface((VicrabInterface)new MessageInterface(iLoggingEvent.getMessage(), VicrabAppender.formatMessageParameters(iLoggingEvent.getArgumentArray()), iLoggingEvent.getFormattedMessage()));
        }
        if (iLoggingEvent.getThrowableProxy() != null) {
            eventBuilder.withVicrabInterface((VicrabInterface)new ExceptionInterface(this.extractExceptionQueue(iLoggingEvent)));
        } else if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.withVicrabInterface((VicrabInterface)new StackTraceInterface(iLoggingEvent.getCallerData()));
        }
        for (Map.Entry contextEntry : iLoggingEvent.getLoggerContextVO().getPropertyMap().entrySet()) {
            eventBuilder.withExtra((String)contextEntry.getKey(), contextEntry.getValue());
        }
        for (Map.Entry mdcEntry : iLoggingEvent.getMDCPropertyMap().entrySet()) {
            if (Vicrab.getStoredClient().getMdcTags().contains(mdcEntry.getKey())) {
                eventBuilder.withTag((String)mdcEntry.getKey(), (String)mdcEntry.getValue());
                continue;
            }
            eventBuilder.withExtra((String)mdcEntry.getKey(), mdcEntry.getValue());
        }
        if (iLoggingEvent.getMarker() != null) {
            eventBuilder.withTag(LOGBACK_MARKER, iLoggingEvent.getMarker().getName());
        }
        return eventBuilder;
    }

    protected Deque<VicrabException> extractExceptionQueue(ILoggingEvent iLoggingEvent) {
        ArrayDeque<VicrabException> exceptions = new ArrayDeque<VicrabException>();
        HashSet<IThrowableProxy> circularityDetector = new HashSet<IThrowableProxy>();
        StackTraceElement[] enclosingStackTrace = new StackTraceElement[]{};
        for (IThrowableProxy throwableProxy = iLoggingEvent.getThrowableProxy(); throwableProxy != null; throwableProxy = throwableProxy.getCause()) {
            if (!circularityDetector.add(throwableProxy)) {
                this.addWarn("Exiting a circular exception!");
                break;
            }
            StackTraceElement[] stackTraceElements = this.toStackTraceElements(throwableProxy);
            StackTraceInterface stackTrace = new StackTraceInterface(stackTraceElements, enclosingStackTrace);
            exceptions.push(this.createVicrabExceptionFrom(throwableProxy, stackTrace));
            enclosingStackTrace = stackTraceElements;
        }
        return exceptions;
    }

    protected VicrabException createVicrabExceptionFrom(IThrowableProxy throwableProxy, StackTraceInterface stackTrace) {
        String exceptionMessage = throwableProxy.getMessage();
        String[] packageNameSimpleName = this.extractPackageSimpleClassName(throwableProxy.getClassName());
        String exceptionPackageName = packageNameSimpleName[0];
        String exceptionClassName = packageNameSimpleName[1];
        return new VicrabException(exceptionMessage, exceptionClassName, exceptionPackageName, stackTrace);
    }

    protected String[] extractPackageSimpleClassName(String canonicalClassName) {
        String[] packageNameSimpleName = new String[2];
        try {
            Class<?> exceptionClass = Class.forName(canonicalClassName);
            Package exceptionPackage = exceptionClass.getPackage();
            packageNameSimpleName[0] = exceptionPackage != null ? exceptionPackage.getName() : "(default)";
            packageNameSimpleName[1] = exceptionClass.getSimpleName();
        }
        catch (ClassNotFoundException e) {
            int lastDot = canonicalClassName.lastIndexOf(46);
            if (lastDot != -1) {
                packageNameSimpleName[0] = canonicalClassName.substring(0, lastDot);
                packageNameSimpleName[1] = canonicalClassName.substring(lastDot);
            }
            packageNameSimpleName[0] = "(default)";
            packageNameSimpleName[1] = canonicalClassName;
        }
        return packageNameSimpleName;
    }

    protected StackTraceElement[] toStackTraceElements(IThrowableProxy throwableProxy) {
        StackTraceElementProxy[] stackTraceElementProxies = throwableProxy.getStackTraceElementProxyArray();
        StackTraceElement[] stackTraceElements = new StackTraceElement[stackTraceElementProxies.length];
        int stackTraceElementsLength = stackTraceElementProxies.length;
        for (int i = 0; i < stackTraceElementsLength; ++i) {
            stackTraceElements[i] = stackTraceElementProxies[i].getStackTraceElement();
        }
        return stackTraceElements;
    }

    @Deprecated
    public void setMinLevel(String minLevel) {
        this.minLevel = minLevel != null ? Level.toLevel((String)minLevel) : null;
    }

    public void stop() {
        VicrabEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
            Vicrab.close();
        }
        catch (Exception e) {
            this.addError("An exception occurred while closing the Vicrab connection", e);
        }
        finally {
            VicrabEnvironment.stopManagingThread();
        }
    }

    private class DropVicrabFilter
    extends Filter<ILoggingEvent> {
        private DropVicrabFilter() {
        }

        public FilterReply decide(ILoggingEvent event) {
            String loggerName = event.getLoggerName();
            if (loggerName != null && loggerName.startsWith("com.vicrab")) {
                return FilterReply.DENY;
            }
            return FilterReply.NEUTRAL;
        }
    }
}

