/*
 * Decompiled with CFR 0.152.
 */
package com.viewpagerindicator;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.viewpagerindicator.PageIndicator;
import com.viewpagerindicator.R;
import com.viewpagerindicator.TitleProvider;
import java.util.ArrayList;

public class TitlePageIndicator
extends View
implements PageIndicator {
    private static final float SELECTION_FADE_PERCENTAGE = 0.25f;
    private static final float BOLD_FADE_PERCENTAGE = 0.05f;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private TitleProvider mTitleProvider;
    private int mCurrentPage;
    private int mCurrentOffset;
    private int mScrollState;
    private final Paint mPaintText = new Paint();
    private boolean mBoldText;
    private int mColorText;
    private int mColorSelected;
    private Path mPath;
    private final Paint mPaintFooterLine = new Paint();
    private IndicatorStyle mFooterIndicatorStyle;
    private final Paint mPaintFooterIndicator = new Paint();
    private float mFooterIndicatorHeight;
    private float mFooterIndicatorUnderlinePadding;
    private float mFooterPadding;
    private float mTitlePadding;
    private float mTopPadding;
    private float mClipPadding;
    private float mFooterLineHeight;
    private static final int INVALID_POINTER = -1;
    private int mTouchSlop;
    private float mLastMotionX = -1.0f;
    private int mActivePointerId = -1;
    private boolean mIsDragging;
    private OnCenterItemClickListener mCenterItemClickListener;

    public TitlePageIndicator(Context context) {
        this(context, null);
    }

    public TitlePageIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 2130771969);
    }

    public TitlePageIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Resources res = this.getResources();
        int defaultFooterColor = res.getColor(2131034123);
        float defaultFooterLineHeight = res.getDimension(2131230723);
        int defaultFooterIndicatorStyle = res.getInteger(2131165185);
        float defaultFooterIndicatorHeight = res.getDimension(2131230724);
        float defaultFooterIndicatorUnderlinePadding = res.getDimension(2131230725);
        float defaultFooterPadding = res.getDimension(2131230726);
        int defaultSelectedColor = res.getColor(2131034124);
        boolean defaultSelectedBold = res.getBoolean(2131099650);
        int defaultTextColor = res.getColor(2131034125);
        float defaultTextSize = res.getDimension(2131230727);
        float defaultTitlePadding = res.getDimension(2131230728);
        float defaultClipPadding = res.getDimension(2131230722);
        float defaultTopPadding = res.getDimension(2131230729);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TitlePageIndicator, defStyle, 2131296259);
        this.mFooterLineHeight = a.getDimension(2, defaultFooterLineHeight);
        this.mFooterIndicatorStyle = IndicatorStyle.fromValue(a.getInteger(3, defaultFooterIndicatorStyle));
        this.mFooterIndicatorHeight = a.getDimension(4, defaultFooterIndicatorHeight);
        this.mFooterIndicatorUnderlinePadding = a.getDimension(5, defaultFooterIndicatorUnderlinePadding);
        this.mFooterPadding = a.getDimension(6, defaultFooterPadding);
        this.mTopPadding = a.getDimension(12, defaultTopPadding);
        this.mTitlePadding = a.getDimension(11, defaultTitlePadding);
        this.mClipPadding = a.getDimension(0, defaultClipPadding);
        this.mColorSelected = a.getColor(7, defaultSelectedColor);
        this.mColorText = a.getColor(9, defaultTextColor);
        this.mBoldText = a.getBoolean(8, defaultSelectedBold);
        float textSize = a.getDimension(10, defaultTextSize);
        int footerColor = a.getColor(1, defaultFooterColor);
        this.mPaintText.setTextSize(textSize);
        this.mPaintText.setAntiAlias(true);
        this.mPaintFooterLine.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaintFooterLine.setStrokeWidth(this.mFooterLineHeight);
        this.mPaintFooterLine.setColor(footerColor);
        this.mPaintFooterIndicator.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaintFooterIndicator.setColor(footerColor);
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
    }

    public int getFooterColor() {
        return this.mPaintFooterLine.getColor();
    }

    public void setFooterColor(int footerColor) {
        this.mPaintFooterLine.setColor(footerColor);
        this.mPaintFooterIndicator.setColor(footerColor);
        this.invalidate();
    }

    public float getFooterLineHeight() {
        return this.mFooterLineHeight;
    }

    public void setFooterLineHeight(float footerLineHeight) {
        this.mFooterLineHeight = footerLineHeight;
        this.mPaintFooterLine.setStrokeWidth(this.mFooterLineHeight);
        this.invalidate();
    }

    public float getFooterIndicatorHeight() {
        return this.mFooterIndicatorHeight;
    }

    public void setFooterIndicatorHeight(float footerTriangleHeight) {
        this.mFooterIndicatorHeight = footerTriangleHeight;
        this.invalidate();
    }

    public float getFooterIndicatorPadding() {
        return this.mFooterPadding;
    }

    public void setFooterIndicatorPadding(float footerIndicatorPadding) {
        this.mFooterPadding = footerIndicatorPadding;
        this.invalidate();
    }

    public IndicatorStyle getFooterIndicatorStyle() {
        return this.mFooterIndicatorStyle;
    }

    public void setFooterIndicatorStyle(IndicatorStyle indicatorStyle) {
        this.mFooterIndicatorStyle = indicatorStyle;
        this.invalidate();
    }

    public int getSelectedColor() {
        return this.mColorSelected;
    }

    public void setSelectedColor(int selectedColor) {
        this.mColorSelected = selectedColor;
        this.invalidate();
    }

    public boolean isSelectedBold() {
        return this.mBoldText;
    }

    public void setSelectedBold(boolean selectedBold) {
        this.mBoldText = selectedBold;
        this.invalidate();
    }

    public int getTextColor() {
        return this.mColorText;
    }

    public void setTextColor(int textColor) {
        this.mPaintText.setColor(textColor);
        this.mColorText = textColor;
        this.invalidate();
    }

    public float getTextSize() {
        return this.mPaintText.getTextSize();
    }

    public void setTextSize(float textSize) {
        this.mPaintText.setTextSize(textSize);
        this.invalidate();
    }

    public float getTitlePadding() {
        return this.mTitlePadding;
    }

    public void setTitlePadding(float titlePadding) {
        this.mTitlePadding = titlePadding;
        this.invalidate();
    }

    public float getTopPadding() {
        return this.mTopPadding;
    }

    public void setTopPadding(float topPadding) {
        this.mTopPadding = topPadding;
        this.invalidate();
    }

    public float getClipPadding() {
        return this.mClipPadding;
    }

    public void setClipPadding(float clipPadding) {
        this.mClipPadding = clipPadding;
        this.invalidate();
    }

    public void setTypeface(Typeface typeface) {
        this.mPaintText.setTypeface(typeface);
        this.invalidate();
    }

    public Typeface getTypeface() {
        return this.mPaintText.getTypeface();
    }

    protected void onDraw(Canvas canvas) {
        float w;
        RectF bound;
        int i;
        float offsetPercent;
        super.onDraw(canvas);
        if (this.mViewPager == null) {
            return;
        }
        int count = this.mViewPager.getAdapter().getCount();
        if (count == 0) {
            return;
        }
        ArrayList<RectF> bounds = this.calculateAllBounds(this.mPaintText);
        int boundsSize = bounds.size();
        if (this.mCurrentPage >= boundsSize) {
            this.setCurrentItem(boundsSize - 1);
            return;
        }
        int countMinusOne = count - 1;
        float halfWidth = (float)this.getWidth() / 2.0f;
        int left = this.getLeft();
        float leftClip = (float)left + this.mClipPadding;
        int width = this.getWidth();
        int height = this.getHeight();
        int right = left + width;
        float rightClip = (float)right - this.mClipPadding;
        int page = this.mCurrentPage;
        if ((float)this.mCurrentOffset <= halfWidth) {
            offsetPercent = 1.0f * (float)this.mCurrentOffset / (float)width;
        } else {
            ++page;
            offsetPercent = 1.0f * (float)(width - this.mCurrentOffset) / (float)width;
        }
        boolean currentSelected = offsetPercent <= 0.25f;
        boolean currentBold = offsetPercent <= 0.05f;
        float selectedPercent = (0.25f - offsetPercent) / 0.25f;
        RectF curPageBound = bounds.get(this.mCurrentPage);
        float curPageWidth = curPageBound.right - curPageBound.left;
        if (curPageBound.left < leftClip) {
            this.clipViewOnTheLeft(curPageBound, curPageWidth, left);
        }
        if (curPageBound.right > rightClip) {
            this.clipViewOnTheRight(curPageBound, curPageWidth, right);
        }
        if (this.mCurrentPage > 0) {
            for (i = this.mCurrentPage - 1; i >= 0; --i) {
                bound = bounds.get(i);
                if (!(bound.left < leftClip)) continue;
                w = bound.right - bound.left;
                this.clipViewOnTheLeft(bound, w, left);
                RectF rightBound = bounds.get(i + 1);
                if (!(bound.right + this.mTitlePadding > rightBound.left)) continue;
                bound.left = rightBound.left - w - this.mTitlePadding;
                bound.right = bound.left + w;
            }
        }
        if (this.mCurrentPage < countMinusOne) {
            for (i = this.mCurrentPage + 1; i < count; ++i) {
                bound = bounds.get(i);
                if (!(bound.right > rightClip)) continue;
                w = bound.right - bound.left;
                this.clipViewOnTheRight(bound, w, right);
                RectF leftBound = bounds.get(i - 1);
                if (!(bound.left - this.mTitlePadding < leftBound.right)) continue;
                bound.left = leftBound.right + this.mTitlePadding;
                bound.right = bound.left + w;
            }
        }
        int colorTextAlpha = this.mColorText >>> 24;
        for (int i2 = 0; i2 < count; ++i2) {
            RectF bound2 = bounds.get(i2);
            if (!(bound2.left > (float)left && bound2.left < (float)right) && (!(bound2.right > (float)left) || !(bound2.right < (float)right))) continue;
            boolean currentPage = i2 == page;
            this.mPaintText.setFakeBoldText(currentPage && currentBold && this.mBoldText);
            this.mPaintText.setColor(this.mColorText);
            if (currentPage && currentSelected) {
                this.mPaintText.setAlpha(colorTextAlpha - (int)((float)colorTextAlpha * selectedPercent));
            }
            canvas.drawText(this.mTitleProvider.getTitle(i2), bound2.left, bound2.bottom + this.mTopPadding, this.mPaintText);
            if (!currentPage || !currentSelected) continue;
            this.mPaintText.setColor(this.mColorSelected);
            this.mPaintText.setAlpha((int)((float)(this.mColorSelected >>> 24) * selectedPercent));
            canvas.drawText(this.mTitleProvider.getTitle(i2), bound2.left, bound2.bottom + this.mTopPadding, this.mPaintText);
        }
        this.mPath = new Path();
        this.mPath.moveTo(0.0f, (float)height - this.mFooterLineHeight / 2.0f);
        this.mPath.lineTo((float)width, (float)height - this.mFooterLineHeight / 2.0f);
        this.mPath.close();
        canvas.drawPath(this.mPath, this.mPaintFooterLine);
        switch (this.mFooterIndicatorStyle) {
            case Triangle: {
                this.mPath = new Path();
                this.mPath.moveTo(halfWidth, (float)height - this.mFooterLineHeight - this.mFooterIndicatorHeight);
                this.mPath.lineTo(halfWidth + this.mFooterIndicatorHeight, (float)height - this.mFooterLineHeight);
                this.mPath.lineTo(halfWidth - this.mFooterIndicatorHeight, (float)height - this.mFooterLineHeight);
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mPaintFooterIndicator);
                break;
            }
            case Underline: {
                if (!currentSelected || page >= boundsSize) break;
                RectF underlineBounds = bounds.get(page);
                this.mPath = new Path();
                this.mPath.moveTo(underlineBounds.left - this.mFooterIndicatorUnderlinePadding, (float)height - this.mFooterLineHeight);
                this.mPath.lineTo(underlineBounds.right + this.mFooterIndicatorUnderlinePadding, (float)height - this.mFooterLineHeight);
                this.mPath.lineTo(underlineBounds.right + this.mFooterIndicatorUnderlinePadding, (float)height - this.mFooterLineHeight - this.mFooterIndicatorHeight);
                this.mPath.lineTo(underlineBounds.left - this.mFooterIndicatorUnderlinePadding, (float)height - this.mFooterLineHeight - this.mFooterIndicatorHeight);
                this.mPath.close();
                this.mPaintFooterIndicator.setAlpha((int)(255.0f * selectedPercent));
                canvas.drawPath(this.mPath, this.mPaintFooterIndicator);
                this.mPaintFooterIndicator.setAlpha(255);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (super.onTouchEvent(ev)) {
            return true;
        }
        if (this.mViewPager == null || this.mViewPager.getAdapter().getCount() == 0) {
            return false;
        }
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mLastMotionX = ev.getX();
                break;
            }
            case 2: {
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                float x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                float deltaX = x - this.mLastMotionX;
                if (!this.mIsDragging && Math.abs(deltaX) > (float)this.mTouchSlop) {
                    this.mIsDragging = true;
                }
                if (!this.mIsDragging) break;
                if (!this.mViewPager.isFakeDragging()) {
                    this.mViewPager.beginFakeDrag();
                }
                this.mLastMotionX = x;
                this.mViewPager.fakeDragBy(deltaX);
                break;
            }
            case 1: 
            case 3: {
                if (!this.mIsDragging) {
                    int count = this.mViewPager.getAdapter().getCount();
                    int width = this.getWidth();
                    float halfWidth = (float)width / 2.0f;
                    float sixthWidth = (float)width / 6.0f;
                    float leftThird = halfWidth - sixthWidth;
                    float rightThird = halfWidth + sixthWidth;
                    float eventX = ev.getX();
                    if (eventX < leftThird) {
                        if (this.mCurrentPage > 0) {
                            this.mViewPager.setCurrentItem(this.mCurrentPage - 1);
                            return true;
                        }
                    } else if (eventX > rightThird) {
                        if (this.mCurrentPage < count - 1) {
                            this.mViewPager.setCurrentItem(this.mCurrentPage + 1);
                            return true;
                        }
                    } else if (this.mCenterItemClickListener != null) {
                        this.mCenterItemClickListener.onCenterItemClick(this.mCurrentPage);
                    }
                }
                this.mIsDragging = false;
                this.mActivePointerId = -1;
                if (!this.mViewPager.isFakeDragging()) break;
                this.mViewPager.endFakeDrag();
                break;
            }
            case 5: {
                float x;
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastMotionX = x = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                if (pointerId == this.mActivePointerId) {
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
                }
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
            }
        }
        return true;
    }

    private void clipViewOnTheRight(RectF curViewBound, float curViewWidth, int right) {
        curViewBound.right = (float)right - this.mClipPadding;
        curViewBound.left = curViewBound.right - curViewWidth;
    }

    private void clipViewOnTheLeft(RectF curViewBound, float curViewWidth, int left) {
        curViewBound.left = (float)left + this.mClipPadding;
        curViewBound.right = this.mClipPadding + curViewWidth;
    }

    private ArrayList<RectF> calculateAllBounds(Paint paint) {
        ArrayList<RectF> list = new ArrayList<RectF>();
        int count = this.mViewPager.getAdapter().getCount();
        int width = this.getWidth();
        int halfWidth = width / 2;
        for (int i = 0; i < count; ++i) {
            RectF bounds = this.calcBounds(i, paint);
            float w = bounds.right - bounds.left;
            float h = bounds.bottom - bounds.top;
            bounds.left = (float)halfWidth - w / 2.0f - (float)this.mCurrentOffset + (float)((i - this.mCurrentPage) * width);
            bounds.right = bounds.left + w;
            bounds.top = 0.0f;
            bounds.bottom = h;
            list.add(bounds);
        }
        return list;
    }

    private RectF calcBounds(int index, Paint paint) {
        RectF bounds = new RectF();
        bounds.right = paint.measureText(this.mTitleProvider.getTitle(index));
        bounds.bottom = paint.descent() - paint.ascent();
        return bounds;
    }

    @Override
    public void setViewPager(ViewPager view) {
        PagerAdapter adapter = view.getAdapter();
        if (adapter == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        if (!(adapter instanceof TitleProvider)) {
            throw new IllegalStateException("ViewPager adapter must implement TitleProvider to be used with TitlePageIndicator.");
        }
        this.mViewPager = view;
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mTitleProvider = (TitleProvider)adapter;
        this.invalidate();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    @Override
    public void notifyDataSetChanged() {
        this.invalidate();
    }

    public void setOnCenterItemClickListener(OnCenterItemClickListener listener) {
        this.mCenterItemClickListener = listener;
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mViewPager.setCurrentItem(item);
        this.mCurrentPage = item;
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
        this.mScrollState = state;
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mCurrentPage = position;
        this.mCurrentOffset = positionOffsetPixels;
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mScrollState == 0) {
            this.mCurrentPage = position;
            this.invalidate();
        }
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float height = 0.0f;
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightSpecMode == 0x40000000) {
            height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        } else {
            RectF bounds = new RectF();
            bounds.bottom = this.mPaintText.descent() - this.mPaintText.ascent();
            height = bounds.bottom - bounds.top + this.mFooterLineHeight + this.mFooterPadding + this.mTopPadding;
            if (this.mFooterIndicatorStyle != IndicatorStyle.None) {
                height += this.mFooterIndicatorHeight;
            }
        }
        int measuredHeight = (int)height;
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mCurrentPage = savedState.currentPage;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPage = this.mCurrentPage;
        return savedState;
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPage;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPage = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPage);
        }
    }

    public static enum IndicatorStyle {
        None(0),
        Triangle(1),
        Underline(2);

        public final int value;

        private IndicatorStyle(int value) {
            this.value = value;
        }

        public static IndicatorStyle fromValue(int value) {
            for (IndicatorStyle style2 : IndicatorStyle.values()) {
                if (style2.value != value) continue;
                return style2;
            }
            return null;
        }
    }

    public static interface OnCenterItemClickListener {
        public void onCenterItemClick(int var1);
    }
}

