/*
 * Decompiled with CFR 0.152.
 */
package com.viewpagerindicator.sample;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListSamples
extends ListActivity {
    private static final Comparator<Map<String, Object>> sDisplayNameComparator = new Comparator<Map<String, Object>>(){
        private final Collator collator = Collator.getInstance();

        @Override
        public int compare(Map<String, Object> map1, Map<String, Object> map2) {
            return this.collator.compare(map1.get("title"), map2.get("title"));
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        String path = intent.getStringExtra("com.jakewharton.android.viewpagerindicator.sample.Path");
        if (path == null) {
            path = "";
        }
        this.setListAdapter((ListAdapter)new SimpleAdapter((Context)this, this.getData(path), 17367043, new String[]{"title"}, new int[]{16908308}));
        this.getListView().setTextFilterEnabled(true);
    }

    protected List<Map<String, Object>> getData(String prefix) {
        String[] prefixPath;
        ArrayList<Map<String, Object>> myData = new ArrayList<Map<String, Object>>();
        Intent mainIntent = new Intent("android.intent.action.MAIN", null);
        mainIntent.addCategory("com.jakewharton.android.viewpagerindicator.sample.SAMPLE");
        PackageManager pm = this.getPackageManager();
        List list = pm.queryIntentActivities(mainIntent, 0);
        if (null == list) {
            return myData;
        }
        String prefixWithSlash = prefix;
        if (prefix.equals("")) {
            prefixPath = null;
        } else {
            prefixPath = prefix.split("/");
            prefixWithSlash = prefix + "/";
        }
        int len = list.size();
        HashMap<String, Boolean> entries = new HashMap<String, Boolean>();
        for (int i = 0; i < len; ++i) {
            String label;
            ResolveInfo info = (ResolveInfo)list.get(i);
            CharSequence labelSeq = info.loadLabel(pm);
            String string = label = labelSeq != null ? ((Object)labelSeq).toString() : info.activityInfo.name;
            if (prefixWithSlash.length() != 0 && !label.startsWith(prefixWithSlash)) continue;
            String[] labelPath = label.split("/");
            String nextLabel = prefixPath == null ? labelPath[0] : labelPath[prefixPath.length];
            if ((prefixPath != null ? prefixPath.length : 0) == labelPath.length - 1) {
                this.addItem(myData, nextLabel, this.activityIntent(info.activityInfo.applicationInfo.packageName, info.activityInfo.name));
                continue;
            }
            if (entries.get(nextLabel) != null) continue;
            this.addItem(myData, nextLabel, this.browseIntent(prefix.equals("") ? nextLabel : prefix + "/" + nextLabel));
            entries.put(nextLabel, true);
        }
        Collections.sort(myData, sDisplayNameComparator);
        return myData;
    }

    protected Intent activityIntent(String pkg, String componentName) {
        Intent result = new Intent();
        result.setClassName(pkg, componentName);
        return result;
    }

    protected Intent browseIntent(String path) {
        Intent result = new Intent();
        result.setClass((Context)this, ListSamples.class);
        result.putExtra("com.jakewharton.android.viewpagerindicator.sample.Path", path);
        return result;
    }

    protected void addItem(List<Map<String, Object>> data, String name, Intent intent) {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("title", name);
        temp.put("intent", (String)intent);
        data.add(temp);
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Map map = (Map)l.getItemAtPosition(position);
        Intent intent = (Intent)map.get("intent");
        this.startActivity(intent);
    }
}

