/*
 * Decompiled with CFR 0.152.
 */
package com.viewpagerindicator;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.viewpagerindicator.PageIndicator;
import com.viewpagerindicator.R;

public class CirclePageIndicator
extends View
implements PageIndicator {
    private static final int INVALID_POINTER = -1;
    private float mRadius;
    private final Paint mPaintPageFill = new Paint(1);
    private final Paint mPaintStroke = new Paint(1);
    private final Paint mPaintFill = new Paint(1);
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private int mCurrentPage;
    private int mSnapPage;
    private float mPageOffset;
    private int mScrollState;
    private int mOrientation;
    private boolean mCentered;
    private boolean mSnap;
    private int mTouchSlop;
    private float mLastMotionX = -1.0f;
    private int mActivePointerId = -1;
    private boolean mIsDragging;

    public CirclePageIndicator(Context context) {
        this(context, null);
    }

    public CirclePageIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 2130771968);
    }

    public CirclePageIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.isInEditMode()) {
            return;
        }
        Resources res = this.getResources();
        int defaultPageColor = res.getColor(2131034121);
        int defaultFillColor = res.getColor(2131034120);
        int defaultOrientation = res.getInteger(0x7F070000);
        int defaultStrokeColor = res.getColor(2131034122);
        float defaultStrokeWidth = res.getDimension(2131230721);
        float defaultRadius = res.getDimension(2131230720);
        boolean defaultCentered = res.getBoolean(2131099648);
        boolean defaultSnap = res.getBoolean(2131099649);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CirclePageIndicator, defStyle, 0);
        this.mCentered = a.getBoolean(1, defaultCentered);
        this.mOrientation = a.getInt(0, defaultOrientation);
        this.mPaintPageFill.setStyle(Paint.Style.FILL);
        this.mPaintPageFill.setColor(a.getColor(4, defaultPageColor));
        this.mPaintStroke.setStyle(Paint.Style.STROKE);
        this.mPaintStroke.setColor(a.getColor(7, defaultStrokeColor));
        this.mPaintStroke.setStrokeWidth(a.getDimension(2, defaultStrokeWidth));
        this.mPaintFill.setStyle(Paint.Style.FILL);
        this.mPaintFill.setColor(a.getColor(3, defaultFillColor));
        this.mRadius = a.getDimension(5, defaultRadius);
        this.mSnap = a.getBoolean(6, defaultSnap);
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
    }

    public void setCentered(boolean centered) {
        this.mCentered = centered;
        this.invalidate();
    }

    public boolean isCentered() {
        return this.mCentered;
    }

    public void setPageColor(int pageColor) {
        this.mPaintPageFill.setColor(pageColor);
        this.invalidate();
    }

    public int getPageColor() {
        return this.mPaintPageFill.getColor();
    }

    public void setFillColor(int fillColor) {
        this.mPaintFill.setColor(fillColor);
        this.invalidate();
    }

    public int getFillColor() {
        return this.mPaintFill.getColor();
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                this.mOrientation = orientation;
                this.requestLayout();
                break;
            }
            default: {
                throw new IllegalArgumentException("Orientation must be either HORIZONTAL or VERTICAL.");
            }
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setStrokeColor(int strokeColor) {
        this.mPaintStroke.setColor(strokeColor);
        this.invalidate();
    }

    public int getStrokeColor() {
        return this.mPaintStroke.getColor();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.mPaintStroke.setStrokeWidth(strokeWidth);
        this.invalidate();
    }

    public float getStrokeWidth() {
        return this.mPaintStroke.getStrokeWidth();
    }

    public void setRadius(float radius) {
        this.mRadius = radius;
        this.invalidate();
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void setSnap(boolean snap) {
        this.mSnap = snap;
        this.invalidate();
    }

    public boolean isSnap() {
        return this.mSnap;
    }

    protected void onDraw(Canvas canvas) {
        float dY;
        float dX;
        int shortPaddingBefore;
        int longPaddingAfter;
        int longPaddingBefore;
        int longSize;
        super.onDraw(canvas);
        if (this.mViewPager == null) {
            return;
        }
        int count = this.mViewPager.getAdapter().getCount();
        if (count == 0) {
            return;
        }
        if (this.mCurrentPage >= count) {
            this.setCurrentItem(count - 1);
            return;
        }
        if (this.mOrientation == 0) {
            longSize = this.getWidth();
            longPaddingBefore = this.getPaddingLeft();
            longPaddingAfter = this.getPaddingRight();
            shortPaddingBefore = this.getPaddingTop();
        } else {
            longSize = this.getHeight();
            longPaddingBefore = this.getPaddingTop();
            longPaddingAfter = this.getPaddingBottom();
            shortPaddingBefore = this.getPaddingLeft();
        }
        float threeRadius = this.mRadius * 3.0f;
        float shortOffset = (float)shortPaddingBefore + this.mRadius;
        float longOffset = (float)longPaddingBefore + this.mRadius;
        if (this.mCentered) {
            longOffset += (float)(longSize - longPaddingBefore - longPaddingAfter) / 2.0f - (float)count * threeRadius / 2.0f;
        }
        float pageFillRadius = this.mRadius;
        if (this.mPaintStroke.getStrokeWidth() > 0.0f) {
            pageFillRadius -= this.mPaintStroke.getStrokeWidth() / 2.0f;
        }
        for (int iLoop = 0; iLoop < count; ++iLoop) {
            float drawLong = longOffset + (float)iLoop * threeRadius;
            if (this.mOrientation == 0) {
                dX = drawLong;
                dY = shortOffset;
            } else {
                dX = shortOffset;
                dY = drawLong;
            }
            if (this.mPaintPageFill.getAlpha() > 0) {
                canvas.drawCircle(dX, dY, pageFillRadius, this.mPaintPageFill);
            }
            if (pageFillRadius == this.mRadius) continue;
            canvas.drawCircle(dX, dY, this.mRadius, this.mPaintStroke);
        }
        float cx = (float)(this.mSnap ? this.mSnapPage : this.mCurrentPage) * threeRadius;
        if (!this.mSnap) {
            cx += this.mPageOffset * threeRadius;
        }
        if (this.mOrientation == 0) {
            dX = longOffset + cx;
            dY = shortOffset;
        } else {
            dX = shortOffset;
            dY = longOffset + cx;
        }
        canvas.drawCircle(dX, dY, this.mRadius, this.mPaintFill);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (super.onTouchEvent(ev)) {
            return true;
        }
        if (this.mViewPager == null || this.mViewPager.getAdapter().getCount() == 0) {
            return false;
        }
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mLastMotionX = ev.getX();
                break;
            }
            case 2: {
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                float x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                float deltaX = x - this.mLastMotionX;
                if (!this.mIsDragging && Math.abs(deltaX) > (float)this.mTouchSlop) {
                    this.mIsDragging = true;
                }
                if (!this.mIsDragging) break;
                this.mLastMotionX = x;
                if (!this.mViewPager.isFakeDragging() && !this.mViewPager.beginFakeDrag()) break;
                this.mViewPager.fakeDragBy(deltaX);
                break;
            }
            case 1: 
            case 3: {
                if (!this.mIsDragging) {
                    int count = this.mViewPager.getAdapter().getCount();
                    int width = this.getWidth();
                    float halfWidth = (float)width / 2.0f;
                    float sixthWidth = (float)width / 6.0f;
                    if (this.mCurrentPage > 0 && ev.getX() < halfWidth - sixthWidth) {
                        this.mViewPager.setCurrentItem(this.mCurrentPage - 1);
                        return true;
                    }
                    if (this.mCurrentPage < count - 1 && ev.getX() > halfWidth + sixthWidth) {
                        this.mViewPager.setCurrentItem(this.mCurrentPage + 1);
                        return true;
                    }
                }
                this.mIsDragging = false;
                this.mActivePointerId = -1;
                if (!this.mViewPager.isFakeDragging()) break;
                this.mViewPager.endFakeDrag();
                break;
            }
            case 5: {
                float x;
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastMotionX = x = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                if (pointerId == this.mActivePointerId) {
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
                }
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
            }
        }
        return true;
    }

    @Override
    public void setViewPager(ViewPager view) {
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (view.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = view;
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mViewPager.setCurrentItem(item);
        this.mCurrentPage = item;
        this.invalidate();
    }

    @Override
    public void notifyDataSetChanged() {
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
        this.mScrollState = state;
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mCurrentPage = position;
        this.mPageOffset = positionOffset;
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mSnap || this.mScrollState == 0) {
            this.mCurrentPage = position;
            this.mSnapPage = position;
            this.invalidate();
        }
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOrientation == 0) {
            this.setMeasuredDimension(this.measureLong(widthMeasureSpec), this.measureShort(heightMeasureSpec));
        } else {
            this.setMeasuredDimension(this.measureShort(widthMeasureSpec), this.measureLong(heightMeasureSpec));
        }
    }

    private int measureLong(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000 || this.mViewPager == null) {
            result = specSize;
        } else {
            int count = this.mViewPager.getAdapter().getCount();
            result = (int)((float)(this.getPaddingLeft() + this.getPaddingRight()) + (float)(count * 2) * this.mRadius + (float)(count - 1) * this.mRadius + 1.0f);
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureShort(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = (int)(2.0f * this.mRadius + (float)this.getPaddingTop() + (float)this.getPaddingBottom() + 1.0f);
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mCurrentPage = savedState.currentPage;
        this.mSnapPage = savedState.currentPage;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPage = this.mCurrentPage;
        return savedState;
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPage;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPage = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPage);
        }
    }
}

