/*
 * Decompiled with CFR 0.152.
 */
package com.viewpagerindicator;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import com.viewpagerindicator.IconPagerAdapter;
import com.viewpagerindicator.IcsLinearLayout;
import com.viewpagerindicator.PageIndicator;

public class IconPageIndicator
extends HorizontalScrollView
implements PageIndicator {
    private final IcsLinearLayout mIconsLayout;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private Runnable mIconSelector;
    private int mSelectedIndex;

    public IconPageIndicator(Context context) {
        this(context, null);
    }

    public IconPageIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setHorizontalScrollBarEnabled(false);
        this.mIconsLayout = new IcsLinearLayout(context, 2130771969);
        this.addView((View)this.mIconsLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 17));
    }

    private void animateToIcon(int position) {
        final View iconView = this.mIconsLayout.getChildAt(position);
        if (this.mIconSelector != null) {
            this.removeCallbacks(this.mIconSelector);
        }
        this.mIconSelector = new Runnable(){

            @Override
            public void run() {
                int scrollPos = iconView.getLeft() - (IconPageIndicator.this.getWidth() - iconView.getWidth()) / 2;
                IconPageIndicator.this.smoothScrollTo(scrollPos, 0);
                IconPageIndicator.this.mIconSelector = null;
            }
        };
        this.post(this.mIconSelector);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIconSelector != null) {
            this.post(this.mIconSelector);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mIconSelector != null) {
            this.removeCallbacks(this.mIconSelector);
        }
    }

    public void onPageScrollStateChanged(int arg0) {
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(arg0);
        }
    }

    public void onPageScrolled(int arg0, float arg1, int arg2) {
        if (this.mListener != null) {
            this.mListener.onPageScrolled(arg0, arg1, arg2);
        }
    }

    public void onPageSelected(int arg0) {
        this.setCurrentItem(arg0);
        if (this.mListener != null) {
            this.mListener.onPageSelected(arg0);
        }
    }

    @Override
    public void setViewPager(ViewPager view) {
        PagerAdapter adapter;
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if ((adapter = view.getAdapter()) == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = view;
        view.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.notifyDataSetChanged();
    }

    @Override
    public void notifyDataSetChanged() {
        this.mIconsLayout.removeAllViews();
        IconPagerAdapter iconAdapter = (IconPagerAdapter)this.mViewPager.getAdapter();
        int count = iconAdapter.getCount();
        for (int i = 0; i < count; ++i) {
            ImageView view = new ImageView(this.getContext(), null, 2130771969);
            view.setImageResource(iconAdapter.getIconResId(i));
            this.mIconsLayout.addView((View)view);
        }
        if (this.mSelectedIndex > count) {
            this.mSelectedIndex = count - 1;
        }
        this.setCurrentItem(this.mSelectedIndex);
        this.requestLayout();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mSelectedIndex = item;
        this.mViewPager.setCurrentItem(item);
        int tabCount = this.mIconsLayout.getChildCount();
        for (int i = 0; i < tabCount; ++i) {
            View child = this.mIconsLayout.getChildAt(i);
            boolean isSelected = i == item;
            child.setSelected(isSelected);
            if (!isSelected) continue;
            this.animateToIcon(item);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }
}

