/*
 * Decompiled with CFR 0.152.
 */
package com.viewpagerindicator;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.viewpagerindicator.PageIndicator;
import com.viewpagerindicator.R;

public class LinePageIndicator
extends View
implements PageIndicator {
    private static final int INVALID_POINTER = -1;
    private final Paint mPaintUnselected = new Paint(1);
    private final Paint mPaintSelected = new Paint(1);
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private int mCurrentPage;
    private boolean mCentered;
    private float mLineWidth;
    private float mGapWidth;
    private int mTouchSlop;
    private float mLastMotionX = -1.0f;
    private int mActivePointerId = -1;
    private boolean mIsDragging;

    public LinePageIndicator(Context context) {
        this(context, null);
    }

    public LinePageIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 2130771970);
    }

    public LinePageIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.isInEditMode()) {
            return;
        }
        Resources res = this.getResources();
        int defaultSelectedColor = res.getColor(2131034123);
        int defaultUnselectedColor = res.getColor(2131034124);
        float defaultLineWidth = res.getDimension(2131230722);
        float defaultGapWidth = res.getDimension(2131230723);
        float defaultStrokeWidth = res.getDimension(2131230724);
        boolean defaultCentered = res.getBoolean(2131099650);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LinePageIndicator, defStyle, 0);
        this.mCentered = a.getBoolean(1, defaultCentered);
        this.mLineWidth = a.getDimension(5, defaultLineWidth);
        this.mGapWidth = a.getDimension(6, defaultGapWidth);
        this.setStrokeWidth(a.getDimension(3, defaultStrokeWidth));
        this.mPaintUnselected.setColor(a.getColor(4, defaultUnselectedColor));
        this.mPaintSelected.setColor(a.getColor(2, defaultSelectedColor));
        Drawable background = a.getDrawable(1);
        if (background != null) {
            this.setBackgroundDrawable(background);
        }
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
    }

    public void setCentered(boolean centered) {
        this.mCentered = centered;
        this.invalidate();
    }

    public boolean isCentered() {
        return this.mCentered;
    }

    public void setUnselectedColor(int unselectedColor) {
        this.mPaintUnselected.setColor(unselectedColor);
        this.invalidate();
    }

    public int getUnselectedColor() {
        return this.mPaintUnselected.getColor();
    }

    public void setSelectedColor(int selectedColor) {
        this.mPaintSelected.setColor(selectedColor);
        this.invalidate();
    }

    public int getSelectedColor() {
        return this.mPaintSelected.getColor();
    }

    public void setLineWidth(float lineWidth) {
        this.mLineWidth = lineWidth;
        this.invalidate();
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public void setStrokeWidth(float lineHeight) {
        this.mPaintSelected.setStrokeWidth(lineHeight);
        this.mPaintUnselected.setStrokeWidth(lineHeight);
        this.invalidate();
    }

    public float getStrokeWidth() {
        return this.mPaintSelected.getStrokeWidth();
    }

    public void setGapWidth(float gapWidth) {
        this.mGapWidth = gapWidth;
        this.invalidate();
    }

    public float getGapWidth() {
        return this.mGapWidth;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mViewPager == null) {
            return;
        }
        int count = this.mViewPager.getAdapter().getCount();
        if (count == 0) {
            return;
        }
        if (this.mCurrentPage >= count) {
            this.setCurrentItem(count - 1);
            return;
        }
        float lineWidthAndGap = this.mLineWidth + this.mGapWidth;
        float indicatorWidth = (float)count * lineWidthAndGap - this.mGapWidth;
        float paddingTop = this.getPaddingTop();
        float paddingLeft = this.getPaddingLeft();
        float paddingRight = this.getPaddingRight();
        float verticalOffset = paddingTop + ((float)this.getHeight() - paddingTop - (float)this.getPaddingBottom()) / 2.0f;
        float horizontalOffset = paddingLeft;
        if (this.mCentered) {
            horizontalOffset += ((float)this.getWidth() - paddingLeft - paddingRight) / 2.0f - indicatorWidth / 2.0f;
        }
        for (int i = 0; i < count; ++i) {
            float dx1 = horizontalOffset + (float)i * lineWidthAndGap;
            float dx2 = dx1 + this.mLineWidth;
            canvas.drawLine(dx1, verticalOffset, dx2, verticalOffset, i == this.mCurrentPage ? this.mPaintSelected : this.mPaintUnselected);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (super.onTouchEvent(ev)) {
            return true;
        }
        if (this.mViewPager == null || this.mViewPager.getAdapter().getCount() == 0) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mLastMotionX = ev.getX();
                break;
            }
            case 2: {
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                float x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                float deltaX = x - this.mLastMotionX;
                if (!this.mIsDragging && Math.abs(deltaX) > (float)this.mTouchSlop) {
                    this.mIsDragging = true;
                }
                if (!this.mIsDragging) break;
                this.mLastMotionX = x;
                if (!this.mViewPager.isFakeDragging() && !this.mViewPager.beginFakeDrag()) break;
                this.mViewPager.fakeDragBy(deltaX);
                break;
            }
            case 1: 
            case 3: {
                if (!this.mIsDragging) {
                    int count = this.mViewPager.getAdapter().getCount();
                    int width = this.getWidth();
                    float halfWidth = (float)width / 2.0f;
                    float sixthWidth = (float)width / 6.0f;
                    if (this.mCurrentPage > 0 && ev.getX() < halfWidth - sixthWidth) {
                        if (action != 3) {
                            this.mViewPager.setCurrentItem(this.mCurrentPage - 1);
                        }
                        return true;
                    }
                    if (this.mCurrentPage < count - 1 && ev.getX() > halfWidth + sixthWidth) {
                        if (action != 3) {
                            this.mViewPager.setCurrentItem(this.mCurrentPage + 1);
                        }
                        return true;
                    }
                }
                this.mIsDragging = false;
                this.mActivePointerId = -1;
                if (!this.mViewPager.isFakeDragging()) break;
                this.mViewPager.endFakeDrag();
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                if (pointerId == this.mActivePointerId) {
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
                }
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
            }
        }
        return true;
    }

    @Override
    public void setViewPager(ViewPager viewPager) {
        if (this.mViewPager == viewPager) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (viewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = viewPager;
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mViewPager.setCurrentItem(item);
        this.mCurrentPage = item;
        this.invalidate();
    }

    @Override
    public void notifyDataSetChanged() {
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        this.mCurrentPage = position;
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int measureSpec) {
        float result;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000 || this.mViewPager == null) {
            result = specSize;
        } else {
            int count = this.mViewPager.getAdapter().getCount();
            result = (float)(this.getPaddingLeft() + this.getPaddingRight()) + (float)count * this.mLineWidth + (float)(count - 1) * this.mGapWidth;
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, (float)specSize);
            }
        }
        return (int)FloatMath.ceil((float)result);
    }

    private int measureHeight(int measureSpec) {
        float result;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.mPaintSelected.getStrokeWidth() + (float)this.getPaddingTop() + (float)this.getPaddingBottom();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, (float)specSize);
            }
        }
        return (int)FloatMath.ceil((float)result);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mCurrentPage = savedState.currentPage;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPage = this.mCurrentPage;
        return savedState;
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPage;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPage = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPage);
        }
    }
}

