/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;

public class TypeParameter
extends ASTNode {
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(TypeParameter.class, "name", SimpleName.class, true, false);
    public static final ChildListPropertyDescriptor TYPE_BOUNDS_PROPERTY = new ChildListPropertyDescriptor(TypeParameter.class, "typeBounds", Type.class, false);
    private static final List PROPERTY_DESCRIPTORS;
    private SimpleName typeVariableName = null;
    private ASTNode.NodeList typeBounds = new ASTNode.NodeList(TYPE_BOUNDS_PROPERTY);

    static {
        ArrayList propertyList = new ArrayList(3);
        TypeParameter.createPropertyList(TypeParameter.class, propertyList);
        TypeParameter.addProperty(NAME_PROPERTY, propertyList);
        TypeParameter.addProperty(TYPE_BOUNDS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = TypeParameter.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    TypeParameter(AST ast) {
        super(ast);
        this.unsupportedIn2();
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return TypeParameter.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == TYPE_BOUNDS_PROPERTY) {
            return this.typeBounds();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 73;
    }

    @Override
    ASTNode clone0(AST target) {
        TypeParameter result = new TypeParameter(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setName((SimpleName)this.getName().clone(target));
        result.typeBounds().addAll(ASTNode.copySubtrees(target, this.typeBounds()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getName());
            this.acceptChildren(visitor, this.typeBounds);
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleName getName() {
        if (this.typeVariableName == null) {
            TypeParameter typeParameter = this;
            synchronized (typeParameter) {
                if (this.typeVariableName == null) {
                    this.preLazyInit();
                    this.typeVariableName = new SimpleName(this.ast);
                    this.postLazyInit(this.typeVariableName, NAME_PROPERTY);
                }
            }
        }
        return this.typeVariableName;
    }

    public final ITypeBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveTypeParameter(this);
    }

    public void setName(SimpleName typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this.typeVariableName;
        this.preReplaceChild(oldChild, typeName, NAME_PROPERTY);
        this.typeVariableName = typeName;
        this.postReplaceChild(oldChild, typeName, NAME_PROPERTY);
    }

    public List typeBounds() {
        return this.typeBounds;
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.typeVariableName == null ? 0 : this.getName().treeSize()) + this.typeBounds.listSize();
    }
}

