/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.classpath;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.framework.util.ArrayMap;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.FragmentClasspath;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.weaving.WeavingHookConfigurator;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.Storage;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;

public class ClasspathManager {
    private static final FragmentClasspath[] emptyFragments = new FragmentClasspath[0];
    private static final String[] DEFAULT_CLASSPATH = new String[]{"."};
    private static final Class<?>[] NULL_CLASS_RESULT = new Class[2];
    private static final Enumeration<URL> EMPTY_ENUMERATION = Collections.enumeration(Collections.EMPTY_LIST);
    private final BundleInfo.Generation generation;
    private final ModuleClassLoader classloader;
    private final HookRegistry hookRegistry;
    private final Debug debug;
    private final ClasspathEntry[] entries;
    private volatile FragmentClasspath[] fragments;
    private ArrayMap<String, String> loadedLibraries = null;
    private ThreadLocal<Collection<String>> currentlyDefining = new ThreadLocal();

    public ClasspathManager(BundleInfo.Generation generation, ModuleClassLoader classloader) {
        EquinoxConfiguration configuration = generation.getBundleInfo().getStorage().getConfiguration();
        this.debug = configuration.getDebug();
        this.hookRegistry = configuration.getHookRegistry();
        this.generation = generation;
        this.classloader = classloader;
        String[] cp = ClasspathManager.getClassPath(generation.getRevision());
        this.fragments = this.buildFragmentClasspaths(this.classloader, this);
        this.entries = this.buildClasspath(cp, this, this.generation);
    }

    private static String[] getClassPath(ModuleRevision revision) {
        List<ModuleCapability> moduleDatas = revision.getModuleCapabilities("equinox.module.data");
        List cp = moduleDatas.isEmpty() ? null : (List)moduleDatas.get(0).getAttributes().get("classpath");
        return cp == null ? DEFAULT_CLASSPATH : cp.toArray(new String[cp.size()]);
    }

    private FragmentClasspath[] buildFragmentClasspaths(ModuleClassLoader hostloader, ClasspathManager manager) {
        if (hostloader == null) {
            return emptyFragments;
        }
        List<ModuleWire> fragmentWires = hostloader.getBundleLoader().getWiring().getProvidedModuleWires("osgi.wiring.host");
        if (fragmentWires == null) {
            return emptyFragments;
        }
        ArrayList<FragmentClasspath> result = new ArrayList<FragmentClasspath>(fragmentWires.size());
        for (ModuleWire fragmentWire : fragmentWires) {
            ModuleRevision revision = fragmentWire.getRequirer();
            BundleInfo.Generation fragGeneration = (BundleInfo.Generation)revision.getRevisionInfo();
            String[] cp = ClasspathManager.getClassPath(revision);
            ClasspathEntry[] fragEntries = this.buildClasspath(cp, manager, fragGeneration);
            FragmentClasspath fragClasspath = new FragmentClasspath(fragGeneration, fragEntries);
            ClasspathManager.insertFragment(fragClasspath, result);
        }
        return result.toArray(new FragmentClasspath[result.size()]);
    }

    private static void insertFragment(FragmentClasspath fragClasspath, List<FragmentClasspath> existing) {
        long fragID = fragClasspath.getGeneration().getRevision().getRevisions().getModule().getId();
        ListIterator<FragmentClasspath> iExisting = existing.listIterator();
        while (iExisting.hasNext()) {
            long otherID = iExisting.next().getGeneration().getRevision().getRevisions().getModule().getId();
            if (fragID >= otherID) continue;
            iExisting.previous();
            iExisting.add(fragClasspath);
            return;
        }
        existing.add(fragClasspath);
    }

    public void close() {
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] != null) {
                try {
                    this.entries[i].getBundleFile().close();
                }
                catch (IOException e) {
                    this.generation.getBundleInfo().getStorage().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, this.generation.getRevision().getRevisions().getModule(), e, new FrameworkListener[0]);
                }
            }
            ++i;
        }
        FragmentClasspath[] currentFragments = this.getFragmentClasspaths();
        int i2 = 0;
        while (i2 < currentFragments.length) {
            currentFragments[i2].close();
            ++i2;
        }
    }

    private ClasspathEntry[] buildClasspath(String[] cp, ClasspathManager hostloader, BundleInfo.Generation source) {
        ArrayList<ClasspathEntry> result = new ArrayList<ClasspathEntry>(cp.length);
        int i = 0;
        while (i < cp.length) {
            this.findClassPathEntry(result, cp[i], hostloader, source);
            ++i;
        }
        return result.toArray(new ClasspathEntry[result.size()]);
    }

    private void findClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostloader, BundleInfo.Generation sourceGeneration) {
        List<ClassLoaderHook> loaderHooks = this.hookRegistry.getClassLoaderHooks();
        boolean hookAdded = false;
        for (ClassLoaderHook hook : loaderHooks) {
            hookAdded |= hook.addClassPathEntry(result, cp, hostloader, sourceGeneration);
        }
        if (!this.addClassPathEntry(result, cp, hostloader, sourceGeneration) && !hookAdded) {
            BundleException be = new BundleException(NLS.bind(Msg.BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION, cp, sourceGeneration.getRevision().toString()), 3);
            sourceGeneration.getBundleInfo().getStorage().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.INFO, sourceGeneration.getRevision().getRevisions().getModule(), be, new FrameworkListener[0]);
        }
    }

    public boolean addClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostManager, BundleInfo.Generation source) {
        return ClasspathManager.addStandardClassPathEntry(result, cp, hostManager, source) || this.addEclipseClassPathEntry(result, cp, hostManager, source);
    }

    public static boolean addStandardClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostManager, BundleInfo.Generation generation) {
        if (cp.equals(".")) {
            result.add(hostManager.createClassPathEntry(generation.getBundleFile(), generation));
            return true;
        }
        ClasspathEntry element = hostManager.getClasspath(cp, generation);
        if (element != null) {
            result.add(element);
            return true;
        }
        if (hostManager.generation == generation) {
            FragmentClasspath[] hostFrags = hostManager.getFragmentClasspaths();
            int i = 0;
            while (i < hostFrags.length) {
                FragmentClasspath fragCP = hostFrags[i];
                element = hostManager.getClasspath(cp, fragCP.getGeneration());
                if (element != null) {
                    result.add(element);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean addEclipseClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostManager, BundleInfo.Generation source) {
        String var = ClasspathManager.hasPrefix(cp);
        if (var != null) {
            return this.addInternalClassPath(var, result, cp, hostManager, source);
        }
        if (cp.startsWith("external:")) {
            cp = cp.substring("external:".length());
            ClasspathEntry cpEntry = hostManager.getExternalClassPath(source.getBundleInfo().getStorage().getConfiguration().substituteVars(cp), source);
            if (cpEntry != null) {
                result.add(cpEntry);
                return true;
            }
        }
        return false;
    }

    private boolean addInternalClassPath(String var, ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostManager, BundleInfo.Generation source) {
        EquinoxConfiguration configuration = source.getBundleInfo().getStorage().getConfiguration();
        if (var.equals("ws")) {
            return ClasspathManager.addStandardClassPathEntry(cpEntries, "ws/" + configuration.getWS() + cp.substring(4), hostManager, source);
        }
        if (var.equals("os")) {
            return ClasspathManager.addStandardClassPathEntry(cpEntries, "os/" + configuration.getOS() + cp.substring(4), hostManager, source);
        }
        if (var.equals("nl")) {
            cp = cp.substring(4);
            List<String> NL_JAR_VARIANTS = source.getBundleInfo().getStorage().getConfiguration().ECLIPSE_NL_JAR_VARIANTS;
            for (String nlVariant : NL_JAR_VARIANTS) {
                if (!ClasspathManager.addStandardClassPathEntry(cpEntries, "nl/" + nlVariant + cp, hostManager, source)) continue;
                return true;
            }
        }
        return false;
    }

    private static String hasPrefix(String libPath) {
        if (libPath.startsWith("$ws$")) {
            return "ws";
        }
        if (libPath.startsWith("$os$")) {
            return "os";
        }
        if (libPath.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    public ClasspathEntry getClasspath(String cp, BundleInfo.Generation cpGeneration) {
        BundleFile bundlefile = null;
        BundleEntry cpEntry = cpGeneration.getBundleFile().getEntry(cp);
        if (cpEntry != null && cpEntry.getName().endsWith("/")) {
            bundlefile = ClasspathManager.createBundleFile(cp, cpGeneration);
        } else {
            File file = cpGeneration.getBundleFile().getFile(cp, false);
            if (file != null) {
                bundlefile = ClasspathManager.createBundleFile(file, cpGeneration);
            }
        }
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, cpGeneration);
        }
        return null;
    }

    public ClasspathEntry getExternalClassPath(String cp, BundleInfo.Generation cpGeneration) {
        File file = new File(cp);
        if (!file.isAbsolute()) {
            return null;
        }
        BundleFile bundlefile = ClasspathManager.createBundleFile(file, cpGeneration);
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, cpGeneration);
        }
        return null;
    }

    public synchronized void loadFragments(Collection<ModuleRevision> addedFragments) {
        ArrayList<FragmentClasspath> result = new ArrayList<FragmentClasspath>(Arrays.asList(this.fragments));
        for (ModuleRevision addedFragment : addedFragments) {
            BundleInfo.Generation fragGeneration = (BundleInfo.Generation)addedFragment.getRevisionInfo();
            String[] cp = ClasspathManager.getClassPath(addedFragment);
            ClasspathEntry[] fragEntries = this.buildClasspath(cp, this, fragGeneration);
            FragmentClasspath fragClasspath = new FragmentClasspath(fragGeneration, fragEntries);
            ClasspathManager.insertFragment(fragClasspath, result);
        }
        this.fragments = result.toArray(new FragmentClasspath[result.size()]);
    }

    private static BundleFile createBundleFile(File content, BundleInfo.Generation generation) {
        if (!content.exists()) {
            return null;
        }
        return generation.getBundleInfo().getStorage().createBundleFile(content, generation, content.isDirectory(), false);
    }

    private static BundleFile createBundleFile(String nestedDir, BundleInfo.Generation generation) {
        return generation.getBundleInfo().getStorage().createNestedBundleFile(nestedDir, generation.getBundleFile(), generation);
    }

    private ClasspathEntry createClassPathEntry(BundleFile bundlefile, BundleInfo.Generation source) {
        ClasspathEntry entry = this.classloader != null ? this.classloader.createClassPathEntry(bundlefile, source) : new ClasspathEntry(bundlefile, source.getDomain(), source);
        return entry;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL findLocalResource(String resource) {
        hooks = this.hookRegistry.getClassLoaderHooks();
        for (ClassLoaderHook hook : hooks) {
            hook.preFindLocalResource(resource, this);
        }
        result = null;
        try {
            var5_6 = result = this.findLocalResourceImpl(resource, -1);
            return var5_6;
        }
        finally {
            ** for (hook : hooks)
        }
lbl-1000:
        // 1 sources

        {
            hook.postFindLocalResource(resource, result, this);
            continue;
        }
lbl13:
        // 1 sources

        return var5_6;
    }

    private URL findLocalResourceImpl(String resource, int classPathIndex) {
        URL result = null;
        int curIndex = 0;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] != null && (result = this.findResourceImpl(resource, this.entries[i].getBundleFile(), curIndex)) != null && (classPathIndex == -1 || classPathIndex == curIndex)) {
                return result;
            }
            ++curIndex;
            ++i;
        }
        FragmentClasspath[] currentFragments = this.getFragmentClasspaths();
        int i2 = 0;
        while (i2 < currentFragments.length) {
            ClasspathEntry[] fragEntries = currentFragments[i2].getEntries();
            int j = 0;
            while (j < fragEntries.length) {
                result = this.findResourceImpl(resource, fragEntries[j].getBundleFile(), curIndex);
                if (result != null && (classPathIndex == -1 || classPathIndex == curIndex)) {
                    return result;
                }
                ++curIndex;
                ++j;
            }
            ++i2;
        }
        return null;
    }

    public Enumeration<URL> findLocalResources(String resource) {
        ArrayList<URL> resources = new ArrayList<URL>(6);
        int classPathIndex = 0;
        int i = 0;
        while (i < this.entries.length) {
            URL url;
            if (this.entries[i] != null && (url = this.findResourceImpl(resource, this.entries[i].getBundleFile(), classPathIndex)) != null) {
                resources.add(url);
            }
            ++classPathIndex;
            ++i;
        }
        FragmentClasspath[] currentFragments = this.getFragmentClasspaths();
        int i2 = 0;
        while (i2 < currentFragments.length) {
            ClasspathEntry[] fragEntries = currentFragments[i2].getEntries();
            int j = 0;
            while (j < fragEntries.length) {
                URL url = this.findResourceImpl(resource, fragEntries[j].getBundleFile(), classPathIndex);
                if (url != null) {
                    resources.add(url);
                }
                ++classPathIndex;
                ++j;
            }
            ++i2;
        }
        if (resources.size() > 0) {
            return Collections.enumeration(resources);
        }
        return EMPTY_ENUMERATION;
    }

    private URL findResourceImpl(String name, BundleFile bundlefile, int index) {
        return bundlefile.getResourceURL(name, this.generation.getRevision().getRevisions().getModule(), index);
    }

    public BundleEntry findLocalEntry(String path) {
        return this.findLocalEntry(path, -1);
    }

    public BundleEntry findLocalEntry(String path, int classPathIndex) {
        BundleEntry result = null;
        int curIndex = 0;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] != null && (result = this.findEntryImpl(path, this.entries[i].getBundleFile())) != null && (classPathIndex == -1 || classPathIndex == curIndex)) {
                return result;
            }
            ++curIndex;
            ++i;
        }
        FragmentClasspath[] currentFragments = this.getFragmentClasspaths();
        int i2 = 0;
        while (i2 < currentFragments.length) {
            ClasspathEntry[] fragEntries = currentFragments[i2].getEntries();
            int j = 0;
            while (j < fragEntries.length) {
                result = this.findEntryImpl(path, fragEntries[j].getBundleFile());
                if (result != null && (classPathIndex == -1 || classPathIndex == curIndex)) {
                    return result;
                }
                ++curIndex;
                ++j;
            }
            ++i2;
        }
        return null;
    }

    public Enumeration<BundleEntry> findLocalEntries(String path) {
        ArrayList<BundleEntry> objects = new ArrayList<BundleEntry>(6);
        int i = 0;
        while (i < this.entries.length) {
            BundleEntry result;
            if (this.entries[i] != null && (result = this.findEntryImpl(path, this.entries[i].getBundleFile())) != null) {
                objects.add(result);
            }
            ++i;
        }
        FragmentClasspath[] currentFragments = this.getFragmentClasspaths();
        int i2 = 0;
        while (i2 < currentFragments.length) {
            ClasspathEntry[] fragEntries = currentFragments[i2].getEntries();
            int j = 0;
            while (j < fragEntries.length) {
                BundleEntry result = this.findEntryImpl(path, fragEntries[j].getBundleFile());
                if (result != null) {
                    objects.add(result);
                }
                ++j;
            }
            ++i2;
        }
        if (objects.size() > 0) {
            return Collections.enumeration(objects);
        }
        return null;
    }

    private BundleEntry findEntryImpl(String path, BundleFile bundleFile) {
        return bundleFile.getEntry(path);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class<?> findLocalClass(String classname) throws ClassNotFoundException {
        result = null;
        hooks = this.hookRegistry.getClassLoaderHooks();
        try {
            for (ClassLoaderHook hook : hooks) {
                hook.preFindLocalClass(classname, this);
            }
            result = this.classloader.publicFindLoaded(classname);
            if (result != null) {
                var6_6 = result;
                return var6_6;
            }
            var6_7 = result = this.findLocalClassImpl(classname, hooks);
            return var6_7;
        }
        finally {
            ** for (hook : hooks)
        }
lbl-1000:
        // 1 sources

        {
            hook.postFindLocalClass(classname, result, this);
            continue;
        }
lbl17:
        // 1 sources

        return var6_6;
    }

    private Class<?> findLocalClassImpl(String classname, List<ClassLoaderHook> hooks) throws ClassNotFoundException {
        Class<?> result = null;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] != null && (result = this.findClassImpl(classname, this.entries[i], hooks)) != null) {
                return result;
            }
            ++i;
        }
        FragmentClasspath[] currentFragments = this.getFragmentClasspaths();
        int i2 = 0;
        while (i2 < currentFragments.length) {
            ClasspathEntry[] fragEntries = currentFragments[i2].getEntries();
            int j = 0;
            while (j < fragEntries.length) {
                result = this.findClassImpl(classname, fragEntries[j], hooks);
                if (result != null) {
                    return result;
                }
                ++j;
            }
            ++i2;
        }
        throw new ClassNotFoundException(classname);
    }

    private Class<?> findClassImpl(String name, ClasspathEntry classpathEntry, List<ClassLoaderHook> hooks) {
        Collection<String> current;
        byte[] classbytes;
        if (this.debug.DEBUG_LOADER) {
            Debug.println("BundleClassLoader[" + classpathEntry.getBundleFile() + "].findClassImpl(" + name + ")");
        }
        String filename = name.replace('.', '/').concat(".class");
        BundleEntry entry = classpathEntry.getBundleFile().getEntry(filename);
        if (entry == null) {
            return null;
        }
        try {
            classbytes = entry.getBytes();
        }
        catch (IOException e) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("  IOException reading " + filename + " from " + classpathEntry.getBundleFile());
            }
            throw (LinkageError)new LinkageError("Error reading class bytes: " + name).initCause(e);
        }
        if (this.debug.DEBUG_LOADER) {
            Debug.println("  read " + classbytes.length + " bytes from " + classpathEntry.getBundleFile() + "/" + filename);
            Debug.println("  defining class " + name);
        }
        if ((current = this.currentlyDefining.get()) == null) {
            current = new ArrayList<String>(5);
            this.currentlyDefining.set(current);
        }
        if (current.contains(name)) {
            return null;
        }
        try {
            current.add(name);
            Class<?> clazz = this.defineClass(name, classbytes, classpathEntry, entry, hooks);
            return clazz;
        }
        catch (Error e) {
            if (this.debug.DEBUG_LOADER) {
                Debug.println("  error defining class " + name);
            }
            throw e;
        }
        finally {
            current.remove(name);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Class<?> defineClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, List<ClassLoaderHook> hooks) {
        block7: {
            result = null;
            try {
                this.definePackage(name, classpathEntry);
                for (ClassLoaderHook hook : hooks) {
                    modifiedBytes = hook.processClass(name, classbytes, classpathEntry, entry, this);
                    if (modifiedBytes == null) continue;
                    if (!(hook instanceof WeavingHookConfigurator)) {
                        for (ClassLoaderHook rejectHook : hooks) {
                            if (!rejectHook.rejectTransformation(name, modifiedBytes, classpathEntry, entry, this)) continue;
                            modifiedBytes = null;
                            break;
                        }
                    }
                    if (modifiedBytes == null) continue;
                    classbytes = modifiedBytes;
                }
                result = this.classloader.defineClass(name, classbytes, classpathEntry);
                break block7;
            }
            catch (Throwable var12_12) {
                defined = result != null && result.defined != false ? result.clazz : null;
                ** for (hook : hooks)
            }
lbl-1000:
            // 1 sources

            {
                hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
                continue;
            }
lbl22:
            // 1 sources

            throw var12_12;
        }
        defined = result != null && result.defined != false ? result.clazz : null;
        for (ClassLoaderHook hook : hooks) {
            hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
        }
        return result == null ? null : result.clazz;
    }

    private void definePackage(String name, ClasspathEntry classpathEntry) {
        Manifest mf;
        int lastIndex = name.lastIndexOf(46);
        if (lastIndex < 0) {
            return;
        }
        String packageName = name.substring(0, lastIndex);
        Package pkg = this.classloader.publicGetPackage(packageName);
        if (pkg != null) {
            return;
        }
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        if (this.generation.getBundleInfo().getStorage().getConfiguration().DEFINE_PACKAGE_ATTRIBUTES && (mf = classpathEntry.getManifest()) != null) {
            Attributes mainAttributes = mf.getMainAttributes();
            String dirName = String.valueOf(packageName.replace('.', '/')) + '/';
            Attributes packageAttributes = mf.getAttributes(dirName);
            boolean noEntry = false;
            if (packageAttributes == null) {
                noEntry = true;
                packageAttributes = mainAttributes;
            }
            if ((specTitle = packageAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE)) == null && !noEntry) {
                specTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if ((specVersion = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION)) == null && !noEntry) {
                specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if ((specVendor = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR)) == null && !noEntry) {
                specVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if ((implTitle = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null && !noEntry) {
                implTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if ((implVersion = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION)) == null && !noEntry) {
                implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if ((implVendor = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR)) == null && !noEntry) {
                implVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
        }
        this.classloader.publicDefinePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    public FragmentClasspath[] getFragmentClasspaths() {
        return this.fragments;
    }

    public ClasspathEntry[] getHostClasspathEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findLibrary(String libname) {
        Object object = this;
        synchronized (object) {
            if (this.loadedLibraries == null) {
                this.loadedLibraries = new ArrayMap(1);
            }
        }
        object = this.loadedLibraries;
        synchronized (object) {
            String libpath = this.loadedLibraries.get(libname);
            if (libpath != null) {
                return libpath;
            }
            libpath = this.findLibrary0(libname);
            if (libpath != null) {
                this.loadedLibraries.put(libname, libpath);
            }
            return libpath;
        }
    }

    private String findLibrary0(String libname) {
        FragmentClasspath[] currentFragments;
        List<ClassLoaderHook> hooks = this.hookRegistry.getClassLoaderHooks();
        String result = null;
        for (ClassLoaderHook hook : hooks) {
            try {
                result = hook.preFindLibrary(libname, this.classloader);
                if (result == null) continue;
                return result;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        result = this.generation.findLibrary(libname);
        if (result != null) {
            return result;
        }
        FragmentClasspath[] fragmentClasspathArray = currentFragments = this.getFragmentClasspaths();
        int n = currentFragments.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentClasspath fragment = fragmentClasspathArray[n2];
            result = fragment.getGeneration().findLibrary(libname);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        for (ClassLoaderHook hook : hooks) {
            result = hook.postFindLibrary(libname, this.classloader);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public List<URL> findEntries(String path, String filePattern, int options) {
        FragmentClasspath[] currentFragments;
        ArrayList<BundleInfo.Generation> generations = new ArrayList<BundleInfo.Generation>();
        generations.add(this.generation);
        FragmentClasspath[] fragmentClasspathArray = currentFragments = this.getFragmentClasspaths();
        int n = currentFragments.length;
        int n2 = 0;
        while (n2 < n) {
            FragmentClasspath fragmentClasspath = fragmentClasspathArray[n2];
            generations.add(fragmentClasspath.getGeneration());
            ++n2;
        }
        List<URL> result = Collections.emptyList();
        Enumeration<URL> eURLs = Storage.findEntries(generations, path, filePattern, options);
        if (eURLs == null) {
            return result;
        }
        result = new ArrayList<URL>();
        while (eURLs.hasMoreElements()) {
            result.add(eURLs.nextElement());
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<String> listLocalResources(String path, String filePattern, int options) {
        FragmentClasspath[] currentFragments;
        ClasspathEntry[] cpEntries;
        ArrayList<BundleFile> bundleFiles = new ArrayList<BundleFile>();
        ClasspathEntry[] classpathEntryArray = cpEntries = this.getHostClasspathEntries();
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathEntry cpEntry = classpathEntryArray[n2];
            bundleFiles.add(cpEntry.getBundleFile());
            ++n2;
        }
        FragmentClasspath[] fragmentClasspathArray = currentFragments = this.getFragmentClasspaths();
        int n3 = currentFragments.length;
        n = 0;
        while (n < n3) {
            ClasspathEntry[] fragEntries;
            FragmentClasspath fragmentClasspath = fragmentClasspathArray[n];
            ClasspathEntry[] classpathEntryArray2 = fragEntries = fragmentClasspath.getEntries();
            int n4 = fragEntries.length;
            int n5 = 0;
            while (n5 < n4) {
                ClasspathEntry cpEntry = classpathEntryArray2[n5];
                bundleFiles.add(cpEntry.getBundleFile());
                ++n5;
            }
            ++n;
        }
        return Storage.listEntryPaths(bundleFiles, path, filePattern, options);
    }

    public BundleInfo.Generation getGeneration() {
        return this.generation;
    }

    public ModuleClassLoader getClassLoader() {
        return this.classloader;
    }
}

