/*
 * Decompiled with CFR 0.152.
 */
package com.cucumber.listener;

import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import com.aventstack.extentreports.reporter.ExtentHtmlReporter;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtentCucumberFormatter
implements Reporter,
Formatter {
    private static ThreadLocal<ExtentReports> reportsThreadLocal = new ThreadLocal();
    private static ThreadLocal<ExtentHtmlReporter> htmlReporterThreadLocal = new ThreadLocal();
    private static ThreadLocal<ExtentTest> featureTestThreadLocal = new ThreadLocal();
    private static ThreadLocal<ExtentTest> scenarioOutlineThreadLocal = new ThreadLocal();
    static ThreadLocal<ExtentTest> scenarioThreadLocal = new ThreadLocal();
    private static ThreadLocal<LinkedList<Step>> stepListThreadLocal = new ThreadLocal();
    static ThreadLocal<ExtentTest> stepTestThreadLocal = new ThreadLocal();
    private boolean scenarioOutlineFlag;

    public ExtentCucumberFormatter(File file) {
        if (ExtentCucumberFormatter.getExtentReport() == null) {
            ExtentCucumberFormatter.setExtentHtmlReport(new ExtentHtmlReporter(file));
            ExtentReports extentReports = new ExtentReports();
            extentReports.attachReporter(new ExtentReporter[]{ExtentCucumberFormatter.getExtentHtmlReport()});
            ExtentCucumberFormatter.setExtentReport(extentReports);
        }
        stepListThreadLocal.set(new LinkedList());
        this.scenarioOutlineFlag = false;
    }

    private static void setExtentHtmlReport(ExtentHtmlReporter htmlReport) {
        htmlReporterThreadLocal.set(htmlReport);
    }

    static ExtentHtmlReporter getExtentHtmlReport() {
        return htmlReporterThreadLocal.get();
    }

    private static void setExtentReport(ExtentReports extentReports) {
        reportsThreadLocal.set(extentReports);
    }

    static ExtentReports getExtentReport() {
        return reportsThreadLocal.get();
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void uri(String uri) {
    }

    public void feature(Feature feature) {
        featureTestThreadLocal.set(ExtentCucumberFormatter.getExtentReport().createTest(feature.getName()));
        ExtentTest test = featureTestThreadLocal.get();
        for (Tag tag : feature.getTags()) {
            test.assignCategory(new String[]{tag.getName()});
        }
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.scenarioOutlineFlag = true;
        ExtentTest node = featureTestThreadLocal.get().createNode(scenarioOutline.getKeyword() + ": " + scenarioOutline.getName());
        scenarioOutlineThreadLocal.set(node);
    }

    public void examples(Examples examples) {
        ExtentTest test = scenarioOutlineThreadLocal.get();
        String[][] data = null;
        List rows = examples.getRows();
        int rowSize = rows.size();
        for (int i = 0; i < rowSize; ++i) {
            ExamplesTableRow examplesTableRow = (ExamplesTableRow)rows.get(i);
            List cells = examplesTableRow.getCells();
            int cellSize = cells.size();
            if (data == null) {
                data = new String[rowSize][cellSize];
            }
            for (int j = 0; j < cellSize; ++j) {
                data[i][j] = (String)cells.get(j);
            }
        }
        test.info(MarkupHelper.createTable((String[][])data));
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        if (this.scenarioOutlineFlag) {
            this.scenarioOutlineFlag = false;
        }
        ExtentTest scenarioNode = scenarioOutlineThreadLocal.get() != null && scenario.getKeyword().trim().equalsIgnoreCase("Scenario Outline") ? scenarioOutlineThreadLocal.get().createNode("Scenario: " + scenario.getName()) : featureTestThreadLocal.get().createNode("Scenario: " + scenario.getName());
        for (Tag tag : scenario.getTags()) {
            scenarioNode.assignCategory(new String[]{tag.getName()});
        }
        scenarioThreadLocal.set(scenarioNode);
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
    }

    public void step(Step step) {
        if (this.scenarioOutlineFlag) {
            return;
        }
        stepListThreadLocal.get().add(step);
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
    }

    public void done() {
        ExtentCucumberFormatter.getExtentReport().flush();
    }

    public void close() {
    }

    public void eof() {
    }

    public void before(Match match, Result result) {
    }

    public void result(Result result) {
        if (this.scenarioOutlineFlag) {
            return;
        }
        if ("passed".equals(result.getStatus())) {
            stepTestThreadLocal.get().pass("passed");
        } else if ("failed".equals(result.getStatus())) {
            stepTestThreadLocal.get().fail(result.getError());
        } else if (Result.SKIPPED.equals(result)) {
            stepTestThreadLocal.get().skip(Result.SKIPPED.getStatus());
        } else if (Result.UNDEFINED.equals(result)) {
            stepTestThreadLocal.get().skip(Result.UNDEFINED.getStatus());
        }
    }

    public void after(Match match, Result result) {
    }

    public void match(Match match) {
        Step step = stepListThreadLocal.get().poll();
        String[][] data = null;
        if (step.getRows() != null) {
            List rows = step.getRows();
            int rowSize = rows.size();
            for (int i = 0; i < rowSize; ++i) {
                DataTableRow dataTableRow = (DataTableRow)rows.get(i);
                List cells = dataTableRow.getCells();
                int cellSize = cells.size();
                if (data == null) {
                    data = new String[rowSize][cellSize];
                }
                for (int j = 0; j < cellSize; ++j) {
                    data[i][j] = (String)cells.get(j);
                }
            }
        }
        ExtentTest scenarioTest = scenarioThreadLocal.get();
        ExtentTest stepTest = scenarioTest.createNode(step.getKeyword() + step.getName());
        if (data != null) {
            Markup table = MarkupHelper.createTable((String[][])data);
            stepTest.info(table);
        }
        stepTestThreadLocal.set(stepTest);
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
    }
}

