/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.base;

import com.google.common.base.Throwables;
import com.vip.vjtools.vjkit.base.annotation.NotNull;
import com.vip.vjtools.vjkit.base.annotation.Nullable;
import com.vip.vjtools.vjkit.base.type.UncheckedException;
import com.vip.vjtools.vjkit.io.type.StringBuilderWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExceptionUtil {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];

    public static RuntimeException unchecked(@Nullable Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UncheckedException(t);
    }

    public static Throwable unwrap(@Nullable Throwable t) {
        if (t instanceof UncheckedException || t instanceof ExecutionException || t instanceof InvocationTargetException || t instanceof UndeclaredThrowableException) {
            return t.getCause();
        }
        return t;
    }

    public static RuntimeException unwrapAndUnchecked(@Nullable Throwable t) {
        throw ExceptionUtil.unchecked(ExceptionUtil.unwrap(t));
    }

    public static String stackTraceText(@NotNull Throwable t) {
        StringBuilderWriter stringWriter = new StringBuilderWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String toStringWithShortName(@Nullable Throwable t) {
        return ExceptionUtils.getMessage((Throwable)t);
    }

    public static String toStringWithRootCause(@Nullable Throwable t) {
        if (t == null) {
            return "";
        }
        String clsName = ClassUtils.getShortClassName((Object)t, null);
        String message = StringUtils.defaultString((String)t.getMessage());
        Throwable cause = ExceptionUtil.getRootCause(t);
        StringBuilder sb = new StringBuilder(128).append(clsName).append(": ").append(message);
        if (cause != t) {
            sb.append("; <---").append(ExceptionUtil.toStringWithShortName(cause));
        }
        return sb.toString();
    }

    public static Throwable getRootCause(@NotNull Throwable t) {
        return Throwables.getRootCause((Throwable)t);
    }

    public static <T extends Throwable> T findCause(@NotNull Throwable throwable, Class<T> cause) {
        while (throwable != null) {
            if (throwable.getClass().equals(cause)) {
                return (T)throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    public static boolean isCausedBy(@Nullable Throwable throwable, Class<? extends Exception> ... causeExceptionClasses) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            for (Class<? extends Exception> causeClass : causeExceptionClasses) {
                if (!causeClass.isInstance(cause)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends Throwable> T setStackTrace(@NotNull T throwable, Class<?> throwClass, String throwClazz) {
        throwable.setStackTrace(new StackTraceElement[]{new StackTraceElement(throwClass.getName(), throwClazz, null, -1)});
        return throwable;
    }

    public static <T extends Throwable> T clearStackTrace(@NotNull T throwable) {
        for (Object cause = throwable; cause != null; cause = cause.getCause()) {
            cause.setStackTrace(EMPTY_STACK_TRACE);
        }
        return throwable;
    }
}

