/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.collection;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.vip.vjtools.vjkit.base.type.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CollectionUtil {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        if (collection instanceof List) {
            return (T)((List)collection).get(0);
        }
        return collection.iterator().next();
    }

    public static <T> T getLast(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(list.size() - 1);
        }
        return (T)Iterators.getLast(collection.iterator());
    }

    public static boolean elementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        return Iterables.elementsEqual(iterable1, iterable2);
    }

    public static <T> T min(Collection<? extends T> coll) {
        return Collections.min(coll);
    }

    public static <T> T min(Collection<? extends T> coll, Comparator<? super T> comp) {
        return Collections.min(coll, comp);
    }

    public static <T> T max(Collection<? extends T> coll) {
        return Collections.max(coll);
    }

    public static <T> T max(Collection<? extends T> coll, Comparator<? super T> comp) {
        return Collections.max(coll, comp);
    }

    public static <T> Pair<T, T> minAndMax(Collection<? extends T> coll) {
        T minCandidate;
        Iterator<T> i = coll.iterator();
        T maxCandidate = minCandidate = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (((Comparable)next).compareTo(minCandidate) < 0) {
                minCandidate = next;
                continue;
            }
            if (((Comparable)next).compareTo(maxCandidate) <= 0) continue;
            maxCandidate = next;
        }
        return Pair.of(minCandidate, maxCandidate);
    }

    public static <T> Pair<T, T> minAndMax(Collection<? extends T> coll, Comparator<? super T> comp) {
        T minCandidate;
        Iterator<T> i = coll.iterator();
        T maxCandidate = minCandidate = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (comp.compare(next, minCandidate) < 0) {
                minCandidate = next;
                continue;
            }
            if (comp.compare(next, maxCandidate) <= 0) continue;
            maxCandidate = next;
        }
        return Pair.of(minCandidate, maxCandidate);
    }

    public static <T extends Comparable<?>> List<T> topN(Iterable<T> coll, int n) {
        return Ordering.natural().greatestOf(coll, n);
    }

    public static <T> List<T> topN(Iterable<T> coll, int n, Comparator<? super T> comp) {
        return Ordering.from(comp).greatestOf(coll, n);
    }

    public static <T extends Comparable<?>> List<T> bottomN(Iterable<T> coll, int n) {
        return Ordering.natural().leastOf(coll, n);
    }

    public static <T> List<T> bottomN(Iterable<T> coll, int n, Comparator<? super T> comp) {
        return Ordering.from(comp).leastOf(coll, n);
    }
}

