/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.concurrent;

import com.vip.vjtools.vjkit.concurrent.limiter.TimeIntervalLimiter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpper {
    private static final int DEFAULT_MAX_STACK_LEVEL = 8;
    private static final int DEFAULT_MIN_INTERVAL = 600000;
    private static Logger logger = LoggerFactory.getLogger(ThreadDumpper.class);
    private int maxStackLevel;
    private TimeIntervalLimiter timeIntervalLimiter;

    public ThreadDumpper() {
        this(600000L, 8);
    }

    public ThreadDumpper(long leastIntervalMills, int maxStackLevel) {
        this.maxStackLevel = maxStackLevel;
        this.timeIntervalLimiter = new TimeIntervalLimiter(leastIntervalMills, TimeUnit.MILLISECONDS);
    }

    public void tryThreadDump() {
        this.tryThreadDump(null);
    }

    public void tryThreadDump(String reasonMsg) {
        if (this.timeIntervalLimiter.tryAcquire()) {
            this.threadDump(reasonMsg);
        }
    }

    public void threadDump(String reasonMsg) {
        logger.info("Thread dump by ThreadDumpper" + (reasonMsg != null ? " for " + reasonMsg : ""));
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        logger.info("Finish the threads snapshot");
        StringBuilder sb = new StringBuilder(163840).append('\n');
        for (Map.Entry<Thread, StackTraceElement[]> entry : threads.entrySet()) {
            this.dumpThreadInfo(entry.getKey(), entry.getValue(), sb);
        }
        logger.info(sb.toString());
    }

    private String dumpThreadInfo(Thread thread, StackTraceElement[] stackTrace, StringBuilder sb) {
        int i;
        sb.append('\"').append(thread.getName()).append("\" Id=").append(thread.getId()).append(' ').append((Object)thread.getState());
        sb.append('\n');
        for (i = 0; i < Math.min(this.maxStackLevel, stackTrace.length); ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste).append('\n');
        }
        if (i < stackTrace.length) {
            sb.append("\t...").append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public void setLeastInterval(int leastIntervalSeconds) {
        this.timeIntervalLimiter = new TimeIntervalLimiter(leastIntervalSeconds, TimeUnit.MILLISECONDS);
    }

    public void setMaxStackLevel(int maxStackLevel) {
        this.maxStackLevel = maxStackLevel;
    }
}

