/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.apache.commons.lang3.StringUtils;

public class MoneyUtil {
    private static final ThreadLocal<DecimalFormat> DEFAULT_FORMAT = MoneyUtil.createThreadLocalNumberformat("0.00");
    private static final ThreadLocal<DecimalFormat> PRETTY_FORMAT = MoneyUtil.createThreadLocalNumberformat("#,##0.00");

    private static ThreadLocal<DecimalFormat> createThreadLocalNumberformat(final String pattern) {
        return new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
                df.applyPattern(pattern);
                return df;
            }
        };
    }

    public static BigDecimal fen2yuan(BigDecimal num) {
        return num.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
    }

    public static BigDecimal fen2yuan(long num) {
        return MoneyUtil.fen2yuan(new BigDecimal(num));
    }

    public static BigDecimal fen2yuan(String num) {
        if (StringUtils.isEmpty((CharSequence)num)) {
            return new BigDecimal(0);
        }
        return MoneyUtil.fen2yuan(new BigDecimal(num));
    }

    public static BigDecimal yuan2fen(String y) {
        return new BigDecimal(Math.round(new BigDecimal(y).multiply(new BigDecimal(100)).doubleValue()));
    }

    public static BigDecimal yuan2fen(double y) {
        return MoneyUtil.yuan2fen(String.valueOf(y));
    }

    public static BigDecimal yuan2fen(BigDecimal y) {
        if (y != null) {
            return MoneyUtil.yuan2fen(y.toString());
        }
        return new BigDecimal(0);
    }

    public static String format(BigDecimal number) {
        return MoneyUtil.format(number.doubleValue());
    }

    public static String format(double number) {
        return DEFAULT_FORMAT.get().format(number);
    }

    public static String prettyFormat(BigDecimal number) {
        return MoneyUtil.prettyFormat(number.doubleValue());
    }

    public static String prettyFormat(double number) {
        return PRETTY_FORMAT.get().format(number);
    }

    public static String format(BigDecimal number, String pattern) {
        return MoneyUtil.format(number.doubleValue(), pattern);
    }

    public static String format(double number, String pattern) {
        DecimalFormat df = null;
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            df = PRETTY_FORMAT.get();
        } else {
            df = (DecimalFormat)DecimalFormat.getInstance();
            df.applyPattern(pattern);
        }
        return df.format(number);
    }

    public static BigDecimal parseString(String numberStr) throws ParseException {
        return new BigDecimal(DEFAULT_FORMAT.get().parse(numberStr).doubleValue());
    }

    public static BigDecimal parsePrettyString(String numberStr) throws ParseException {
        return new BigDecimal(PRETTY_FORMAT.get().parse(numberStr).doubleValue());
    }

    public static BigDecimal parseString(String numberStr, String pattern) throws ParseException {
        DecimalFormat df = null;
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            df = PRETTY_FORMAT.get();
        } else {
            df = (DecimalFormat)DecimalFormat.getInstance();
            df.applyPattern(pattern);
        }
        return new BigDecimal(df.parse(numberStr).doubleValue());
    }
}

