/*
 * Decompiled with CFR 0.152.
 */
package com.vip.vjtools.vjkit.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static Logger logger = LoggerFactory.getLogger(ClassUtil.class);

    public static String getShortClassName(Class<?> cls) {
        return ClassUtils.getShortClassName(cls);
    }

    public static String getShortClassName(String className) {
        return ClassUtils.getShortClassName((String)className);
    }

    public static String getPackageName(Class<?> cls) {
        return ClassUtils.getPackageName(cls);
    }

    public static String getPackageName(String className) {
        return ClassUtils.getPackageName((String)className);
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        return ClassUtils.getAllSuperclasses(cls);
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        return ClassUtils.getAllInterfaces(cls);
    }

    public static boolean isSubClassOrInterfaceOf(Class subclass, Class superclass) {
        return superclass.isAssignableFrom(subclass);
    }

    public static Class<?> unwrapCglib(Object instance) {
        Class<?> superClass;
        Validate.notNull((Object)instance, (String)"Instance must not be null", (Object[])new Object[0]);
        Class<?> clazz = instance.getClass();
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public static <T> Class<T> getClassGenericType(Class clazz) {
        return ClassUtil.getClassGenericType(clazz, 0);
    }

    public static Class getClassGenericType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }
}

