/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@SystemApi
public final class NetworkStats
implements Parcelable,
Iterable<Entry> {
    private static final String TAG = "NetworkStats";
    public static final String IFACE_ALL = null;
    public static final String IFACE_VT = "vt_data0";
    public static final int UID_ALL = -1;
    public static final int UID_TETHERING = -5;
    public static final int TAG_ALL = -1;
    public static final int SET_ALL = -1;
    public static final int SET_DEFAULT = 0;
    public static final int SET_FOREGROUND = 1;
    public static final int SET_DEBUG_START = 1000;
    public static final int SET_DBG_VPN_IN = 1001;
    public static final int SET_DBG_VPN_OUT = 1002;
    public static final String[] INTERFACES_ALL = null;
    public static final int TAG_NONE = 0;
    public static final int METERED_ALL = -1;
    public static final int METERED_NO = 0;
    public static final int METERED_YES = 1;
    public static final int ROAMING_ALL = -1;
    public static final int ROAMING_NO = 0;
    public static final int ROAMING_YES = 1;
    public static final int DEFAULT_NETWORK_ALL = -1;
    public static final int DEFAULT_NETWORK_NO = 0;
    public static final int DEFAULT_NETWORK_YES = 1;
    public static final int STATS_PER_IFACE = 0;
    public static final int STATS_PER_UID = 1;
    private static final String CLATD_INTERFACE_PREFIX = "v4-";
    private static final int IPV4V6_HEADER_DELTA = 20;
    private long elapsedRealtime;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int size;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int capacity;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private String[] iface;
    @UnsupportedAppUsage
    private int[] uid;
    @UnsupportedAppUsage
    private int[] set;
    @UnsupportedAppUsage
    private int[] tag;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int[] metered;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int[] roaming;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int[] defaultNetwork;
    @UnsupportedAppUsage
    private long[] rxBytes;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long[] rxPackets;
    @UnsupportedAppUsage
    private long[] txBytes;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long[] txPackets;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long[] operations;
    public static final Parcelable.Creator<NetworkStats> CREATOR = new Parcelable.Creator<NetworkStats>(){

        @Override
        public NetworkStats createFromParcel(Parcel in) {
            return new NetworkStats(in);
        }

        public NetworkStats[] newArray(int size) {
            return new NetworkStats[size];
        }
    };

    public NetworkStats(long elapsedRealtime, int initialSize) {
        throw new IllegalStateException("STUB");
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public NetworkStats(Parcel parcel) {
        throw new IllegalStateException("STUB");
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        throw new IllegalStateException("STUB");
    }

    public NetworkStats clone() {
        throw new IllegalStateException("STUB");
    }

    public void clear() {
        throw new IllegalStateException("STUB");
    }

    @VisibleForTesting
    public NetworkStats insertEntry(String iface, long rxBytes, long rxPackets, long txBytes, long txPackets) {
        throw new IllegalStateException("STUB");
    }

    @VisibleForTesting
    public NetworkStats insertEntry(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        throw new IllegalStateException("STUB");
    }

    @VisibleForTesting
    public NetworkStats insertEntry(String iface, int uid, int set, int tag, int metered, int roaming, int defaultNetwork, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        throw new IllegalStateException("STUB");
    }

    public NetworkStats insertEntry(Entry entry) {
        throw new IllegalStateException("STUB");
    }

    private void setValues(int i, Entry entry) {
        throw new IllegalStateException("STUB");
    }

    @Override
    @SystemApi
    public Iterator<Entry> iterator() {
        throw new IllegalStateException("STUB");
    }

    @UnsupportedAppUsage
    public Entry getValues(int i, Entry recycle) {
        throw new IllegalStateException("STUB");
    }

    private void maybeCopyEntry(int dest, int src) {
        if (dest == src) {
            return;
        }
        this.iface[dest] = this.iface[src];
        this.uid[dest] = this.uid[src];
        this.set[dest] = this.set[src];
        this.tag[dest] = this.tag[src];
        this.metered[dest] = this.metered[src];
        this.roaming[dest] = this.roaming[src];
        this.defaultNetwork[dest] = this.defaultNetwork[src];
        this.rxBytes[dest] = this.rxBytes[src];
        this.rxPackets[dest] = this.rxPackets[src];
        this.txBytes[dest] = this.txBytes[src];
        this.txPackets[dest] = this.txPackets[src];
        this.operations[dest] = this.operations[src];
    }

    public long getElapsedRealtime() {
        return this.elapsedRealtime;
    }

    public void setElapsedRealtime(long time) {
        this.elapsedRealtime = time;
    }

    public long getElapsedRealtimeAge() {
        return SystemClock.elapsedRealtime() - this.elapsedRealtime;
    }

    @UnsupportedAppUsage
    public int size() {
        return this.size;
    }

    @VisibleForTesting
    public int internalSize() {
        return this.capacity;
    }

    @Deprecated
    public NetworkStats combineValues(String iface, int uid, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        throw new IllegalStateException("STUB");
    }

    public NetworkStats combineValues(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
        throw new IllegalStateException("STUB");
    }

    public NetworkStats combineValues(Entry entry) {
        throw new IllegalStateException("STUB");
    }

    public NetworkStats addEntry(Entry entry) {
        throw new IllegalStateException("STUB");
    }

    public NetworkStats add(NetworkStats another) {
        throw new IllegalStateException("STUB");
    }

    public void combineAllValues(NetworkStats another) {
        throw new IllegalStateException("STUB");
    }

    public int findIndex(String iface, int uid, int set, int tag, int metered, int roaming, int defaultNetwork) {
        throw new IllegalStateException("STUB");
    }

    @VisibleForTesting
    public int findIndexHinted(String iface, int uid, int set, int tag, int metered, int roaming, int defaultNetwork, int hintIndex) {
        throw new IllegalStateException("STUB");
    }

    public void spliceOperationsFrom(NetworkStats stats) {
        throw new IllegalStateException("STUB");
    }

    public String[] getUniqueIfaces() {
        throw new IllegalStateException("STUB");
    }

    @UnsupportedAppUsage
    public int[] getUniqueUids() {
        throw new IllegalStateException("STUB");
    }

    @UnsupportedAppUsage
    public long getTotalBytes() {
        Entry entry = this.getTotal(null);
        return entry.rxBytes + entry.txBytes;
    }

    @UnsupportedAppUsage
    public Entry getTotal(Entry recycle) {
        return this.getTotal(recycle, null, -1, false);
    }

    @UnsupportedAppUsage
    public Entry getTotal(Entry recycle, int limitUid) {
        return this.getTotal(recycle, null, limitUid, false);
    }

    public Entry getTotal(Entry recycle, HashSet<String> limitIface) {
        return this.getTotal(recycle, limitIface, -1, false);
    }

    @UnsupportedAppUsage
    public Entry getTotalIncludingTags(Entry recycle) {
        return this.getTotal(recycle, null, -1, true);
    }

    private Entry getTotal(Entry recycle, HashSet<String> limitIface, int limitUid, boolean includeTags) {
        throw new IllegalStateException("STUB");
    }

    public long getTotalPackets() {
        throw new IllegalStateException("STUB");
    }

    public NetworkStats subtract(NetworkStats right) {
        throw new IllegalStateException("STUB");
    }

    public static <C> NetworkStats subtract(NetworkStats left, NetworkStats right, NonMonotonicObserver<C> observer, C cookie) {
        throw new IllegalStateException("STUB");
    }

    public static <C> NetworkStats subtract(NetworkStats left, NetworkStats right, NonMonotonicObserver<C> observer, C cookie, NetworkStats recycle) {
        throw new IllegalStateException("STUB");
    }

    public static void apply464xlatAdjustments(NetworkStats baseTraffic, NetworkStats stackedTraffic, Map<String, String> stackedIfaces) {
        throw new IllegalStateException("STUB");
    }

    public void apply464xlatAdjustments(Map<String, String> stackedIfaces) {
        NetworkStats.apply464xlatAdjustments(this, this, stackedIfaces);
    }

    public NetworkStats groupedByIface() {
        throw new IllegalStateException("STUB");
    }

    public NetworkStats groupedByUid() {
        throw new IllegalStateException("STUB");
    }

    public void removeUids(int[] uids) {
        throw new IllegalStateException("STUB");
    }

    public NetworkStats removeEmptyEntries() {
        throw new IllegalStateException("STUB");
    }

    public void filter(int limitUid, String[] limitIfaces, int limitTag) {
        throw new IllegalStateException("STUB");
    }

    public void filterDebugEntries() {
        throw new IllegalStateException("STUB");
    }

    private void filter(Predicate<Entry> predicate) {
        throw new IllegalStateException("STUB");
    }

    public void dump(String prefix, PrintWriter pw) {
        throw new IllegalStateException("STUB");
    }

    public static String setToString(int set) {
        throw new IllegalStateException("STUB");
    }

    public static String setToCheckinString(int set) {
        throw new IllegalStateException("STUB");
    }

    public static boolean setMatches(int querySet, int dataSet) {
        throw new IllegalStateException("STUB");
    }

    public static String tagToString(int tag) {
        throw new IllegalStateException("STUB");
    }

    public static String meteredToString(int metered) {
        throw new IllegalStateException("STUB");
    }

    public static String roamingToString(int roaming) {
        throw new IllegalStateException("STUB");
    }

    public static String defaultNetworkToString(int defaultNetwork) {
        throw new IllegalStateException("STUB");
    }

    public String toString() {
        throw new IllegalStateException("STUB");
    }

    @Override
    public int describeContents() {
        throw new IllegalStateException("STUB");
    }

    public void migrateTun(int tunUid, String tunIface, List<String> underlyingIfaces) {
        throw new IllegalStateException("STUB");
    }

    private void tunAdjustmentInit(int tunUid, String tunIface, List<String> underlyingIfaces, Entry tunIfaceTotal, Entry[] perInterfaceTotal, Entry underlyingIfacesTotal) {
        throw new IllegalStateException("STUB");
    }

    private Entry[] addTrafficToApplications(int tunUid, String tunIface, List<String> underlyingIfaces, Entry tunIfaceTotal, Entry[] perInterfaceTotal, Entry underlyingIfacesTotal) {
        throw new IllegalStateException("STUB");
    }

    private void deductTrafficFromVpnApp(int tunUid, List<String> underlyingIfaces, Entry[] moved) {
        throw new IllegalStateException("STUB");
    }

    private static void tunSubtract(int i, NetworkStats left, Entry right) {
        throw new IllegalStateException("STUB");
    }

    public static interface NonMonotonicObserver<C> {
        public void foundNonMonotonic(NetworkStats var1, int var2, NetworkStats var3, int var4, C var5);

        public void foundNonMonotonic(NetworkStats var1, int var2, C var3);
    }

    @SystemApi
    public static class Entry {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public String iface;
        @UnsupportedAppUsage
        public int uid;
        @UnsupportedAppUsage
        public int set;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int tag;
        public int metered;
        public int roaming;
        public int defaultNetwork;
        @UnsupportedAppUsage
        public long rxBytes;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long rxPackets;
        @UnsupportedAppUsage
        public long txBytes;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long txPackets;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long operations;

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Entry() {
            throw new IllegalStateException("STUB");
        }

        public Entry(long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            throw new IllegalStateException("STUB");
        }

        public Entry(String iface, int uid, int set, int tag, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            throw new IllegalStateException("STUB");
        }

        public Entry(String iface, int uid, int set, int tag, int metered, int roaming, int defaultNetwork, long rxBytes, long rxPackets, long txBytes, long txPackets, long operations) {
            throw new IllegalStateException("STUB");
        }

        public boolean isNegative() {
            return this.rxBytes < 0L || this.rxPackets < 0L || this.txBytes < 0L || this.txPackets < 0L || this.operations < 0L;
        }

        public boolean isEmpty() {
            return this.rxBytes == 0L && this.rxPackets == 0L && this.txBytes == 0L && this.txPackets == 0L && this.operations == 0L;
        }

        public void add(Entry another) {
            this.rxBytes += another.rxBytes;
            this.rxPackets += another.rxPackets;
            this.txBytes += another.txBytes;
            this.txPackets += another.txPackets;
            this.operations += another.operations;
        }

        public String getIface() {
            return this.iface;
        }

        public int getUid() {
            return this.uid;
        }

        public int getSet() {
            return this.set;
        }

        public int getTag() {
            return this.tag;
        }

        public int getMetered() {
            return this.metered;
        }

        public int getRoaming() {
            return this.roaming;
        }

        public int getDefaultNetwork() {
            throw new IllegalStateException("STUB");
        }

        public long getRxBytes() {
            throw new IllegalStateException("STUB");
        }

        public long getRxPackets() {
            throw new IllegalStateException("STUB");
        }

        public long getTxBytes() {
            throw new IllegalStateException("STUB");
        }

        public long getTxPackets() {
            throw new IllegalStateException("STUB");
        }

        public long getOperations() {
            throw new IllegalStateException("STUB");
        }

        public String toString() {
            throw new IllegalStateException("STUB");
        }

        public boolean equals(Object o) {
            throw new IllegalStateException("STUB");
        }

        public int hashCode() {
            throw new IllegalStateException("STUB");
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatsType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DefaultNetwork {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Roaming {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Meteredness {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

