/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISystemUpdateManager
extends IInterface {
    public Bundle retrieveSystemUpdateInfo() throws RemoteException;

    public void updateSystemUpdateInfo(Object var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISystemUpdateManager {
        private static final String DESCRIPTOR = "android.os.ISystemUpdateManager";
        static final int TRANSACTION_retrieveSystemUpdateInfo = 1;
        static final int TRANSACTION_updateSystemUpdateInfo = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISystemUpdateManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISystemUpdateManager) {
                return (ISystemUpdateManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "retrieveSystemUpdateInfo";
                }
                case 2: {
                    return "updateSystemUpdateInfo";
                }
            }
            return null;
        }

        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            throw new UnsupportedOperationException("STUB");
        }

        public static boolean setDefaultImpl(ISystemUpdateManager impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISystemUpdateManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISystemUpdateManager {
            private IBinder mRemote;
            public static ISystemUpdateManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle retrieveSystemUpdateInfo() throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bundle bundle = Stub.getDefaultImpl().retrieveSystemUpdateInfo();
                        return bundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Bundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public void updateSystemUpdateInfo(Object data) throws RemoteException {
                throw new UnsupportedOperationException("STUB");
            }
        }
    }

    public static class Default
    implements ISystemUpdateManager {
        @Override
        public Bundle retrieveSystemUpdateInfo() throws RemoteException {
            return null;
        }

        @Override
        public void updateSystemUpdateInfo(Object data) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

