/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.security.keystore.recovery.KeyDerivationParams;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

@SystemApi
public final class KeyChainProtectionParams
implements Parcelable {
    public static final int TYPE_LOCKSCREEN = 100;
    public static final int UI_FORMAT_PIN = 1;
    public static final int UI_FORMAT_PASSWORD = 2;
    public static final int UI_FORMAT_PATTERN = 3;
    private Integer mUserSecretType;
    private Integer mLockScreenUiFormat;
    private KeyDerivationParams mKeyDerivationParams;
    private byte[] mSecret;
    public static final Parcelable.Creator<KeyChainProtectionParams> CREATOR = new Parcelable.Creator<KeyChainProtectionParams>(){

        @Override
        public KeyChainProtectionParams createFromParcel(Parcel in) {
            return new KeyChainProtectionParams(in);
        }

        public KeyChainProtectionParams[] newArray(int length) {
            return new KeyChainProtectionParams[length];
        }
    };

    private KeyChainProtectionParams() {
    }

    public int getUserSecretType() {
        return this.mUserSecretType;
    }

    public int getLockScreenUiFormat() {
        return this.mLockScreenUiFormat;
    }

    public KeyDerivationParams getKeyDerivationParams() {
        return this.mKeyDerivationParams;
    }

    public byte[] getSecret() {
        return this.mSecret;
    }

    public void clearSecret() {
        Arrays.fill(this.mSecret, (byte)0);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        throw new UnsupportedOperationException("STUB");
    }

    protected KeyChainProtectionParams(Parcel in) {
        throw new UnsupportedOperationException("STUB");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static /* synthetic */ byte[] access$402(KeyChainProtectionParams x0, byte[] x1) {
        x0.mSecret = x1;
        return x1;
    }

    public static class Builder {
        private KeyChainProtectionParams mInstance = new KeyChainProtectionParams();

        public Builder setUserSecretType(int userSecretType) {
            this.mInstance.mUserSecretType = userSecretType;
            return this;
        }

        public Builder setLockScreenUiFormat(int lockScreenUiFormat) {
            this.mInstance.mLockScreenUiFormat = lockScreenUiFormat;
            return this;
        }

        public Builder setKeyDerivationParams(KeyDerivationParams keyDerivationParams) {
            this.mInstance.mKeyDerivationParams = keyDerivationParams;
            return this;
        }

        public Builder setSecret(byte[] secret) {
            KeyChainProtectionParams.access$402(this.mInstance, secret);
            return this;
        }

        public KeyChainProtectionParams build() {
            throw new UnsupportedOperationException("STUB");
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LockScreenUiFormat {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserSecretType {
    }
}

