/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public final class RecoveryCertPath
implements Parcelable {
    private static final String CERT_PATH_ENCODING = "PkiPath";
    private final byte[] mEncodedCertPath;
    public static final Parcelable.Creator<RecoveryCertPath> CREATOR = new Parcelable.Creator<RecoveryCertPath>(){

        @Override
        public RecoveryCertPath createFromParcel(Parcel in) {
            return new RecoveryCertPath(in);
        }

        public RecoveryCertPath[] newArray(int length) {
            return new RecoveryCertPath[length];
        }
    };

    public static RecoveryCertPath createRecoveryCertPath(CertPath certPath) throws CertificateException {
        try {
            return new RecoveryCertPath(RecoveryCertPath.encodeCertPath(certPath));
        }
        catch (CertificateEncodingException e) {
            throw new CertificateException("Failed to encode the given CertPath", e);
        }
    }

    public CertPath getCertPath() throws CertificateException {
        return RecoveryCertPath.decodeCertPath(this.mEncodedCertPath);
    }

    private RecoveryCertPath(byte[] encodedCertPath) {
        this.mEncodedCertPath = Preconditions.checkNotNull(encodedCertPath);
    }

    private RecoveryCertPath(Parcel in) {
        this.mEncodedCertPath = in.createByteArray();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeByteArray(this.mEncodedCertPath);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static byte[] encodeCertPath(CertPath certPath) throws CertificateEncodingException {
        Preconditions.checkNotNull(certPath);
        return certPath.getEncoded(CERT_PATH_ENCODING);
    }

    private static CertPath decodeCertPath(byte[] bytes) throws CertificateException {
        CertificateFactory certFactory;
        Preconditions.checkNotNull(bytes);
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        return certFactory.generateCertPath(new ByteArrayInputStream(bytes), CERT_PATH_ENCODING);
    }
}

