/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

@SystemApi
public final class WrappedApplicationKey
implements Parcelable {
    private String mAlias;
    private byte[] mEncryptedKeyMaterial;
    public static final Parcelable.Creator<WrappedApplicationKey> CREATOR = new Parcelable.Creator<WrappedApplicationKey>(){

        @Override
        public WrappedApplicationKey createFromParcel(Parcel in) {
            return new WrappedApplicationKey(in);
        }

        public WrappedApplicationKey[] newArray(int length) {
            return new WrappedApplicationKey[length];
        }
    };

    private WrappedApplicationKey() {
    }

    public WrappedApplicationKey(String alias, byte[] encryptedKeyMaterial) {
        this.mAlias = Preconditions.checkNotNull(alias);
        this.mEncryptedKeyMaterial = Preconditions.checkNotNull(encryptedKeyMaterial);
    }

    public String getAlias() {
        return this.mAlias;
    }

    public byte[] getEncryptedKeyMaterial() {
        return this.mEncryptedKeyMaterial;
    }

    @Deprecated
    public byte[] getAccount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mAlias);
        out.writeByteArray(this.mEncryptedKeyMaterial);
    }

    protected WrappedApplicationKey(Parcel in) {
        this.mAlias = in.readString();
        this.mEncryptedKeyMaterial = in.createByteArray();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static /* synthetic */ byte[] access$202(WrappedApplicationKey x0, byte[] x1) {
        x0.mEncryptedKeyMaterial = x1;
        return x1;
    }

    public static class Builder {
        private WrappedApplicationKey mInstance = new WrappedApplicationKey();

        public Builder setAlias(String alias) {
            this.mInstance.mAlias = alias;
            return this;
        }

        @Deprecated
        public Builder setAccount(byte[] account) {
            throw new UnsupportedOperationException();
        }

        public Builder setEncryptedKeyMaterial(byte[] encryptedKeyMaterial) {
            WrappedApplicationKey.access$202(this.mInstance, encryptedKeyMaterial);
            return this;
        }

        public WrappedApplicationKey build() {
            Preconditions.checkNotNull(this.mInstance.mAlias);
            Preconditions.checkNotNull(this.mInstance.mEncryptedKeyMaterial);
            return this.mInstance;
        }
    }
}

