/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellLocation;
import android.text.TextUtils;
import java.util.Objects;

public abstract class CellIdentity
implements Parcelable {
    public static final int INVALID_CHANNEL_NUMBER = Integer.MAX_VALUE;
    public static final int MCC_LENGTH = 3;
    public static final int MNC_MIN_LENGTH = 2;
    public static final int MNC_MAX_LENGTH = 3;
    protected final String mTag;
    protected final int mType;
    protected final String mMccStr;
    protected final String mMncStr;
    protected String mAlphaLong;
    protected String mAlphaShort;
    protected String mGlobalCellId;
    public static final Parcelable.Creator<CellIdentity> CREATOR = new Parcelable.Creator<CellIdentity>(){

        @Override
        public CellIdentity createFromParcel(Parcel in) {
            throw new IllegalStateException("STUB");
        }

        public CellIdentity[] newArray(int size) {
            return new CellIdentity[size];
        }
    };

    protected CellIdentity(String tag, int type, String mcc, String mnc, String alphal, String alphas) {
        throw new IllegalStateException("STUB");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getType() {
        return this.mType;
    }

    public String getMccString() {
        return this.mMccStr;
    }

    public String getMncString() {
        return this.mMncStr;
    }

    public int getChannelNumber() {
        return Integer.MAX_VALUE;
    }

    public CharSequence getOperatorAlphaLong() {
        return this.mAlphaLong;
    }

    public void setOperatorAlphaLong(String alphaLong) {
        this.mAlphaLong = alphaLong;
    }

    public CharSequence getOperatorAlphaShort() {
        return this.mAlphaShort;
    }

    public void setOperatorAlphaShort(String alphaShort) {
        this.mAlphaShort = alphaShort;
    }

    public String getGlobalCellId() {
        return this.mGlobalCellId;
    }

    public boolean isSameCell(CellIdentity ci) {
        if (ci == null) {
            return false;
        }
        if (this.getClass() != ci.getClass()) {
            return false;
        }
        return TextUtils.equals(this.getGlobalCellId(), ci.getGlobalCellId());
    }

    public String getPlmn() {
        if (this.mMccStr == null || this.mMncStr == null) {
            return null;
        }
        return this.mMccStr + this.mMncStr;
    }

    protected abstract void updateGlobalCellId();

    @SystemApi
    public abstract CellLocation asCellLocation();

    @SystemApi
    public abstract CellIdentity sanitizeLocationInfo();

    public boolean equals(Object other) {
        throw new IllegalStateException("STUB");
    }

    public int hashCode() {
        return Objects.hash(this.mAlphaLong, this.mAlphaShort, this.mMccStr, this.mMncStr, this.mType);
    }

    @Override
    public void writeToParcel(Parcel dest, int type) {
        dest.writeInt(type);
        dest.writeString(this.mMccStr);
        dest.writeString(this.mMncStr);
        dest.writeString(this.mAlphaLong);
        dest.writeString(this.mAlphaShort);
    }

    public static boolean isValidPlmn(String plmn) {
        if (plmn.length() < 5 || plmn.length() > 6) {
            return false;
        }
        return CellIdentity.isMcc(plmn.substring(0, 3)) && CellIdentity.isMnc(plmn.substring(3));
    }

    protected CellIdentity(String tag, int type, Parcel source) {
        this(tag, type, source.readString(), source.readString(), source.readString(), source.readString());
    }

    protected void log(String s) {
        throw new IllegalStateException("STUB");
    }

    protected static final int inRangeOrUnavailable(int value, int rangeMin, int rangeMax) {
        if (value < rangeMin || value > rangeMax) {
            return Integer.MAX_VALUE;
        }
        return value;
    }

    protected static final long inRangeOrUnavailable(long value, long rangeMin, long rangeMax) {
        if (value < rangeMin || value > rangeMax) {
            return Long.MAX_VALUE;
        }
        return value;
    }

    protected static final int inRangeOrUnavailable(int value, int rangeMin, int rangeMax, int special) {
        if ((value < rangeMin || value > rangeMax) && value != special) {
            return Integer.MAX_VALUE;
        }
        return value;
    }

    private static boolean isMcc(String mcc) {
        if (mcc.length() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (mcc.charAt(i) >= '0' && mcc.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isMnc(String mnc) {
        if (mnc.length() < 2 || mnc.length() > 3) {
            return false;
        }
        for (int i = 0; i < mnc.length(); ++i) {
            if (mnc.charAt(i) >= '0' && mnc.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }
}

