/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public class Display {
    public static final int REMOVE_MODE_MOVE_CONTENT_TO_PRIMARY = 0;
    public static final int COLOR_MODE_DEFAULT = 0;
    public static final int DEFAULT_DISPLAY = 0;

    Display() {
        throw new RuntimeException("Stub!");
    }

    public int getDisplayId() {
        throw new RuntimeException("Stub!");
    }

    public void getSize(Point outSize) {
        throw new RuntimeException("Stub!");
    }

    public void getRectSize(Rect outSize) {
        throw new RuntimeException("Stub!");
    }

    public void getCurrentSizeRange(Point outSmallestSize, Point outLargestSize) {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public int getWidth() {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public int getHeight() {
        throw new RuntimeException("Stub!");
    }

    public int getRotation() {
        throw new RuntimeException("Stub!");
    }

    @Deprecated
    public native int getOrientation();

    public int getPixelFormat() {
        throw new RuntimeException("Stub!");
    }

    public float getRefreshRate() {
        throw new RuntimeException("Stub!");
    }

    public void getMetrics(DisplayMetrics outMetrics) {
        throw new RuntimeException("Stub!");
    }

    public static final class HdrCapabilities
    implements Parcelable {
        public static final float INVALID_LUMINANCE = -1.0f;
        public static final int HDR_TYPE_DOLBY_VISION = 1;
        public static final int HDR_TYPE_HDR10 = 2;
        public static final int HDR_TYPE_HLG = 3;
        public static final int HDR_TYPE_HDR10_PLUS = 4;
        public static final int[] HDR_TYPES = new int[]{1, 2, 3, 4};
        private int[] mSupportedHdrTypes = new int[0];
        private float mMaxLuminance = -1.0f;
        private float mMaxAverageLuminance = -1.0f;
        private float mMinLuminance = -1.0f;
        public static final Parcelable.Creator<HdrCapabilities> CREATOR = new Parcelable.Creator<HdrCapabilities>(){

            @Override
            public HdrCapabilities createFromParcel(Parcel source) {
                return new HdrCapabilities(source);
            }

            public HdrCapabilities[] newArray(int size) {
                return new HdrCapabilities[size];
            }
        };

        public HdrCapabilities() {
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public HdrCapabilities(int[] supportedHdrTypes, float maxLuminance, float maxAverageLuminance, float minLuminance) {
            this.mSupportedHdrTypes = supportedHdrTypes;
            Arrays.sort(this.mSupportedHdrTypes);
            this.mMaxLuminance = maxLuminance;
            this.mMaxAverageLuminance = maxAverageLuminance;
            this.mMinLuminance = minLuminance;
        }

        public int[] getSupportedHdrTypes() {
            return this.mSupportedHdrTypes;
        }

        public float getDesiredMaxLuminance() {
            return this.mMaxLuminance;
        }

        public float getDesiredMaxAverageLuminance() {
            return this.mMaxAverageLuminance;
        }

        public float getDesiredMinLuminance() {
            return this.mMinLuminance;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HdrCapabilities)) {
                return false;
            }
            HdrCapabilities that = (HdrCapabilities)other;
            return Arrays.equals(this.mSupportedHdrTypes, that.mSupportedHdrTypes) && this.mMaxLuminance == that.mMaxLuminance && this.mMaxAverageLuminance == that.mMaxAverageLuminance && this.mMinLuminance == that.mMinLuminance;
        }

        public int hashCode() {
            int hash = 23;
            hash = hash * 17 + Arrays.hashCode(this.mSupportedHdrTypes);
            hash = hash * 17 + Float.floatToIntBits(this.mMaxLuminance);
            hash = hash * 17 + Float.floatToIntBits(this.mMaxAverageLuminance);
            hash = hash * 17 + Float.floatToIntBits(this.mMinLuminance);
            return hash;
        }

        private HdrCapabilities(Parcel source) {
            this.readFromParcel(source);
        }

        public void readFromParcel(Parcel source) {
            int types = source.readInt();
            this.mSupportedHdrTypes = new int[types];
            for (int i = 0; i < types; ++i) {
                this.mSupportedHdrTypes[i] = source.readInt();
            }
            this.mMaxLuminance = source.readFloat();
            this.mMaxAverageLuminance = source.readFloat();
            this.mMinLuminance = source.readFloat();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mSupportedHdrTypes.length);
            for (int i = 0; i < this.mSupportedHdrTypes.length; ++i) {
                dest.writeInt(this.mSupportedHdrTypes[i]);
            }
            dest.writeFloat(this.mMaxLuminance);
            dest.writeFloat(this.mMaxAverageLuminance);
            dest.writeFloat(this.mMinLuminance);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public String toString() {
            return "HdrCapabilities{mSupportedHdrTypes=" + Arrays.toString(this.mSupportedHdrTypes) + ", mMaxLuminance=" + this.mMaxLuminance + ", mMaxAverageLuminance=" + this.mMaxAverageLuminance + ", mMinLuminance=" + this.mMinLuminance + '}';
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface HdrType {
        }
    }

    public static final class Mode
    implements Parcelable {
        public static final Mode[] EMPTY_ARRAY = new Mode[0];
        private final int mModeId;
        private final int mWidth;
        private final int mHeight;
        private final float mRefreshRate;
        private final float[] mAlternativeRefreshRates;
        public static final Parcelable.Creator<Mode> CREATOR = new Parcelable.Creator<Mode>(){

            @Override
            public Mode createFromParcel(Parcel in) {
                return new Mode(in);
            }

            public Mode[] newArray(int size) {
                return new Mode[size];
            }
        };

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Mode(int modeId, int width, int height, float refreshRate) {
            this(modeId, width, height, refreshRate, new float[0]);
        }

        public Mode(int modeId, int width, int height, float refreshRate, float[] alternativeRefreshRates) {
            this.mModeId = modeId;
            this.mWidth = width;
            this.mHeight = height;
            this.mRefreshRate = refreshRate;
            this.mAlternativeRefreshRates = Arrays.copyOf(alternativeRefreshRates, alternativeRefreshRates.length);
            Arrays.sort(this.mAlternativeRefreshRates);
        }

        public int getModeId() {
            return this.mModeId;
        }

        public int getPhysicalWidth() {
            return this.mWidth;
        }

        public int getPhysicalHeight() {
            return this.mHeight;
        }

        public float getRefreshRate() {
            return this.mRefreshRate;
        }

        public float[] getAlternativeRefreshRates() {
            return this.mAlternativeRefreshRates;
        }

        public boolean matches(int width, int height, float refreshRate) {
            return this.mWidth == width && this.mHeight == height && Float.floatToIntBits(this.mRefreshRate) == Float.floatToIntBits(refreshRate);
        }

        public boolean equalsExceptRefreshRate(Mode other) {
            return this.mWidth == other.mWidth && this.mHeight == other.mHeight;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mode)) {
                return false;
            }
            Mode that = (Mode)other;
            return this.mModeId == that.mModeId && this.matches(that.mWidth, that.mHeight, that.mRefreshRate) && Arrays.equals(this.mAlternativeRefreshRates, that.mAlternativeRefreshRates);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 17 + this.mModeId;
            hash = hash * 17 + this.mWidth;
            hash = hash * 17 + this.mHeight;
            hash = hash * 17 + Float.floatToIntBits(this.mRefreshRate);
            hash = hash * 17 + Arrays.hashCode(this.mAlternativeRefreshRates);
            return hash;
        }

        public String toString() {
            return "{" + "id=" + this.mModeId + ", width=" + this.mWidth + ", height=" + this.mHeight + ", fps=" + this.mRefreshRate + ", alternativeRefreshRates=" + Arrays.toString(this.mAlternativeRefreshRates) + "}";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        private Mode(Parcel in) {
            this(in.readInt(), in.readInt(), in.readInt(), in.readFloat(), in.createFloatArray());
        }

        @Override
        public void writeToParcel(Parcel out, int parcelableFlags) {
            out.writeInt(this.mModeId);
            out.writeInt(this.mWidth);
            out.writeInt(this.mHeight);
            out.writeFloat(this.mRefreshRate);
            out.writeFloatArray(this.mAlternativeRefreshRates);
        }
    }
}

