/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayAdjustments;

public final class DisplayInfo
implements Parcelable {
    public int layerStack;
    public int flags;
    public int type;
    public int displayId;
    public int displayGroupId;
    public Object address;
    public Object deviceProductInfo;
    public String name;
    public String uniqueId;
    public int appWidth;
    public int appHeight;
    public int smallestNominalAppWidth;
    public int smallestNominalAppHeight;
    public int largestNominalAppWidth;
    public int largestNominalAppHeight;
    @UnsupportedAppUsage
    public int logicalWidth;
    @UnsupportedAppUsage
    public int logicalHeight;
    @UnsupportedAppUsage(maxTargetSdk=28)
    public Object displayCutout;
    @UnsupportedAppUsage
    public int rotation;
    public int modeId;
    public int defaultModeId;
    public Display.Mode[] supportedModes = Display.Mode.EMPTY_ARRAY;
    public int colorMode;
    public int[] supportedColorModes = new int[]{0};
    public Display.HdrCapabilities hdrCapabilities;
    public int[] userDisabledHdrTypes = new int[0];
    public boolean minimalPostProcessingSupported;
    public int logicalDensityDpi;
    public float physicalXDpi;
    public float physicalYDpi;
    public long appVsyncOffsetNanos;
    public long presentationDeadlineNanos;
    public int state;
    public int ownerUid;
    public String ownerPackageName;
    public float refreshRateOverride;
    public int removeMode = 0;
    public float brightnessMinimum;
    public float brightnessMaximum;
    public float brightnessDefault;
    public Object roundedCorners;
    public static final Parcelable.Creator<DisplayInfo> CREATOR = new Parcelable.Creator<DisplayInfo>(){

        @Override
        public DisplayInfo createFromParcel(Parcel source) {
            return new DisplayInfo(source);
        }

        public DisplayInfo[] newArray(int size) {
            return new DisplayInfo[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769467L)
    public DisplayInfo() {
    }

    public DisplayInfo(DisplayInfo other) {
        this.copyFrom(other);
    }

    private DisplayInfo(Parcel source) {
        this.readFromParcel(source);
    }

    public boolean equals(Object o) {
        return o instanceof DisplayInfo && this.equals((DisplayInfo)o);
    }

    public boolean equals(DisplayInfo other) {
        throw new IllegalStateException("STUB");
    }

    public int hashCode() {
        return 0;
    }

    public void copyFrom(DisplayInfo other) {
        throw new IllegalStateException("STUB");
    }

    public void readFromParcel(Parcel source) {
        throw new IllegalStateException("STUB");
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        throw new IllegalStateException("STUB");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public float getRefreshRate() {
        if (this.refreshRateOverride > 0.0f) {
            return this.refreshRateOverride;
        }
        return this.getMode().getRefreshRate();
    }

    public Display.Mode getMode() {
        return this.findMode(this.modeId);
    }

    public Display.Mode getDefaultMode() {
        return this.findMode(this.defaultModeId);
    }

    private Display.Mode findMode(int id2) {
        for (int i = 0; i < this.supportedModes.length; ++i) {
            if (this.supportedModes[i].getModeId() != id2) continue;
            return this.supportedModes[i];
        }
        throw new IllegalStateException("Unable to locate mode " + id2);
    }

    public Display.Mode findDefaultModeByRefreshRate(float refreshRate) {
        throw new IllegalStateException("STUB");
    }

    public float[] getDefaultRefreshRates() {
        throw new IllegalStateException("STUB");
    }

    public void getAppMetrics(DisplayMetrics outMetrics) {
        this.getAppMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
    }

    public void getAppMetrics(DisplayMetrics outMetrics, DisplayAdjustments displayAdjustments) {
        this.getMetricsWithSize(outMetrics, displayAdjustments.getCompatibilityInfo(), displayAdjustments.getConfiguration(), this.appWidth, this.appHeight);
    }

    public void getAppMetrics(DisplayMetrics outMetrics, CompatibilityInfo ci, Configuration configuration) {
        this.getMetricsWithSize(outMetrics, ci, configuration, this.appWidth, this.appHeight);
    }

    public void getLogicalMetrics(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration) {
        this.getMetricsWithSize(outMetrics, compatInfo, configuration, this.logicalWidth, this.logicalHeight);
    }

    public void getMaxBoundsMetrics(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration) {
        throw new IllegalStateException("STUB");
    }

    public int getNaturalWidth() {
        return this.rotation == 0 || this.rotation == 2 ? this.logicalWidth : this.logicalHeight;
    }

    public int getNaturalHeight() {
        return this.rotation == 0 || this.rotation == 2 ? this.logicalHeight : this.logicalWidth;
    }

    public boolean isHdr() {
        throw new IllegalStateException("STUB");
    }

    public boolean isWideColorGamut() {
        throw new IllegalStateException("STUB");
    }

    public boolean hasAccess(int uid) {
        throw new IllegalStateException("STUB");
    }

    private void getMetricsWithSize(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration, int width, int height) {
        throw new IllegalStateException("STUB");
    }

    public String toString() {
        throw new IllegalStateException("STUB");
    }

    public void dumpDebug(Object protoOutputStream, long fieldId) {
        throw new IllegalStateException("STUB");
    }

    private static String flagsToString(int flags) {
        throw new IllegalStateException("STUB");
    }
}

