/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.InputWindowHandle;
import android.view.Surface;
import android.view.SurfaceSession;
import android.view.View;
import java.io.Closeable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class SurfaceControl
implements Parcelable {
    private static final String TAG = "SurfaceControl";
    public static final int BUFFER_TRANSFORM_IDENTITY = 0;
    public static final int BUFFER_TRANSFORM_MIRROR_HORIZONTAL = 1;
    public static final int BUFFER_TRANSFORM_MIRROR_VERTICAL = 2;
    public static final int BUFFER_TRANSFORM_ROTATE_90 = 4;
    public static final int BUFFER_TRANSFORM_ROTATE_180 = 3;
    public static final int BUFFER_TRANSFORM_ROTATE_270 = 7;
    private ArrayList<OnReparentListener> mReparentListeners;
    private String mName;
    public long mNativeObject;
    private long mNativeHandle;
    private final Object mLock = new Object();
    private int mWidth;
    private int mHeight;
    private WeakReference<View> mLocalOwnerView;
    static GlobalTransactionWrapper sGlobalTransaction;
    static long sTransactionNestCount;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int HIDDEN = 4;
    public static final int SKIP_SCREENSHOT = 64;
    public static final int SECURE = 128;
    public static final int ENABLE_BACKPRESSURE = 256;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int PROTECTED_APP = 2048;
    public static final int CURSOR_WINDOW = 8192;
    public static final int NO_COLOR_FILL = 16384;
    public static final int FX_SURFACE_NORMAL = 0;
    public static final int FX_SURFACE_EFFECT = 131072;
    public static final int FX_SURFACE_CONTAINER = 524288;
    public static final int FX_SURFACE_BLAST = 262144;
    public static final int FX_SURFACE_MASK = 983040;
    private static final int SURFACE_HIDDEN = 1;
    private static final int SURFACE_OPAQUE = 2;
    public static final int DISPLAY_RECEIVES_INPUT = 1;
    public static final int POWER_MODE_OFF = 0;
    public static final int POWER_MODE_DOZE = 1;
    public static final int POWER_MODE_NORMAL = 2;
    public static final int POWER_MODE_DOZE_SUSPEND = 3;
    public static final int POWER_MODE_ON_SUSPEND = 4;
    private static final int INTERNAL_DATASPACE_SRGB = 0x8810000;
    private static final int INTERNAL_DATASPACE_DISPLAY_P3 = 0x88A0000;
    private static final int INTERNAL_DATASPACE_SCRGB = 0x18810000;
    public static final int METADATA_OWNER_UID = 1;
    public static final int METADATA_WINDOW_TYPE = 2;
    public static final int METADATA_TASK_ID = 3;
    public static final int METADATA_MOUSE_CURSOR = 4;
    public static final int METADATA_ACCESSIBILITY_ID = 5;
    public static final int METADATA_OWNER_PID = 6;
    public static final int METADATA_GAME_MODE = 8;
    public static final Parcelable.Creator<SurfaceControl> CREATOR;

    private static native long nativeCreate(SurfaceSession var0, String var1, int var2, int var3, int var4, int var5, long var6, Parcel var8) throws Surface.OutOfResourcesException;

    private static native long nativeReadFromParcel(Parcel var0);

    private static native long nativeCopyFromSurfaceControl(long var0);

    private static native void nativeWriteToParcel(long var0, Parcel var2);

    private static native void nativeRelease(long var0);

    private static native void nativeDisconnect(long var0);

    private static native void nativeUpdateDefaultBufferSize(long var0, int var2, int var3);

    private static native int nativeCaptureDisplay(DisplayCaptureArgs var0, ScreenCaptureListener var1);

    private static native int nativeCaptureLayers(LayerCaptureArgs var0, ScreenCaptureListener var1);

    private static native long nativeMirrorSurface(long var0);

    private static native long nativeCreateTransaction();

    private static native long nativeGetNativeTransactionFinalizer();

    private static native void nativeApplyTransaction(long var0, boolean var2);

    private static native void nativeMergeTransaction(long var0, long var2);

    private static native void nativeClearTransaction(long var0);

    private static native void nativeSetAnimationTransaction(long var0);

    private static native void nativeSetEarlyWakeupStart(long var0);

    private static native void nativeSetEarlyWakeupEnd(long var0);

    private static native void nativeSetLayer(long var0, long var2, int var4);

    private static native void nativeSetRelativeLayer(long var0, long var2, long var4, int var6);

    private static native void nativeSetPosition(long var0, long var2, float var4, float var5);

    private static native void nativeSetSize(long var0, long var2, int var4, int var5);

    private static native void nativeSetTransparentRegionHint(long var0, long var2, Region var4);

    private static native void nativeSetAlpha(long var0, long var2, float var4);

    private static native void nativeSetMatrix(long var0, long var2, float var4, float var5, float var6, float var7);

    private static native void nativeSetColorTransform(long var0, long var2, float[] var4, float[] var5);

    private static native void nativeSetColorSpaceAgnostic(long var0, long var2, boolean var4);

    private static native void nativeSetGeometry(long var0, long var2, Rect var4, Rect var5, long var6);

    private static native void nativeSetColor(long var0, long var2, float[] var4);

    private static native void nativeSetFlags(long var0, long var2, int var4, int var5);

    private static native void nativeSetFrameRateSelectionPriority(long var0, long var2, int var4);

    private static native void nativeSetWindowCrop(long var0, long var2, int var4, int var5, int var6, int var7);

    private static native void nativeSetCornerRadius(long var0, long var2, float var4);

    private static native void nativeSetBackgroundBlurRadius(long var0, long var2, int var4);

    private static native void nativeSetLayerStack(long var0, long var2, int var4);

    private static native void nativeSetBlurRegions(long var0, long var2, float[][] var4, int var5);

    private static native void nativeSetStretchEffect(long var0, long var2, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13);

    private static native void nativeSetTrustedOverlay(long var0, long var2, boolean var4);

    private static native void nativeSetDropInputMode(long var0, long var2, int var4);

    private static native boolean nativeClearContentFrameStats(long var0);

    private static native boolean nativeGetContentFrameStats(long var0, Object var2);

    private static native boolean nativeClearAnimationFrameStats();

    private static native boolean nativeGetAnimationFrameStats(Object var0);

    private static native long[] nativeGetPhysicalDisplayIds();

    private static native long nativeGetPrimaryPhysicalDisplayId();

    private static native IBinder nativeGetPhysicalDisplayToken(long var0);

    private static native IBinder nativeCreateDisplay(String var0, boolean var1);

    private static native void nativeDestroyDisplay(IBinder var0);

    private static native void nativeSetDisplaySurface(long var0, IBinder var2, long var3);

    private static native void nativeSetDisplayLayerStack(long var0, IBinder var2, int var3);

    private static native void nativeSetDisplayFlags(long var0, IBinder var2, int var3);

    private static native void nativeSetDisplayProjection(long var0, IBinder var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private static native void nativeSetDisplaySize(long var0, IBinder var2, int var3, int var4);

    private static native StaticDisplayInfo nativeGetStaticDisplayInfo(IBinder var0);

    private static native DynamicDisplayInfo nativeGetDynamicDisplayInfo(IBinder var0);

    private static native Object nativeGetDisplayedContentSamplingAttributes(IBinder var0);

    private static native boolean nativeSetDisplayedContentSamplingEnabled(IBinder var0, boolean var1, int var2, int var3);

    private static native Object nativeGetDisplayedContentSample(IBinder var0, long var1, long var3);

    private static native boolean nativeSetDesiredDisplayModeSpecs(IBinder var0, DesiredDisplayModeSpecs var1);

    private static native DesiredDisplayModeSpecs nativeGetDesiredDisplayModeSpecs(IBinder var0);

    private static native DisplayPrimaries nativeGetDisplayNativePrimaries(IBinder var0);

    private static native int[] nativeGetCompositionDataspaces();

    private static native boolean nativeSetActiveColorMode(IBinder var0, int var1);

    private static native void nativeSetAutoLowLatencyMode(IBinder var0, boolean var1);

    private static native void nativeSetGameContentType(IBinder var0, boolean var1);

    private static native void nativeSetDisplayPowerMode(IBinder var0, int var1);

    private static native void nativeReparent(long var0, long var2, long var4);

    private static native void nativeSetBuffer(long var0, long var2, Object var4);

    private static native void nativeSetColorSpace(long var0, long var2, int var4);

    private static native void nativeOverrideHdrTypes(IBinder var0, int[] var1);

    private static native void nativeSetInputWindowInfo(long var0, long var2, InputWindowHandle var4);

    private static native boolean nativeGetProtectedContentSupport();

    private static native void nativeSetMetadata(long var0, long var2, int var4, Parcel var5);

    private static native void nativeSyncInputWindows(long var0);

    private static native boolean nativeGetDisplayBrightnessSupport(IBinder var0);

    private static native boolean nativeSetDisplayBrightness(IBinder var0, float var1, float var2, float var3, float var4);

    private static native long nativeReadTransactionFromParcel(Parcel var0);

    private static native void nativeWriteTransactionToParcel(long var0, Parcel var2);

    private static native void nativeSetShadowRadius(long var0, long var2, float var4);

    private static native void nativeSetGlobalShadowSettings(float[] var0, float[] var1, float var2, float var3, float var4);

    private static native void nativeSetFrameRate(long var0, long var2, float var4, int var5, int var6);

    private static native long nativeGetHandle(long var0);

    private static native long nativeAcquireFrameRateFlexibilityToken();

    private static native void nativeReleaseFrameRateFlexibilityToken(long var0);

    private static native void nativeSetFixedTransformHint(long var0, long var2, int var4);

    private static native void nativeSetFocusedWindow(long var0, IBinder var2, String var3, IBinder var4, String var5, int var6);

    private static native void nativeSetFrameTimelineVsync(long var0, long var2);

    private static native void nativeAddJankDataListener(long var0, long var2);

    private static native void nativeRemoveJankDataListener(long var0);

    private static native long nativeCreateJankDataListenerWrapper(Object var0);

    private static native int nativeGetGPUContextPriority();

    private static native void nativeSetTransformHint(long var0, int var2);

    private static native int nativeGetTransformHint(long var0);

    private static native int nativeGetLayerId(long var0);

    public static int rotationToBufferTransform(int rotation) {
        switch (rotation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
        }
        Log.e(TAG, "Trying to convert unknown rotation=" + rotation);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOnReparentListener(OnReparentListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReparentListeners == null) {
                this.mReparentListeners = new ArrayList(1);
            }
            return this.mReparentListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOnReparentListener(OnReparentListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            boolean removed = this.mReparentListeners.remove(listener);
            if (this.mReparentListeners.isEmpty()) {
                this.mReparentListeners = null;
            }
            return removed;
        }
    }

    private void assignNativeObject(long nativeObject, String callsite) {
        if (this.mNativeObject != 0L) {
            this.release();
        }
        if (nativeObject != 0L) {
            // empty if block
        }
        this.mNativeObject = nativeObject;
        this.mNativeHandle = this.mNativeObject != 0L ? SurfaceControl.nativeGetHandle(nativeObject) : 0L;
    }

    public void copyFrom(SurfaceControl other, String callsite) {
        this.mName = other.mName;
        this.mWidth = other.mWidth;
        this.mHeight = other.mHeight;
        this.mLocalOwnerView = other.mLocalOwnerView;
        this.assignNativeObject(SurfaceControl.nativeCopyFromSurfaceControl(other.mNativeObject), callsite);
    }

    private SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags, SurfaceControl parent, SparseIntArray metadata, WeakReference<View> localOwnerView, String callsite) throws Surface.OutOfResourcesException, IllegalArgumentException {
        throw new IllegalStateException("STUB");
    }

    public SurfaceControl(SurfaceControl other, String callsite) {
        this.copyFrom(other, callsite);
    }

    private SurfaceControl(Parcel in) {
        this.readFromParcel(in);
    }

    public SurfaceControl() {
    }

    public void readFromParcel(Parcel in) {
        throw new IllegalStateException("STUB");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        throw new IllegalStateException("STUB");
    }

    public boolean isSameSurface(SurfaceControl other) {
        return other.mNativeHandle == this.mNativeHandle;
    }

    public void dumpDebug(Object proto, long fieldId) {
        throw new IllegalStateException("STUB");
    }

    protected void finalize() throws Throwable {
        throw new IllegalStateException("STUB");
    }

    public void release() {
        throw new IllegalStateException("STUB");
    }

    public void disconnect() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDisconnect(this.mNativeObject);
        }
    }

    private void checkNotReleased() {
        if (this.mNativeObject == 0L) {
            throw new NullPointerException("Invalid " + this + ", mNativeObject is null. Have you called release() already?");
        }
    }

    public boolean isValid() {
        return this.mNativeObject != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void openTransaction() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            if (sGlobalTransaction == null) {
                sGlobalTransaction = new GlobalTransactionWrapper();
            }
            Class<SurfaceControl> clazz2 = SurfaceControl.class;
            synchronized (SurfaceControl.class) {
                ++sTransactionNestCount;
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void mergeToGlobalTransaction(Transaction t) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.merge(t);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void closeTransaction() {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            if (sTransactionNestCount == 0L) {
                Log.e(TAG, "Call to SurfaceControl.closeTransaction without matching openTransaction");
            } else if (--sTransactionNestCount > 0L) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            sGlobalTransaction.applyGlobalTransaction(false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public boolean clearContentFrameStats() {
        this.checkNotReleased();
        return SurfaceControl.nativeClearContentFrameStats(this.mNativeObject);
    }

    public boolean getContentFrameStats(Object outStats) {
        this.checkNotReleased();
        return SurfaceControl.nativeGetContentFrameStats(this.mNativeObject, outStats);
    }

    public static boolean clearAnimationFrameStats() {
        return SurfaceControl.nativeClearAnimationFrameStats();
    }

    public static boolean getAnimationFrameStats(Object outStats) {
        return SurfaceControl.nativeGetAnimationFrameStats(outStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mHeight;
        }
    }

    public View getLocalOwnerView() {
        return this.mLocalOwnerView != null ? (View)this.mLocalOwnerView.get() : null;
    }

    public String toString() {
        return "Surface(name=" + this.mName + ")/@0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public static void setDisplayPowerMode(IBinder displayToken, int mode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayPowerMode(displayToken, mode);
    }

    public static StaticDisplayInfo getStaticDisplayInfo(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetStaticDisplayInfo(displayToken);
    }

    public static DynamicDisplayInfo getDynamicDisplayInfo(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDynamicDisplayInfo(displayToken);
    }

    public static Object getDisplayedContentSamplingAttributes(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayedContentSamplingAttributes(displayToken);
    }

    public static boolean setDisplayedContentSamplingEnabled(IBinder displayToken, boolean enable, int componentMask, int maxFrames) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        int maxColorComponents = 4;
        if (componentMask >> 4 != 0) {
            throw new IllegalArgumentException("invalid componentMask when enabling sampling");
        }
        return SurfaceControl.nativeSetDisplayedContentSamplingEnabled(displayToken, enable, componentMask, maxFrames);
    }

    public static Object getDisplayedContentSample(IBinder displayToken, long maxFrames, long timestamp) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayedContentSample(displayToken, maxFrames, timestamp);
    }

    public static boolean setDesiredDisplayModeSpecs(IBinder displayToken, DesiredDisplayModeSpecs desiredDisplayModeSpecs) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (desiredDisplayModeSpecs == null) {
            throw new IllegalArgumentException("desiredDisplayModeSpecs must not be null");
        }
        if (desiredDisplayModeSpecs.defaultMode < 0) {
            throw new IllegalArgumentException("defaultMode must be non-negative");
        }
        return SurfaceControl.nativeSetDesiredDisplayModeSpecs(displayToken, desiredDisplayModeSpecs);
    }

    public static DesiredDisplayModeSpecs getDesiredDisplayModeSpecs(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDesiredDisplayModeSpecs(displayToken);
    }

    public static DisplayPrimaries getDisplayNativePrimaries(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayNativePrimaries(displayToken);
    }

    public static boolean setActiveColorMode(IBinder displayToken, int colorMode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveColorMode(displayToken, colorMode);
    }

    public static Object[] getCompositionColorSpaces() {
        throw new IllegalStateException("STUB");
    }

    public static void setAutoLowLatencyMode(IBinder displayToken, boolean on) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetAutoLowLatencyMode(displayToken, on);
    }

    public static void setGameContentType(IBinder displayToken, boolean on) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetGameContentType(displayToken, on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplayProjection(displayToken, orientation, layerStackRect, displayRect);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setDisplayLayerStack(IBinder displayToken, int layerStack) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplayLayerStack(displayToken, layerStack);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setDisplaySurface(IBinder displayToken, Surface surface) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplaySurface(displayToken, surface);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplaySize(IBinder displayToken, int width, int height) {
        Class<SurfaceControl> clazz = SurfaceControl.class;
        synchronized (SurfaceControl.class) {
            sGlobalTransaction.setDisplaySize(displayToken, width, height);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void overrideHdrTypes(IBinder displayToken, int[] modes) {
        SurfaceControl.nativeOverrideHdrTypes(displayToken, modes);
    }

    @UnsupportedAppUsage
    public static IBinder createDisplay(String name, boolean secure) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return SurfaceControl.nativeCreateDisplay(name, secure);
    }

    @UnsupportedAppUsage
    public static void destroyDisplay(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeDestroyDisplay(displayToken);
    }

    public static long[] getPhysicalDisplayIds() {
        return SurfaceControl.nativeGetPhysicalDisplayIds();
    }

    public static long getPrimaryPhysicalDisplayId() {
        return SurfaceControl.nativeGetPrimaryPhysicalDisplayId();
    }

    public static IBinder getPhysicalDisplayToken(long physicalDisplayId) {
        return SurfaceControl.nativeGetPhysicalDisplayToken(physicalDisplayId);
    }

    public static IBinder getInternalDisplayToken() {
        long[] physicalDisplayIds = SurfaceControl.getPhysicalDisplayIds();
        if (physicalDisplayIds.length == 0) {
            return null;
        }
        return SurfaceControl.getPhysicalDisplayToken(physicalDisplayIds[0]);
    }

    public static int captureDisplay(DisplayCaptureArgs captureArgs, ScreenCaptureListener captureListener) {
        return SurfaceControl.nativeCaptureDisplay(captureArgs, captureListener);
    }

    public static ScreenshotHardwareBuffer captureDisplay(DisplayCaptureArgs captureArgs) {
        SyncScreenCaptureListener screenCaptureListener = new SyncScreenCaptureListener();
        int status = SurfaceControl.captureDisplay(captureArgs, screenCaptureListener);
        if (status != 0) {
            return null;
        }
        return screenCaptureListener.waitForScreenshot();
    }

    public static ScreenshotHardwareBuffer captureLayers(SurfaceControl layer, Rect sourceCrop, float frameScale) {
        return SurfaceControl.captureLayers(layer, sourceCrop, frameScale, 1);
    }

    public static ScreenshotHardwareBuffer captureLayers(SurfaceControl layer, Rect sourceCrop, float frameScale, int format) {
        LayerCaptureArgs captureArgs = ((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)new LayerCaptureArgs.Builder(layer).setSourceCrop(sourceCrop)).setFrameScale(frameScale)).setPixelFormat(format)).build();
        return SurfaceControl.captureLayers(captureArgs);
    }

    public static ScreenshotHardwareBuffer captureLayers(LayerCaptureArgs captureArgs) {
        SyncScreenCaptureListener screenCaptureListener = new SyncScreenCaptureListener();
        int status = SurfaceControl.captureLayers(captureArgs, screenCaptureListener);
        if (status != 0) {
            return null;
        }
        return screenCaptureListener.waitForScreenshot();
    }

    public static ScreenshotHardwareBuffer captureLayersExcluding(SurfaceControl layer, Rect sourceCrop, float frameScale, int format, SurfaceControl[] exclude) {
        LayerCaptureArgs captureArgs = ((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)((LayerCaptureArgs.Builder)new LayerCaptureArgs.Builder(layer).setSourceCrop(sourceCrop)).setFrameScale(frameScale)).setPixelFormat(format)).setExcludeLayers(exclude).build();
        return SurfaceControl.captureLayers(captureArgs);
    }

    public static int captureLayers(LayerCaptureArgs captureArgs, ScreenCaptureListener captureListener) {
        return SurfaceControl.nativeCaptureLayers(captureArgs, captureListener);
    }

    public static boolean getProtectedContentSupport() {
        return SurfaceControl.nativeGetProtectedContentSupport();
    }

    public static boolean getDisplayBrightnessSupport(IBinder displayToken) {
        return SurfaceControl.nativeGetDisplayBrightnessSupport(displayToken);
    }

    public static boolean setDisplayBrightness(IBinder displayToken, float brightness) {
        return SurfaceControl.setDisplayBrightness(displayToken, brightness, -1.0f, brightness, -1.0f);
    }

    public static boolean setDisplayBrightness(IBinder displayToken, float sdrBrightness, float sdrBrightnessNits, float displayBrightness, float displayBrightnessNits) {
        Objects.requireNonNull(displayToken);
        if (Float.isNaN(displayBrightness) || displayBrightness > 1.0f || displayBrightness < 0.0f && displayBrightness != -1.0f) {
            throw new IllegalArgumentException("displayBrightness must be a number between 0.0f  and 1.0f, or -1 to turn the backlight off: " + displayBrightness);
        }
        if (Float.isNaN(sdrBrightness) || sdrBrightness > 1.0f || sdrBrightness < 0.0f && sdrBrightness != -1.0f) {
            throw new IllegalArgumentException("sdrBrightness must be a number between 0.0f and 1.0f, or -1 to turn the backlight off: " + sdrBrightness);
        }
        return SurfaceControl.nativeSetDisplayBrightness(displayToken, sdrBrightness, sdrBrightnessNits, displayBrightness, displayBrightnessNits);
    }

    public static SurfaceControl mirrorSurface(SurfaceControl mirrorOf) {
        long nativeObj = SurfaceControl.nativeMirrorSurface(mirrorOf.mNativeObject);
        SurfaceControl sc = new SurfaceControl();
        sc.assignNativeObject(nativeObj, "mirrorSurface");
        return sc;
    }

    private static void validateColorArg(float[] color2) {
        String msg = "Color must be specified as a float array with four values to represent r, g, b, a in range [0..1]";
        if (color2.length != 4) {
            throw new IllegalArgumentException("Color must be specified as a float array with four values to represent r, g, b, a in range [0..1]");
        }
        for (float c : color2) {
            if (!(c < 0.0f) && !(c > 1.0f)) continue;
            throw new IllegalArgumentException("Color must be specified as a float array with four values to represent r, g, b, a in range [0..1]");
        }
    }

    public static void setGlobalShadowSettings(float[] ambientColor, float[] spotColor, float lightPosY, float lightPosZ, float lightRadius) {
        SurfaceControl.validateColorArg(ambientColor);
        SurfaceControl.validateColorArg(spotColor);
        SurfaceControl.nativeSetGlobalShadowSettings(ambientColor, spotColor, lightPosY, lightPosZ, lightRadius);
    }

    public static void addJankDataListener(Object listener, SurfaceControl surface) {
        throw new IllegalStateException("STUB");
    }

    public static void removeJankDataListener(Object listener) {
        throw new IllegalStateException("STUB");
    }

    public static int getGPUContextPriority() {
        return SurfaceControl.nativeGetGPUContextPriority();
    }

    public static long acquireFrameRateFlexibilityToken() {
        return SurfaceControl.nativeAcquireFrameRateFlexibilityToken();
    }

    public static void releaseFrameRateFlexibilityToken(long token) {
        SurfaceControl.nativeReleaseFrameRateFlexibilityToken(token);
    }

    public static Transaction getGlobalTransaction() {
        return sGlobalTransaction;
    }

    public void resize(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
        SurfaceControl.nativeUpdateDefaultBufferSize(this.mNativeObject, w, h);
    }

    public int getTransformHint() {
        this.checkNotReleased();
        return SurfaceControl.nativeGetTransformHint(this.mNativeObject);
    }

    public void setTransformHint(int transformHint) {
        SurfaceControl.nativeSetTransformHint(this.mNativeObject, transformHint);
    }

    public int getLayerId() {
        if (this.mNativeObject != 0L) {
            return SurfaceControl.nativeGetLayerId(this.mNativeObject);
        }
        return -1;
    }

    static {
        sTransactionNestCount = 0L;
        CREATOR = new Parcelable.Creator<SurfaceControl>(){

            @Override
            public SurfaceControl createFromParcel(Parcel in) {
                return new SurfaceControl(in);
            }

            public SurfaceControl[] newArray(int size) {
                return new SurfaceControl[size];
            }
        };
    }

    private static class GlobalTransactionWrapper
    extends Transaction {
        private GlobalTransactionWrapper() {
        }

        void applyGlobalTransaction(boolean sync) {
            this.applyResizedSurfaces();
            this.notifyReparentedSurfaces();
            SurfaceControl.nativeApplyTransaction(this.mNativeObject, sync);
        }

        @Override
        public void apply(boolean sync) {
            throw new RuntimeException("Global transaction must be applied from closeTransaction");
        }
    }

    public static class LockDebuggingTransaction
    extends Transaction {
        Object mMonitor;

        public LockDebuggingTransaction(Object o) {
            this.mMonitor = o;
        }

        @Override
        protected void checkPreconditions(SurfaceControl sc) {
            super.checkPreconditions(sc);
            if (!Thread.holdsLock(this.mMonitor)) {
                throw new RuntimeException("Unlocked access to synchronized SurfaceControl.Transaction");
            }
        }
    }

    public static class Transaction
    implements Closeable,
    Parcelable {
        public long mNativeObject;
        private final ArrayMap<SurfaceControl, Point> mResizedSurfaces = new ArrayMap();
        private final ArrayMap<SurfaceControl, SurfaceControl> mReparentedSurfaces = new ArrayMap();
        Runnable mFreeNativeResources;
        private static final float[] INVALID_COLOR = new float[]{-1.0f, -1.0f, -1.0f};
        public static final Parcelable.Creator<Transaction> CREATOR = new Parcelable.Creator<Transaction>(){

            @Override
            public Transaction createFromParcel(Parcel in) {
                return new Transaction(in);
            }

            public Transaction[] newArray(int size) {
                return new Transaction[size];
            }
        };

        protected void checkPreconditions(SurfaceControl sc) {
            sc.checkNotReleased();
        }

        public Transaction() {
            throw new IllegalStateException("STUB");
        }

        private Transaction(Parcel in) {
            this.readFromParcel(in);
        }

        public void apply() {
            this.apply(false);
        }

        public void clear() {
            this.mResizedSurfaces.clear();
            this.mReparentedSurfaces.clear();
            if (this.mNativeObject != 0L) {
                SurfaceControl.nativeClearTransaction(this.mNativeObject);
            }
        }

        @Override
        public void close() {
            this.mResizedSurfaces.clear();
            this.mReparentedSurfaces.clear();
            this.mFreeNativeResources.run();
            this.mNativeObject = 0L;
        }

        public void apply(boolean sync) {
            this.applyResizedSurfaces();
            this.notifyReparentedSurfaces();
            SurfaceControl.nativeApplyTransaction(this.mNativeObject, sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void applyResizedSurfaces() {
            for (int i = this.mResizedSurfaces.size() - 1; i >= 0; --i) {
                Point size = this.mResizedSurfaces.valueAt(i);
                SurfaceControl surfaceControl = this.mResizedSurfaces.keyAt(i);
                Object object = surfaceControl.mLock;
                synchronized (object) {
                    surfaceControl.resize(size.x, size.y);
                    continue;
                }
            }
            this.mResizedSurfaces.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyReparentedSurfaces() {
            int reparentCount = this.mReparentedSurfaces.size();
            for (int i = reparentCount - 1; i >= 0; --i) {
                SurfaceControl child = this.mReparentedSurfaces.keyAt(i);
                Object object = child.mLock;
                synchronized (object) {
                    int listenerCount = child.mReparentListeners != null ? child.mReparentListeners.size() : 0;
                    for (int j = 0; j < listenerCount; ++j) {
                        OnReparentListener listener = (OnReparentListener)child.mReparentListeners.get(j);
                        listener.onReparent(this, this.mReparentedSurfaces.valueAt(i));
                    }
                    this.mReparentedSurfaces.removeAt(i);
                    continue;
                }
            }
        }

        public Transaction setVisibility(SurfaceControl sc, boolean visible) {
            this.checkPreconditions(sc);
            if (visible) {
                return this.show(sc);
            }
            return this.hide(sc);
        }

        public Transaction setFrameRateSelectionPriority(SurfaceControl sc, int priority) {
            sc.checkNotReleased();
            SurfaceControl.nativeSetFrameRateSelectionPriority(this.mNativeObject, sc.mNativeObject, priority);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction show(SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 1);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction hide(SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 1, 1);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setPosition(SurfaceControl sc, float x, float y) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetPosition(this.mNativeObject, sc.mNativeObject, x, y);
            return this;
        }

        public Transaction setBufferSize(SurfaceControl sc, int w, int h) {
            this.checkPreconditions(sc);
            this.mResizedSurfaces.put(sc, new Point(w, h));
            SurfaceControl.nativeSetSize(this.mNativeObject, sc.mNativeObject, w, h);
            return this;
        }

        public Transaction setFixedTransformHint(SurfaceControl sc, int transformHint) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFixedTransformHint(this.mNativeObject, sc.mNativeObject, transformHint);
            return this;
        }

        public Transaction unsetFixedTransformHint(SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFixedTransformHint(this.mNativeObject, sc.mNativeObject, -1);
            return this;
        }

        public Transaction setLayer(SurfaceControl sc, int z) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetLayer(this.mNativeObject, sc.mNativeObject, z);
            return this;
        }

        public Transaction setRelativeLayer(SurfaceControl sc, SurfaceControl relativeTo, int z) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetRelativeLayer(this.mNativeObject, sc.mNativeObject, relativeTo.mNativeObject, z);
            return this;
        }

        public Transaction setTransparentRegionHint(SurfaceControl sc, Region transparentRegion) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetTransparentRegionHint(this.mNativeObject, sc.mNativeObject, transparentRegion);
            return this;
        }

        public Transaction setAlpha(SurfaceControl sc, float alpha) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetAlpha(this.mNativeObject, sc.mNativeObject, alpha);
            return this;
        }

        public Transaction setInputWindowInfo(SurfaceControl sc, InputWindowHandle handle) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetInputWindowInfo(this.mNativeObject, sc.mNativeObject, handle);
            return this;
        }

        public Transaction syncInputWindows() {
            SurfaceControl.nativeSyncInputWindows(this.mNativeObject);
            return this;
        }

        public Transaction setGeometry(SurfaceControl sc, Rect sourceCrop, Rect destFrame, int orientation) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetGeometry(this.mNativeObject, sc.mNativeObject, sourceCrop, destFrame, orientation);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setMatrix(SurfaceControl sc, float dsdx, float dtdx, float dtdy, float dsdy) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetMatrix(this.mNativeObject, sc.mNativeObject, dsdx, dtdx, dtdy, dsdy);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setMatrix(SurfaceControl sc, Matrix matrix, float[] float9) {
            matrix.getValues(float9);
            this.setMatrix(sc, float9[0], float9[3], float9[1], float9[4]);
            this.setPosition(sc, float9[2], float9[5]);
            return this;
        }

        public Transaction setColorTransform(SurfaceControl sc, float[] matrix, float[] translation) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColorTransform(this.mNativeObject, sc.mNativeObject, matrix, translation);
            return this;
        }

        public Transaction setColorSpaceAgnostic(SurfaceControl sc, boolean agnostic) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColorSpaceAgnostic(this.mNativeObject, sc.mNativeObject, agnostic);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setWindowCrop(SurfaceControl sc, Rect crop) {
            this.checkPreconditions(sc);
            if (crop != null) {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
            } else {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, 0, 0);
            }
            return this;
        }

        public Transaction setWindowCrop(SurfaceControl sc, int width, int height) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, width, height);
            return this;
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Transaction setCornerRadius(SurfaceControl sc, float cornerRadius) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetCornerRadius(this.mNativeObject, sc.mNativeObject, cornerRadius);
            return this;
        }

        public Transaction setBackgroundBlurRadius(SurfaceControl sc, int radius) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetBackgroundBlurRadius(this.mNativeObject, sc.mNativeObject, radius);
            return this;
        }

        public Transaction setBlurRegions(SurfaceControl sc, float[][] regions) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetBlurRegions(this.mNativeObject, sc.mNativeObject, regions, regions.length);
            return this;
        }

        public Transaction setStretchEffect(SurfaceControl sc, float width, float height, float vecX, float vecY, float maxStretchAmountX, float maxStretchAmountY, float childRelativeLeft, float childRelativeTop, float childRelativeRight, float childRelativeBottom) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetStretchEffect(this.mNativeObject, sc.mNativeObject, width, height, vecX, vecY, maxStretchAmountX, maxStretchAmountY, childRelativeLeft, childRelativeTop, childRelativeRight, childRelativeBottom);
            return this;
        }

        @UnsupportedAppUsage(maxTargetSdk=26)
        public Transaction setLayerStack(SurfaceControl sc, int layerStack) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetLayerStack(this.mNativeObject, sc.mNativeObject, layerStack);
            return this;
        }

        public Transaction reparent(SurfaceControl sc, SurfaceControl newParent) {
            this.checkPreconditions(sc);
            long otherObject = 0L;
            if (newParent != null) {
                newParent.checkNotReleased();
                otherObject = newParent.mNativeObject;
            }
            SurfaceControl.nativeReparent(this.mNativeObject, sc.mNativeObject, otherObject);
            this.mReparentedSurfaces.put(sc, newParent);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setColor(SurfaceControl sc, float[] color2) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColor(this.mNativeObject, sc.mNativeObject, color2);
            return this;
        }

        public Transaction unsetColor(SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColor(this.mNativeObject, sc.mNativeObject, Transaction.INVALID_COLOR);
            return this;
        }

        public Transaction setSecure(SurfaceControl sc, boolean isSecure) {
            this.checkPreconditions(sc);
            if (isSecure) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 128, 128);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 128);
            }
            return this;
        }

        public Transaction setOpaque(SurfaceControl sc, boolean isOpaque) {
            this.checkPreconditions(sc);
            if (isOpaque) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 2, 2);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 2);
            }
            return this;
        }

        public Transaction setDisplaySurface(IBinder displayToken, Surface surface) {
            throw new IllegalStateException("STUB");
        }

        public Transaction setDisplayLayerStack(IBinder displayToken, int layerStack) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            SurfaceControl.nativeSetDisplayLayerStack(this.mNativeObject, displayToken, layerStack);
            return this;
        }

        public Transaction setDisplayFlags(IBinder displayToken, int flags) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            SurfaceControl.nativeSetDisplayFlags(this.mNativeObject, displayToken, flags);
            return this;
        }

        public Transaction setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (layerStackRect == null) {
                throw new IllegalArgumentException("layerStackRect must not be null");
            }
            if (displayRect == null) {
                throw new IllegalArgumentException("displayRect must not be null");
            }
            SurfaceControl.nativeSetDisplayProjection(this.mNativeObject, displayToken, orientation, layerStackRect.left, layerStackRect.top, layerStackRect.right, layerStackRect.bottom, displayRect.left, displayRect.top, displayRect.right, displayRect.bottom);
            return this;
        }

        public Transaction setDisplaySize(IBinder displayToken, int width, int height) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            SurfaceControl.nativeSetDisplaySize(this.mNativeObject, displayToken, width, height);
            return this;
        }

        public Transaction setAnimationTransaction() {
            SurfaceControl.nativeSetAnimationTransaction(this.mNativeObject);
            return this;
        }

        public Transaction setEarlyWakeupStart() {
            SurfaceControl.nativeSetEarlyWakeupStart(this.mNativeObject);
            return this;
        }

        public Transaction setEarlyWakeupEnd() {
            SurfaceControl.nativeSetEarlyWakeupEnd(this.mNativeObject);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transaction setMetadata(SurfaceControl sc, int key, int data) {
            Parcel parcel = Parcel.obtain();
            parcel.writeInt(data);
            try {
                this.setMetadata(sc, key, parcel);
            }
            finally {
                parcel.recycle();
            }
            return this;
        }

        public Transaction setMetadata(SurfaceControl sc, int key, Parcel data) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetMetadata(this.mNativeObject, sc.mNativeObject, key, data);
            return this;
        }

        public Transaction setShadowRadius(SurfaceControl sc, float shadowRadius) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetShadowRadius(this.mNativeObject, sc.mNativeObject, shadowRadius);
            return this;
        }

        public Transaction setFrameRate(SurfaceControl sc, float frameRate, int compatibility) {
            throw new IllegalStateException("STUB");
        }

        public Transaction setFrameRate(SurfaceControl sc, float frameRate, int compatibility, int changeFrameRateStrategy) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFrameRate(this.mNativeObject, sc.mNativeObject, frameRate, compatibility, changeFrameRateStrategy);
            return this;
        }

        public Transaction setFocusedWindow(IBinder token, String windowName, int displayId) {
            SurfaceControl.nativeSetFocusedWindow(this.mNativeObject, token, windowName, null, null, displayId);
            return this;
        }

        public Transaction requestFocusTransfer(IBinder token, String windowName, IBinder focusedToken, String focusedWindowName, int displayId) {
            SurfaceControl.nativeSetFocusedWindow(this.mNativeObject, token, windowName, focusedToken, focusedWindowName, displayId);
            return this;
        }

        public Transaction setSkipScreenshot(SurfaceControl sc, boolean skipScrenshot) {
            this.checkPreconditions(sc);
            if (skipScrenshot) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 64, 64);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 64);
            }
            return this;
        }

        public Transaction setBuffer(SurfaceControl sc, Object buffer) {
            throw new IllegalStateException("STUB");
        }

        public Transaction setColorSpace(SurfaceControl sc, Object colorSpace) {
            throw new IllegalStateException("STUB");
        }

        public Transaction setTrustedOverlay(SurfaceControl sc, boolean isTrustedOverlay) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetTrustedOverlay(this.mNativeObject, sc.mNativeObject, isTrustedOverlay);
            return this;
        }

        public Transaction setDropInputMode(SurfaceControl sc, int mode) {
            throw new IllegalStateException("STUB");
        }

        public Transaction merge(Transaction other) {
            if (this == other) {
                return this;
            }
            this.mResizedSurfaces.putAll(other.mResizedSurfaces);
            other.mResizedSurfaces.clear();
            this.mReparentedSurfaces.putAll(other.mReparentedSurfaces);
            other.mReparentedSurfaces.clear();
            SurfaceControl.nativeMergeTransaction(this.mNativeObject, other.mNativeObject);
            return this;
        }

        public Transaction remove(SurfaceControl sc) {
            this.reparent(sc, null);
            sc.release();
            return this;
        }

        public Transaction setFrameTimelineVsync(long frameTimelineVsyncId) {
            SurfaceControl.nativeSetFrameTimelineVsync(this.mNativeObject, frameTimelineVsyncId);
            return this;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mNativeObject == 0L) {
                dest.writeInt(0);
                return;
            }
            dest.writeInt(1);
            SurfaceControl.nativeWriteTransactionToParcel(this.mNativeObject, dest);
            if ((flags & 1) != 0) {
                SurfaceControl.nativeClearTransaction(this.mNativeObject);
            }
        }

        private void readFromParcel(Parcel in) {
            throw new IllegalStateException("STUB");
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static final class DisplayPrimaries {
        public CieXyz red;
        public CieXyz green;
        public CieXyz blue;
        public CieXyz white;
    }

    public static final class CieXyz {
        public float X;
        public float Y;
        public float Z;
    }

    public static final class DesiredDisplayModeSpecs {
        public int defaultMode;
        public float primaryRefreshRateMin;
        public float primaryRefreshRateMax;
        public float appRequestRefreshRateMin;
        public float appRequestRefreshRateMax;
        public boolean allowGroupSwitching;

        public DesiredDisplayModeSpecs() {
        }

        public DesiredDisplayModeSpecs(DesiredDisplayModeSpecs other) {
            this.copyFrom(other);
        }

        public DesiredDisplayModeSpecs(int defaultMode, boolean allowGroupSwitching, float primaryRefreshRateMin, float primaryRefreshRateMax, float appRequestRefreshRateMin, float appRequestRefreshRateMax) {
            this.defaultMode = defaultMode;
            this.allowGroupSwitching = allowGroupSwitching;
            this.primaryRefreshRateMin = primaryRefreshRateMin;
            this.primaryRefreshRateMax = primaryRefreshRateMax;
            this.appRequestRefreshRateMin = appRequestRefreshRateMin;
            this.appRequestRefreshRateMax = appRequestRefreshRateMax;
        }

        public boolean equals(Object o) {
            return o instanceof DesiredDisplayModeSpecs && this.equals((DesiredDisplayModeSpecs)o);
        }

        public boolean equals(DesiredDisplayModeSpecs other) {
            return other != null && this.defaultMode == other.defaultMode && this.primaryRefreshRateMin == other.primaryRefreshRateMin && this.primaryRefreshRateMax == other.primaryRefreshRateMax && this.appRequestRefreshRateMin == other.appRequestRefreshRateMin && this.appRequestRefreshRateMax == other.appRequestRefreshRateMax;
        }

        public int hashCode() {
            return 0;
        }

        public void copyFrom(DesiredDisplayModeSpecs other) {
            this.defaultMode = other.defaultMode;
            this.primaryRefreshRateMin = other.primaryRefreshRateMin;
            this.primaryRefreshRateMax = other.primaryRefreshRateMax;
            this.appRequestRefreshRateMin = other.appRequestRefreshRateMin;
            this.appRequestRefreshRateMax = other.appRequestRefreshRateMax;
        }

        public String toString() {
            return String.format("defaultConfig=%d primaryRefreshRateRange=[%.0f %.0f] appRequestRefreshRateRange=[%.0f %.0f]", this.defaultMode, Float.valueOf(this.primaryRefreshRateMin), Float.valueOf(this.primaryRefreshRateMax), Float.valueOf(this.appRequestRefreshRateMin), Float.valueOf(this.appRequestRefreshRateMax));
        }
    }

    public static final class DisplayMode {
        public static final int INVALID_DISPLAY_MODE_ID = -1;
        public int id;
        public int width;
        public int height;
        public float xDpi;
        public float yDpi;
        public float refreshRate;
        public long appVsyncOffsetNanos;
        public long presentationDeadlineNanos;
        public int group;

        public String toString() {
            return "DisplayMode{id=" + this.id + ", width=" + this.width + ", height=" + this.height + ", xDpi=" + this.xDpi + ", yDpi=" + this.yDpi + ", refreshRate=" + this.refreshRate + ", appVsyncOffsetNanos=" + this.appVsyncOffsetNanos + ", presentationDeadlineNanos=" + this.presentationDeadlineNanos + ", group=" + this.group + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisplayMode that = (DisplayMode)o;
            return this.id == that.id && this.width == that.width && this.height == that.height && Float.compare(that.xDpi, this.xDpi) == 0 && Float.compare(that.yDpi, this.yDpi) == 0 && Float.compare(that.refreshRate, this.refreshRate) == 0 && this.appVsyncOffsetNanos == that.appVsyncOffsetNanos && this.presentationDeadlineNanos == that.presentationDeadlineNanos && this.group == that.group;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.width, this.height, Float.valueOf(this.xDpi), Float.valueOf(this.yDpi), Float.valueOf(this.refreshRate), this.appVsyncOffsetNanos, this.presentationDeadlineNanos, this.group);
        }
    }

    public static final class DynamicDisplayInfo {
        public DisplayMode[] supportedDisplayModes;
        public int activeDisplayModeId;
        public int[] supportedColorModes;
        public int activeColorMode;
        public Object hdrCapabilities;
        public boolean autoLowLatencyModeSupported;
        public boolean gameContentTypeSupported;

        public String toString() {
            return "DynamicDisplayInfo{supportedDisplayModes=" + Arrays.toString(this.supportedDisplayModes) + ", activeDisplayModeId=" + this.activeDisplayModeId + ", supportedColorModes=" + Arrays.toString(this.supportedColorModes) + ", activeColorMode=" + this.activeColorMode + ", hdrCapabilities=" + this.hdrCapabilities + ", autoLowLatencyModeSupported=" + this.autoLowLatencyModeSupported + ", gameContentTypeSupported" + this.gameContentTypeSupported + "}";
        }

        public boolean equals(Object o) {
            throw new IllegalStateException("STUB");
        }

        public int hashCode() {
            return Objects.hash(this.supportedDisplayModes, this.activeDisplayModeId, this.activeDisplayModeId, this.activeColorMode, this.hdrCapabilities);
        }
    }

    public static final class StaticDisplayInfo {
        public boolean isInternal;
        public float density;
        public boolean secure;

        public String toString() {
            throw new IllegalStateException("STUB");
        }

        public boolean equals(Object o) {
            throw new IllegalStateException("STUB");
        }

        public int hashCode() {
            throw new IllegalStateException("STUB");
        }
    }

    public static class Builder {
        private SurfaceSession mSession;
        private int mFlags = 4;
        private int mWidth;
        private int mHeight;
        private int mFormat = -1;
        private String mName;
        private WeakReference<View> mLocalOwnerView;
        private SurfaceControl mParent;
        private SparseIntArray mMetadata;
        private String mCallsite = "SurfaceControl.Builder";

        public Builder(SurfaceSession session) {
            this.mSession = session;
        }

        public Builder() {
        }

        public SurfaceControl build() {
            throw new IllegalStateException("STUB");
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setLocalOwnerView(View view) {
            this.mLocalOwnerView = new WeakReference<View>(view);
            return this;
        }

        public Builder setBufferSize(int width, int height) {
            if (width < 0 || height < 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            this.mWidth = width;
            this.mHeight = height;
            return this.setFlags(0, 983040);
        }

        private void unsetBufferSize() {
            this.mWidth = 0;
            this.mHeight = 0;
        }

        public Builder setFormat(int format) {
            this.mFormat = format;
            return this;
        }

        public Builder setProtected(boolean protectedContent) {
            this.mFlags = protectedContent ? (this.mFlags |= 0x800) : (this.mFlags &= 0xFFFFF7FF);
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.mFlags = secure ? (this.mFlags |= 0x80) : (this.mFlags &= 0xFFFFFF7F);
            return this;
        }

        public Builder setOpaque(boolean opaque) {
            this.mFlags = opaque ? (this.mFlags |= 0x400) : (this.mFlags &= 0xFFFFFBFF);
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.mFlags = hidden ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
            return this;
        }

        public Builder setParent(SurfaceControl parent) {
            this.mParent = parent;
            return this;
        }

        public Builder setMetadata(int key, int data) {
            if (this.mMetadata == null) {
                this.mMetadata = new SparseIntArray();
            }
            this.mMetadata.put(key, data);
            return this;
        }

        public Builder setEffectLayer() {
            this.mFlags |= 0x4000;
            this.unsetBufferSize();
            return this.setFlags(131072, 983040);
        }

        public Builder setColorLayer() {
            this.unsetBufferSize();
            return this.setFlags(131072, 983040);
        }

        private boolean isEffectLayer() {
            return (this.mFlags & 0x20000) == 131072;
        }

        public Builder setBLASTLayer() {
            return this.setFlags(262144, 983040);
        }

        public Builder setContainerLayer() {
            this.unsetBufferSize();
            return this.setFlags(524288, 983040);
        }

        private boolean isContainerLayer() {
            return (this.mFlags & 0x80000) == 524288;
        }

        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        public Builder setCallsite(String callsite) {
            this.mCallsite = callsite;
            return this;
        }

        private Builder setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~mask | flags;
            return this;
        }
    }

    public static class LayerCaptureArgs
    extends CaptureArgs {
        private final long mNativeLayer;
        private final long[] mNativeExcludeLayers;
        private final boolean mChildrenOnly;

        private LayerCaptureArgs(Builder builder) {
            super(builder);
            this.mChildrenOnly = builder.mChildrenOnly;
            this.mNativeLayer = ((Builder)builder).mLayer.mNativeObject;
            if (builder.mExcludeLayers != null) {
                this.mNativeExcludeLayers = new long[builder.mExcludeLayers.length];
                for (int i = 0; i < builder.mExcludeLayers.length; ++i) {
                    this.mNativeExcludeLayers[i] = ((Builder)builder).mExcludeLayers[i].mNativeObject;
                }
            } else {
                this.mNativeExcludeLayers = null;
            }
        }

        public static class Builder
        extends CaptureArgs.Builder<Builder> {
            private SurfaceControl mLayer;
            private SurfaceControl[] mExcludeLayers;
            private boolean mChildrenOnly = true;

            public LayerCaptureArgs build() {
                if (this.mLayer == null) {
                    throw new IllegalStateException("Can't take screenshot with null layer");
                }
                return new LayerCaptureArgs(this);
            }

            public Builder(SurfaceControl layer) {
                this.setLayer(layer);
            }

            public Builder setLayer(SurfaceControl layer) {
                this.mLayer = layer;
                return this;
            }

            public Builder setExcludeLayers(SurfaceControl[] excludeLayers) {
                this.mExcludeLayers = excludeLayers;
                return this;
            }

            public Builder setChildrenOnly(boolean childrenOnly) {
                this.mChildrenOnly = childrenOnly;
                return this;
            }

            @Override
            Builder getThis() {
                return this;
            }
        }
    }

    public static class DisplayCaptureArgs
    extends CaptureArgs {
        private final IBinder mDisplayToken;
        private final int mWidth;
        private final int mHeight;
        private final boolean mUseIdentityTransform;

        private DisplayCaptureArgs(Builder builder) {
            super(builder);
            this.mDisplayToken = builder.mDisplayToken;
            this.mWidth = builder.mWidth;
            this.mHeight = builder.mHeight;
            this.mUseIdentityTransform = builder.mUseIdentityTransform;
        }

        public static class Builder
        extends CaptureArgs.Builder<Builder> {
            private IBinder mDisplayToken;
            private int mWidth;
            private int mHeight;
            private boolean mUseIdentityTransform;

            public DisplayCaptureArgs build() {
                if (this.mDisplayToken == null) {
                    throw new IllegalStateException("Can't take screenshot with null display token");
                }
                return new DisplayCaptureArgs(this);
            }

            public Builder(IBinder displayToken) {
                this.setDisplayToken(displayToken);
            }

            public Builder setDisplayToken(IBinder displayToken) {
                this.mDisplayToken = displayToken;
                return this;
            }

            public Builder setSize(int width, int height) {
                this.mWidth = width;
                this.mHeight = height;
                return this;
            }

            public Builder setUseIdentityTransform(boolean useIdentityTransform) {
                this.mUseIdentityTransform = useIdentityTransform;
                return this;
            }

            @Override
            Builder getThis() {
                return this;
            }
        }
    }

    private static abstract class CaptureArgs {
        private final int mPixelFormat;
        private final Rect mSourceCrop = new Rect();
        private final float mFrameScaleX;
        private final float mFrameScaleY;
        private final boolean mCaptureSecureLayers;
        private final boolean mAllowProtected;
        private final long mUid;
        private final boolean mGrayscale;

        private CaptureArgs(Builder<? extends Builder<?>> builder) {
            this.mPixelFormat = ((Builder)builder).mPixelFormat;
            this.mSourceCrop.set(((Builder)builder).mSourceCrop);
            this.mFrameScaleX = ((Builder)builder).mFrameScaleX;
            this.mFrameScaleY = ((Builder)builder).mFrameScaleY;
            this.mCaptureSecureLayers = ((Builder)builder).mCaptureSecureLayers;
            this.mAllowProtected = ((Builder)builder).mAllowProtected;
            this.mUid = ((Builder)builder).mUid;
            this.mGrayscale = ((Builder)builder).mGrayscale;
        }

        static abstract class Builder<T extends Builder<T>> {
            private int mPixelFormat = 1;
            private final Rect mSourceCrop = new Rect();
            private float mFrameScaleX = 1.0f;
            private float mFrameScaleY = 1.0f;
            private boolean mCaptureSecureLayers;
            private boolean mAllowProtected;
            private long mUid = -1L;
            private boolean mGrayscale;

            Builder() {
            }

            public T setPixelFormat(int pixelFormat) {
                this.mPixelFormat = pixelFormat;
                return this.getThis();
            }

            public T setSourceCrop(Rect sourceCrop) {
                this.mSourceCrop.set(sourceCrop);
                return this.getThis();
            }

            public T setFrameScale(float frameScale) {
                this.mFrameScaleX = frameScale;
                this.mFrameScaleY = frameScale;
                return this.getThis();
            }

            public T setFrameScale(float frameScaleX, float frameScaleY) {
                this.mFrameScaleX = frameScaleX;
                this.mFrameScaleY = frameScaleY;
                return this.getThis();
            }

            public T setCaptureSecureLayers(boolean captureSecureLayers) {
                this.mCaptureSecureLayers = captureSecureLayers;
                return this.getThis();
            }

            public T setAllowProtected(boolean allowProtected) {
                this.mAllowProtected = allowProtected;
                return this.getThis();
            }

            public T setUid(long uid) {
                this.mUid = uid;
                return this.getThis();
            }

            public T setGrayscale(boolean grayscale) {
                this.mGrayscale = grayscale;
                return this.getThis();
            }

            abstract T getThis();
        }
    }

    private static class SyncScreenCaptureListener
    implements ScreenCaptureListener {
        private static final int SCREENSHOT_WAIT_TIME_S = 1;
        private ScreenshotHardwareBuffer mScreenshotHardwareBuffer;
        private final CountDownLatch mCountDownLatch = new CountDownLatch(1);

        private SyncScreenCaptureListener() {
        }

        @Override
        public void onScreenCaptureComplete(ScreenshotHardwareBuffer hardwareBuffer) {
            this.mScreenshotHardwareBuffer = hardwareBuffer;
            this.mCountDownLatch.countDown();
        }

        private ScreenshotHardwareBuffer waitForScreenshot() {
            try {
                this.mCountDownLatch.await(1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Log.e(SurfaceControl.TAG, "Failed to wait for screen capture result", e);
            }
            return this.mScreenshotHardwareBuffer;
        }
    }

    public static interface ScreenCaptureListener {
        public void onScreenCaptureComplete(ScreenshotHardwareBuffer var1);
    }

    public static class ScreenshotHardwareBuffer {
        private final boolean mContainsSecureLayers;

        public ScreenshotHardwareBuffer(Object hardwareBuffer, Object colorSpace, boolean containsSecureLayers) {
            this.mContainsSecureLayers = containsSecureLayers;
        }

        private static ScreenshotHardwareBuffer createFromNative(Object hardwareBuffer, int namedColorSpace, boolean containsSecureLayers) {
            throw new IllegalStateException("STUB");
        }

        public Object getColorSpace() {
            throw new IllegalStateException("STUB");
        }

        public Object getHardwareBuffer() {
            throw new IllegalStateException("STUB");
        }

        public boolean containsSecureLayers() {
            return this.mContainsSecureLayers;
        }

        public Bitmap asBitmap() {
            throw new IllegalStateException("STUB");
        }
    }

    public static class JankData {
        public static final int JANK_NONE = 0;
        public static final int DISPLAY_HAL = 1;
        public static final int JANK_SURFACEFLINGER_DEADLINE_MISSED = 2;
        public static final int JANK_SURFACEFLINGER_GPU_DEADLINE_MISSED = 4;
        public static final int JANK_APP_DEADLINE_MISSED = 8;
        public static final int PREDICTION_ERROR = 16;
        public static final int SURFACE_FLINGER_SCHEDULING = 32;
        public static final int BUFFER_STUFFING = 64;
        public static final int UNKNOWN = 128;
        public final long frameVsyncId;
        public final int jankType;

        public JankData(long frameVsyncId, int jankType) {
            this.frameVsyncId = frameVsyncId;
            this.jankType = jankType;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface JankType {
        }
    }

    public static interface OnReparentListener {
        public void onReparent(Transaction var1, SurfaceControl var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BufferTransform {
    }
}

