/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import dalvik.system.DexPathList;
import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;

public class BaseDexClassLoader
extends ClassLoader {
    private static volatile Reporter reporter = null;
    private final DexPathList pathList;
    protected final ClassLoader[] sharedLibraryLoaders;

    public BaseDexClassLoader(String dexPath, File optimizedDirectory, String librarySearchPath, ClassLoader parent) {
        this(dexPath, librarySearchPath, parent, null, false);
    }

    public BaseDexClassLoader(String dexPath, File optimizedDirectory, String librarySearchPath, ClassLoader parent, boolean isTrusted) {
        this(dexPath, librarySearchPath, parent, null, isTrusted);
    }

    public BaseDexClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, ClassLoader[] libraries) {
        this(dexPath, librarySearchPath, parent, libraries, false);
    }

    public BaseDexClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, ClassLoader[] sharedLibraryLoaders, boolean isTrusted) {
        super(parent);
        this.sharedLibraryLoaders = sharedLibraryLoaders == null ? null : Arrays.copyOf(sharedLibraryLoaders, sharedLibraryLoaders.length);
        this.pathList = new DexPathList(this, dexPath, librarySearchPath, null, isTrusted);
        if (reporter != null) {
            this.reportClassLoaderChain();
        }
    }

    private void reportClassLoaderChain() {
        throw new UnsupportedOperationException("STUB");
    }

    public BaseDexClassLoader(ByteBuffer[] dexFiles, String librarySearchPath, ClassLoader parent) {
        super(parent);
        this.pathList = new DexPathList(this, dexFiles, librarySearchPath);
        this.sharedLibraryLoaders = null;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ArrayList<Throwable> suppressedExceptions;
        Class<?> c;
        if (this.sharedLibraryLoaders != null) {
            for (ClassLoader loader : this.sharedLibraryLoaders) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        if ((c = this.pathList.findClass(name, suppressedExceptions = new ArrayList<Throwable>())) == null) {
            ClassNotFoundException cnfe = new ClassNotFoundException("Didn't find class \"" + name + "\" on path: " + this.pathList);
            for (Throwable t : suppressedExceptions) {
                cnfe.addSuppressed(t);
            }
            throw cnfe;
        }
        return c;
    }

    public void addDexPath(String dexPath) {
        this.addDexPath(dexPath, false);
    }

    public void addDexPath(String dexPath, boolean isTrusted) {
        this.pathList.addDexPath(dexPath, null, isTrusted);
    }

    public void addNativePath(Collection<String> libPaths) {
        this.pathList.addNativePath(libPaths);
    }

    @Override
    protected URL findResource(String name) {
        if (this.sharedLibraryLoaders != null) {
            for (ClassLoader loader : this.sharedLibraryLoaders) {
                URL url = loader.getResource(name);
                if (url == null) continue;
                return url;
            }
        }
        return this.pathList.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        throw new UnsupportedOperationException("STUB");
    }

    @Override
    public String findLibrary(String name) {
        return this.pathList.findLibrary(name);
    }

    @Override
    protected synchronized Package getPackage(String name) {
        if (name != null && !name.isEmpty()) {
            Package pack = super.getPackage(name);
            if (pack == null) {
                pack = this.definePackage(name, "Unknown", "0.0", "Unknown", "Unknown", "0.0", "Unknown", null);
            }
            return pack;
        }
        return null;
    }

    public String getLdLibraryPath() {
        StringBuilder result = new StringBuilder();
        for (File directory : this.pathList.getNativeLibraryDirectories()) {
            if (result.length() > 0) {
                result.append(':');
            }
            result.append(directory);
        }
        return result.toString();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.pathList + "]";
    }

    public static void setReporter(Reporter newReporter) {
        reporter = newReporter;
    }

    public static Reporter getReporter() {
        return reporter;
    }

    public BaseDexClassLoader(ByteBuffer[] dexFiles, ClassLoader parent) {
        throw new RuntimeException("Stub!");
    }

    public static interface Reporter {
        public void report(List<ClassLoader> var1, List<String> var2);
    }
}

