package com.virjar.vtoolkit;

import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * 统一的app应用管理机制，开发环境使用配置文件加载，生产环境会经过asm处理，
 * 直接将这些配置打成常量
 */
@Slf4j
public class YIntApp {

    /**
     * 当前所属项目
     */
    public static String project = "yint-unknown";

    /**
     * will be git commit id
     */
    public static String gitId = "00000000000000000";

    /**
     * 数字型号的版本号
     */
    public static long versionCode = -1;

    /**
     * 字符串形式的版本
     */
    public static String versionName = "unknown";

    /**
     * 发布时间 yyyy-MM-dd HH:mm:ss
     */
    public static String releaseDate = "1970-00-00 00:00:00";

    public static String releaseAuthor = "virjar";

    public static boolean isLocalDebug = false;


    /**
     * 将会在插桩方法中调用load，所以这里需要是public
     */
    public static void load(InputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        Properties properties = new Properties();
        properties.load(stream);
        gitId = properties.getProperty("yint.gitId");
        versionCode = toLong(properties.getProperty("yint.versionCode"), -1);
        versionName = properties.getProperty("yint.versionName", "unknown");
        releaseDate = properties.getProperty("yint.releaseDate", "1970-00-00 00:00:00");
        releaseAuthor = properties.getProperty("yint.releaseAuthor", "virjar");
        isLocalDebug = isTrue(Boolean.valueOf(properties.getProperty("yint.localDebug", "false")));
    }

    public static boolean isTrue(final Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static long toLong(final String str, final long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        } catch (final NumberFormatException nfe) {
            return defaultValue;
        }
    }

    static {
        try {
            load(YIntApp.class.getClassLoader().getResourceAsStream("application.properties"));
        } catch (Exception e) {
            log.error("load App version info failed", e);
        }
    }
}
