/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class Inspector {
    private static final Map<String, Collector> allCollectors = new ConcurrentHashMap<String, Collector>();

    public static void addCollector(String topic, Collector collector) {
        allCollectors.put(topic, collector);
    }

    public static void removeCollector(String topic) {
        allCollectors.remove(topic);
    }

    public static JSONObject inspect() {
        CountDownLatch countDownLatch = new CountDownLatch(allCollectors.size());
        ArrayList<Callback> callbacks = new ArrayList<Callback>(allCollectors.size());
        for (Map.Entry<String, Collector> entry : allCollectors.entrySet()) {
            Callback callback = new Callback(entry.getKey(), countDownLatch);
            callbacks.add(callback);
            entry.getValue().collect(callback);
        }
        try {
            countDownLatch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        JSONObject jsonObject = new JSONObject(new TreeMap());
        for (Callback callback : callbacks) {
            Object value = callback.value;
            if (value == null) {
                value = "inspect failed!!";
            }
            jsonObject.put(callback.key, value);
        }
        return jsonObject;
    }

    public static abstract class Joiner {
        private final Map<String, Collector> map = new ConcurrentHashMap<String, Collector>();
        private final JSONObject joinerData = new JSONObject();

        public Joiner add(String topic, Collector collector) {
            this.map.put(topic, collector);
            return this;
        }

        public void doJoin() {
            this.doJoin(this.map.entrySet().iterator());
        }

        private void doJoin(final Iterator<Map.Entry<String, Collector>> iterator) {
            if (!iterator.hasNext()) {
                this.onFinish(this.joinerData);
                return;
            }
            Map.Entry<String, Collector> entry = iterator.next();
            final String topic = entry.getKey();
            entry.getValue().collect(new Callback(topic, null){

                @Override
                public void onData(Object data) {
                    joinerData.put(topic, data);
                    this.doJoin(iterator);
                }
            });
        }

        public abstract void onFinish(JSONObject var1);
    }

    public static class Callback {
        private final String key;
        private final CountDownLatch countDownLatch;
        private Object value;

        Callback(String key, CountDownLatch countDownLatch) {
            this.key = key;
            this.countDownLatch = countDownLatch;
        }

        public void onData(Object data) {
            this.value = data;
            this.countDownLatch.countDown();
        }
    }

    public static interface Collector {
        public void collect(Callback var1);
    }
}

