/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class Md5Util {
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String md5(String input) {
        return Md5Util.getHashWithInputStream(new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8)));
    }

    public static String getHashWithInputStream(InputStream inputStream) {
        try {
            int numRead;
            byte[] buffer = new byte[1000];
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            while ((numRead = inputStream.read(buffer)) > 0) {
                md5.update(buffer, 0, numRead);
            }
            inputStream.close();
            return Md5Util.toHexString(md5.digest());
        }
        catch (Exception var4) {
            throw new IllegalStateException(var4);
        }
    }

    public static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (byte b1 : b) {
            sb.append(hexChar[(b1 & 0xF0) >>> 4]);
            sb.append(hexChar[b1 & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] hexToByteArray(String inHex) {
        byte[] result;
        int hexlen = inHex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = Md5Util.hexToByte(inHex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }
}

