/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ReflectUtil {
    private static final HashMap<String, Field> fieldCache = new HashMap();
    private static final HashMap<String, Method> methodCache = new HashMap();
    private static final HashMap<String, Constructor<?>> constructorCache = new HashMap();
    private static final Map<String, Class<?>> namePrimitiveMap = new HashMap();
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap;
    private static final Map<String, String> abbreviationMap;
    private static final Map<String, String> reverseAbbreviationMap;
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final Class<?>[] EMPTY_CLASS_ARRAY;
    private static final int ACCESS_TEST = 7;
    private static final Class<?>[] ORDERED_PRIMITIVE_TYPES;

    private static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
    }

    private static Field getDeclaredField(Object object, String filedName) {
        return ReflectUtil.findField(object.getClass(), filedName);
    }

    public static boolean getBooleanField(Object obj, String fieldName) {
        try {
            return ReflectUtil.findField(obj.getClass(), fieldName).getBoolean(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static byte getByteField(Object obj, String fieldName) {
        try {
            return ReflectUtil.findField(obj.getClass(), fieldName).getByte(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static char getCharField(Object obj, String fieldName) {
        try {
            return ReflectUtil.findField(obj.getClass(), fieldName).getChar(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static double getDoubleField(Object obj, String fieldName) {
        try {
            return ReflectUtil.findField(obj.getClass(), fieldName).getDouble(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static float getFloatField(Object obj, String fieldName) {
        try {
            return ReflectUtil.findField(obj.getClass(), fieldName).getFloat(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static int getIntField(Object obj, String fieldName) {
        try {
            return ReflectUtil.findField(obj.getClass(), fieldName).getInt(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static long getLongField(Object obj, String fieldName) {
        try {
            return ReflectUtil.findField(obj.getClass(), fieldName).getLong(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static short getShortField(Object obj, String fieldName) {
        try {
            return ReflectUtil.findField(obj.getClass(), fieldName).getShort(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        try {
            ReflectUtil.findField(object.getClass(), fieldName).set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T getFieldValue(Object object, String fieldName) {
        try {
            return (T)ReflectUtil.findField(object.getClass(), fieldName).get(object);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T getStaticFiled(Class<?> clazz, String filedName) {
        try {
            return (T)ReflectUtil.findField(clazz, filedName).get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object callMethod(Object obj, String methodName, Object ... args) {
        try {
            return ReflectUtil.findMethodBestMatch(obj.getClass(), methodName, args).invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public static Object callMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            return ReflectUtil.findMethodBestMatch(obj.getClass(), methodName, parameterTypes, args).invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public static Object callStaticMethod(Class<?> clazz, String methodName, Object ... args) {
        try {
            return ReflectUtil.findMethodBestMatch(clazz, methodName, args).invoke(null, args);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public static Object callStaticMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            return ReflectUtil.findMethodBestMatch(clazz, methodName, parameterTypes, args).invoke(null, args);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public static Method findMethodExact(Class<?> clazz, String methodName, Object ... parameterTypes) {
        return ReflectUtil.findMethodExact(clazz, methodName, ReflectUtil.getParameterClasses(clazz.getClassLoader(), parameterTypes));
    }

    public static Method findMethodExactIfExists(Class<?> clazz, String methodName, Object ... parameterTypes) {
        try {
            return ReflectUtil.findMethodExact(clazz, methodName, parameterTypes);
        }
        catch (IllegalStateException | NoSuchMethodError e) {
            return null;
        }
    }

    public static Method findMethodExact(String className, ClassLoader classLoader, String methodName, Object ... parameterTypes) {
        return ReflectUtil.findMethodExact(ReflectUtil.findClass(className, classLoader), methodName, ReflectUtil.getParameterClasses(classLoader, parameterTypes));
    }

    public static Method findMethodExactIfExists(String className, ClassLoader classLoader, String methodName, Object ... parameterTypes) {
        try {
            return ReflectUtil.findMethodExact(className, classLoader, methodName, parameterTypes);
        }
        catch (IllegalStateException | NoSuchMethodError e) {
            return null;
        }
    }

    public static Method findMethodExact(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        String fullMethodName = clazz.getName() + '#' + methodName + ReflectUtil.getParametersString(parameterTypes) + "#exact";
        if (methodCache.containsKey(fullMethodName)) {
            Method method = methodCache.get(fullMethodName);
            if (method == null) {
                throw new NoSuchMethodError(fullMethodName);
            }
            return method;
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            methodCache.put(fullMethodName, method);
            return method;
        }
        catch (NoSuchMethodException e) {
            methodCache.put(fullMethodName, null);
            throw new NoSuchMethodError(fullMethodName);
        }
    }

    public static Method[] findMethodsByExactParameters(Class<?> clazz, Class<?> returnType, Class<?> ... parameterTypes) {
        LinkedList<Method> result = new LinkedList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            Class<?>[] methodParameterTypes;
            if (returnType != null && returnType != method.getReturnType() || parameterTypes.length != (methodParameterTypes = method.getParameterTypes()).length) continue;
            boolean match = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i] == methodParameterTypes[i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            method.setAccessible(true);
            result.add(method);
        }
        return result.toArray(new Method[result.size()]);
    }

    public static Method findMethodBestMatch(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        String fullMethodName = clazz.getName() + '#' + methodName + ReflectUtil.getParametersString(parameterTypes) + "#bestmatch";
        if (methodCache.containsKey(fullMethodName)) {
            Method method = methodCache.get(fullMethodName);
            if (method == null) {
                throw new NoSuchMethodError(fullMethodName);
            }
            return method;
        }
        try {
            Method method = ReflectUtil.findMethodExact(clazz, methodName, parameterTypes);
            methodCache.put(fullMethodName, method);
            return method;
        }
        catch (NoSuchMethodError method) {
            Method bestMatch = null;
            Class<?> clz = clazz;
            boolean considerPrivateMethods = true;
            do {
                for (Method method2 : clz.getDeclaredMethods()) {
                    if (!considerPrivateMethods && Modifier.isPrivate(method2.getModifiers()) || !method2.getName().equals(methodName) || !ReflectUtil.isAssignable(parameterTypes, method2.getParameterTypes(), true) || bestMatch != null && ReflectUtil.compareParameterTypes(method2.getParameterTypes(), bestMatch.getParameterTypes(), parameterTypes) >= 0) continue;
                    bestMatch = method2;
                }
                considerPrivateMethods = false;
            } while ((clz = clz.getSuperclass()) != null);
            if (bestMatch != null) {
                bestMatch.setAccessible(true);
                methodCache.put(fullMethodName, bestMatch);
                return bestMatch;
            }
            NoSuchMethodError e = new NoSuchMethodError(fullMethodName);
            methodCache.put(fullMethodName, null);
            throw e;
        }
    }

    public static Method findMethodBestMatch(Class<?> clazz, String methodName, Object ... args) {
        return ReflectUtil.findMethodBestMatch(clazz, methodName, ReflectUtil.getParameterTypes(args));
    }

    public static Method findMethodBestMatch(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Class<?>[] argsClasses = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] != null) continue;
            if (argsClasses == null) {
                argsClasses = ReflectUtil.getParameterTypes(args);
            }
            parameterTypes[i] = argsClasses[i];
        }
        return ReflectUtil.findMethodBestMatch(clazz, methodName, parameterTypes);
    }

    public static Class<?>[] getParameterTypes(Object ... args) {
        Class[] clazzes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            clazzes[i] = args[i] != null ? args[i].getClass() : null;
        }
        return clazzes;
    }

    private static Class<?>[] getParameterClasses(ClassLoader classLoader, Object[] parameterTypesAndCallback) {
        Class[] parameterClasses = null;
        for (int i = parameterTypesAndCallback.length - 1; i >= 0; --i) {
            Object type = parameterTypesAndCallback[i];
            if (type == null) {
                throw new IllegalStateException("parameter type must not be null", null);
            }
            if (parameterClasses == null) {
                parameterClasses = new Class[i + 1];
            }
            if (type instanceof Class) {
                parameterClasses[i] = (Class)type;
                continue;
            }
            if (type instanceof String) {
                parameterClasses[i] = ReflectUtil.findClass((String)type, classLoader);
                continue;
            }
            throw new IllegalStateException("parameter type must either be specified as Class or String", null);
        }
        if (parameterClasses == null) {
            parameterClasses = new Class[]{};
        }
        return parameterClasses;
    }

    public static Class<?>[] getClassesAsArray(Class<?> ... clazzes) {
        return clazzes;
    }

    private static String getParametersString(Class<?> ... clazzes) {
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (Class<?> clazz : clazzes) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (clazz != null) {
                sb.append(clazz.getCanonicalName());
                continue;
            }
            sb.append("null");
        }
        sb.append(")");
        return sb.toString();
    }

    public static Constructor<?> findConstructorExact(Class<?> clazz, Object ... parameterTypes) {
        return ReflectUtil.findConstructorExact(clazz, ReflectUtil.getParameterClasses(clazz.getClassLoader(), parameterTypes));
    }

    public static Constructor<?> findConstructorExactIfExists(Class<?> clazz, Object ... parameterTypes) {
        try {
            return ReflectUtil.findConstructorExact(clazz, parameterTypes);
        }
        catch (IllegalStateException | NoSuchMethodError e) {
            return null;
        }
    }

    public static Constructor<?> findConstructorExact(String className, ClassLoader classLoader, Object ... parameterTypes) {
        return ReflectUtil.findConstructorExact(ReflectUtil.findClass(className, classLoader), ReflectUtil.getParameterClasses(classLoader, parameterTypes));
    }

    public static Constructor<?> findConstructorExactIfExists(String className, ClassLoader classLoader, Object ... parameterTypes) {
        try {
            return ReflectUtil.findConstructorExact(className, classLoader, parameterTypes);
        }
        catch (IllegalStateException | NoSuchMethodError e) {
            return null;
        }
    }

    public static Constructor<?> findConstructorExact(Class<?> clazz, Class<?> ... parameterTypes) {
        String fullConstructorName = clazz.getName() + ReflectUtil.getParametersString(parameterTypes) + "#exact";
        if (constructorCache.containsKey(fullConstructorName)) {
            Constructor<?> constructor = constructorCache.get(fullConstructorName);
            if (constructor == null) {
                throw new NoSuchMethodError(fullConstructorName);
            }
            return constructor;
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            constructorCache.put(fullConstructorName, constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            constructorCache.put(fullConstructorName, null);
            throw new NoSuchMethodError(fullConstructorName);
        }
    }

    public static Class<?> findClass(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ReflectUtil.class.getClassLoader();
        }
        try {
            return ReflectUtil.getClass(classLoader, className, false);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Class<?> findClassIfExists(String className, ClassLoader classLoader) {
        try {
            return ReflectUtil.findClass(className, classLoader);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        String fullFieldName = clazz.getName() + '#' + fieldName;
        if (fieldCache.containsKey(fullFieldName)) {
            Field field = fieldCache.get(fullFieldName);
            if (field == null) {
                throw new NoSuchFieldError(fullFieldName);
            }
            return field;
        }
        try {
            Field field = ReflectUtil.findFieldRecursiveImpl(clazz, fieldName);
            field.setAccessible(true);
            fieldCache.put(fullFieldName, field);
            return field;
        }
        catch (NoSuchFieldException e) {
            fieldCache.put(fullFieldName, null);
            throw new NoSuchFieldError(fullFieldName);
        }
    }

    public static Field findFieldIfExists(Class<?> clazz, String fieldName) {
        try {
            return ReflectUtil.findField(clazz, fieldName);
        }
        catch (NoSuchFieldError e) {
            return null;
        }
    }

    private static Field findFieldRecursiveImpl(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            while ((clazz = clazz.getSuperclass()) != null && !clazz.equals(Object.class)) {
                try {
                    return clazz.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            throw e;
        }
    }

    public static Field findFirstFieldByExactType(Class<?> clazz, Class<?> type) {
        Class<?> clz = clazz;
        do {
            for (Field field : clz.getDeclaredFields()) {
                if (field.getType() != type) continue;
                field.setAccessible(true);
                return field;
            }
        } while ((clz = clz.getSuperclass()) != null);
        throw new NoSuchFieldError("Field of type " + type.getName() + " in class " + clazz.getName());
    }

    private static String toCanonicalName(String className) {
        if ((className = ReflectUtil.deleteWhitespace(className)) == null) {
            throw new IllegalArgumentException("className must not be null.");
        }
        if (className.endsWith("[]")) {
            StringBuilder classNameBuffer = new StringBuilder();
            while (className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
                classNameBuffer.append("[");
            }
            String abbreviation = abbreviationMap.get(className);
            if (abbreviation != null) {
                classNameBuffer.append(abbreviation);
            } else {
                classNameBuffer.append("L").append(className).append(";");
            }
            className = classNameBuffer.toString();
        }
        return className;
    }

    public static String deleteWhitespace(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static Class<?> getClass(ClassLoader classLoader, String className, boolean initialize) throws ClassNotFoundException {
        try {
            Class<?> clazz = namePrimitiveMap.containsKey(className) ? namePrimitiveMap.get(className) : Class.forName(ReflectUtil.toCanonicalName(className), initialize, classLoader);
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                try {
                    return ReflectUtil.getClass(classLoader, className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1), initialize);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static boolean isSameLength(Object[] array1, Object[] array2) {
        return ReflectUtil.getLength(array1) == ReflectUtil.getLength(array2);
    }

    public static int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray, boolean autoboxing) {
        if (!ReflectUtil.isSameLength(classArray, toClassArray)) {
            return false;
        }
        if (classArray == null) {
            classArray = EMPTY_CLASS_ARRAY;
        }
        if (toClassArray == null) {
            toClassArray = EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (ReflectUtil.isAssignable(classArray[i], toClassArray[i], autoboxing)) continue;
            return false;
        }
        return true;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass, boolean autoboxing) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (autoboxing) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = ReflectUtil.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = ReflectUtil.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static int compareParameterTypes(Class<?>[] left, Class<?>[] right, Class<?>[] actual) {
        float rightCost;
        float leftCost = ReflectUtil.getTotalTransformationCost(actual, left);
        return leftCost < (rightCost = ReflectUtil.getTotalTransformationCost(actual, right)) ? -1 : (rightCost < leftCost ? 1 : 0);
    }

    private static float getTotalTransformationCost(Class<?>[] srcArgs, Class<?>[] destArgs) {
        float totalCost = 0.0f;
        for (int i = 0; i < srcArgs.length; ++i) {
            Class<?> srcClass = srcArgs[i];
            Class<?> destClass = destArgs[i];
            totalCost += ReflectUtil.getObjectTransformationCost(srcClass, destClass);
        }
        return totalCost;
    }

    private static float getObjectTransformationCost(Class<?> srcClass, Class<?> destClass) {
        if (destClass.isPrimitive()) {
            return ReflectUtil.getPrimitivePromotionCost(srcClass, destClass);
        }
        float cost = 0.0f;
        while (srcClass != null && !destClass.equals(srcClass)) {
            if (destClass.isInterface() && ReflectUtil.isAssignable(srcClass, destClass, true)) {
                cost += 0.25f;
                break;
            }
            cost += 1.0f;
            srcClass = srcClass.getSuperclass();
        }
        if (srcClass == null) {
            cost += 1.5f;
        }
        return cost;
    }

    private static float getPrimitivePromotionCost(Class<?> srcClass, Class<?> destClass) {
        float cost = 0.0f;
        Class<?> cls = srcClass;
        if (!cls.isPrimitive()) {
            cost += 0.1f;
            cls = ReflectUtil.wrapperToPrimitive(cls);
        }
        for (int i = 0; cls != destClass && i < ORDERED_PRIMITIVE_TYPES.length; ++i) {
            if (cls != ORDERED_PRIMITIVE_TYPES[i]) continue;
            cost += 0.1f;
            if (i >= ORDERED_PRIMITIVE_TYPES.length - 1) continue;
            cls = ORDERED_PRIMITIVE_TYPES[i + 1];
        }
        return cost;
    }

    static {
        namePrimitiveMap.put("boolean", Boolean.TYPE);
        namePrimitiveMap.put("byte", Byte.TYPE);
        namePrimitiveMap.put("char", Character.TYPE);
        namePrimitiveMap.put("short", Short.TYPE);
        namePrimitiveMap.put("int", Integer.TYPE);
        namePrimitiveMap.put("long", Long.TYPE);
        namePrimitiveMap.put("double", Double.TYPE);
        namePrimitiveMap.put("float", Float.TYPE);
        namePrimitiveMap.put("void", Void.TYPE);
        primitiveWrapperMap = new HashMap();
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        primitiveWrapperMap.put(Void.TYPE, Void.TYPE);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("int", "I");
        m.put("boolean", "Z");
        m.put("float", "F");
        m.put("long", "J");
        m.put("short", "S");
        m.put("byte", "B");
        m.put("double", "D");
        m.put("char", "C");
        HashMap r = new HashMap();
        for (Map.Entry e : m.entrySet()) {
            r.put(e.getValue(), e.getKey());
        }
        abbreviationMap = Collections.unmodifiableMap(m);
        reverseAbbreviationMap = Collections.unmodifiableMap(r);
        wrapperPrimitiveMap = new HashMap();
        for (Map.Entry<Class<?>, Class<?>> entry : primitiveWrapperMap.entrySet()) {
            Class<?> wrapperClass;
            Class<?> primitiveClass = entry.getKey();
            if (primitiveClass.equals(wrapperClass = entry.getValue())) continue;
            wrapperPrimitiveMap.put(wrapperClass, primitiveClass);
        }
        EMPTY_CLASS_ARRAY = new Class[0];
        ORDERED_PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    }
}

