/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpInvoker {
    private static final Logger log = LoggerFactory.getLogger(SimpleHttpInvoker.class);
    private static final ThreadLocal<LinkedHashMap<String, String>> threadLocalRequestHeader = new ThreadLocal();
    private static final ThreadLocal<String> threadLocalProxy = new ThreadLocal();
    private static final ThreadLocal<AuthHolder> threadLocalProxyAuth = new ThreadLocal();
    private static final ThreadLocal<DefaultHttpPropertyBuilder> threadLocalDefaultHttpProperty = new ThreadLocal();
    private static final ThreadLocal<Integer> threadLocalConnectionTimeout = new ThreadLocal();
    private static final ThreadLocal<Integer> threadLocalReadTimeout = new ThreadLocal();
    private static final ThreadLocal<Integer> threadLocalResponseStatus = new ThreadLocal();
    private static final ThreadLocal<LinkedHashMap<String, String>> threadLocalResponseHeader = new ThreadLocal();
    private static final ThreadLocal<IOException> threadLocalResponseIOException = new ThreadLocal();

    public static String get(String url) {
        return SimpleHttpInvoker.asString(SimpleHttpInvoker.execute("GET", url, null));
    }

    public static byte[] getEntity(String url) {
        return SimpleHttpInvoker.execute("GET", url, null);
    }

    public static String post(String url, JSONObject body) {
        SimpleHttpInvoker.addHeader("Content-Type", "application/json; charset=UTF-8");
        return SimpleHttpInvoker.asString(SimpleHttpInvoker.execute("POST", url, body.toJSONString().getBytes(StandardCharsets.UTF_8)));
    }

    public static String post(String url, Map<String, String> body) {
        SimpleHttpInvoker.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : body.entrySet()) {
                sb.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name())).append("=");
                String value = entry.getValue();
                if (value != null) {
                    sb.append(URLEncoder.encode(value, StandardCharsets.UTF_8.name())).append("=");
                }
                sb.append("&");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            return SimpleHttpInvoker.asString(SimpleHttpInvoker.execute("POST", url, sb.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static void setProxy(String ip, String port) {
        threadLocalProxy.set(ip + ":" + port);
    }

    public static void setProxyAuth(String userName, String password) {
        threadLocalProxyAuth.set(new AuthHolder(userName, password));
    }

    public static void setTimout(int connectTimout, int readTimeout) {
        threadLocalConnectionTimeout.set(connectTimout);
        threadLocalReadTimeout.set(readTimeout);
    }

    public static void addHeader(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            SimpleHttpInvoker.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public static void addHeader(String key, String value) {
        LinkedHashMap<String, String> map = threadLocalRequestHeader.get();
        if (map == null) {
            map = new LinkedHashMap();
            threadLocalRequestHeader.set(map);
        }
        map.put(key, value);
    }

    public static IOException getIoException() {
        return threadLocalResponseIOException.get();
    }

    public static int getResponseStatus() {
        return threadLocalResponseStatus.get();
    }

    public static LinkedHashMap<String, String> getResponseHeader() {
        return threadLocalResponseHeader.get();
    }

    public static void setupDefaultHttpProperty(DefaultHttpPropertyBuilder defaultHttpPropertyBuilder) {
        threadLocalDefaultHttpProperty.set(defaultHttpPropertyBuilder);
        defaultHttpPropertyBuilder.build(SimpleHttpInvoker.newBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] execute(String method, String url, byte[] body) {
        threadLocalResponseStatus.remove();
        threadLocalResponseHeader.remove();
        threadLocalResponseIOException.remove();
        String proxyConfig = threadLocalProxy.get();
        try {
            HttpURLConnection connection;
            URL urlMode = new URL(url);
            if (proxyConfig != null && !proxyConfig.trim().isEmpty()) {
                String[] ipAndPort = proxyConfig.trim().split(":");
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ipAndPort[0].trim(), Integer.parseInt(ipAndPort[1].trim())));
                connection = (HttpURLConnection)urlMode.openConnection(proxy);
            } else {
                connection = (HttpURLConnection)urlMode.openConnection();
            }
            connection.setRequestMethod(method);
            Integer connectionTimeout = threadLocalConnectionTimeout.get();
            if (connectionTimeout == null) {
                connectionTimeout = 5000;
            }
            connection.setConnectTimeout(connectionTimeout);
            Integer readTimeout = threadLocalReadTimeout.get();
            if (readTimeout == null) {
                readTimeout = 5000;
            }
            connection.setReadTimeout(readTimeout);
            LinkedHashMap<String, String> requestHeaders = threadLocalRequestHeader.get();
            if (requestHeaders != null) {
                for (Map.Entry entry : requestHeaders.entrySet()) {
                    connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (body != null) {
                connection.setDoOutput(true);
                Throwable throwable = null;
                try (OutputStream os = connection.getOutputStream();){
                    os.write(body);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            Object object = SimpleHttpInvoker.readResponse(connection);
            return object;
        }
        catch (IOException e) {
            threadLocalResponseIOException.set(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            threadLocalRequestHeader.remove();
            threadLocalProxy.remove();
            DefaultHttpPropertyBuilder builder = threadLocalDefaultHttpProperty.get();
            if (builder != null) {
                builder.build(SimpleHttpInvoker.newBuilder());
            }
        }
    }

    public static String asString(byte[] data) {
        if (data == null) {
            return null;
        }
        LinkedHashMap<String, String> headers = threadLocalResponseHeader.get();
        Charset charset = StandardCharsets.UTF_8;
        String contentType = headers.get("content-type");
        if (contentType != null && contentType.contains(":")) {
            String charsetStr = contentType.split(":")[1].trim();
            charset = Charset.forName(charsetStr);
        }
        return new String(data, charset);
    }

    /*
     * Loose catch block
     */
    private static byte[] readResponse(HttpURLConnection connection) throws IOException {
        threadLocalResponseStatus.set(connection.getResponseCode());
        LinkedHashMap<String, String> responseHeader = new LinkedHashMap<String, String>();
        for (int i = 0; i < 128; ++i) {
            String key = connection.getHeaderFieldKey(i);
            if (key == null) {
                if (i != 0) break;
                continue;
            }
            responseHeader.put(key, connection.getHeaderField(key));
        }
        threadLocalResponseHeader.set(responseHeader);
        try {
            try (InputStream inputStream = connection.getInputStream();){
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private static void setupAuthenticator() {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                AuthHolder authHolder = (AuthHolder)threadLocalProxyAuth.get();
                if (authHolder == null) {
                    return super.getPasswordAuthentication();
                }
                return new PasswordAuthentication(authHolder.user, authHolder.pass);
            }
        });
    }

    private static void initSSL() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = (hostname, session) -> true;
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    public static RequestBuilder newBuilder() {
        return new RequestBuilder();
    }

    static {
        try {
            SimpleHttpInvoker.initSSL();
        }
        catch (Exception e) {
            throw new IllegalStateException("error", e);
        }
        SimpleHttpInvoker.setupAuthenticator();
    }

    public static interface DefaultHttpPropertyBuilder {
        public void build(RequestBuilder var1);
    }

    public static class RequestBuilder {
        public RequestBuilder setProxy(String ip, String port) {
            SimpleHttpInvoker.setProxy(ip, port);
            return this;
        }

        public RequestBuilder addHeader(Map<String, String> headers) {
            SimpleHttpInvoker.addHeader(headers);
            return this;
        }

        public RequestBuilder addHeader(String key, String value) {
            SimpleHttpInvoker.addHeader(key, value);
            return this;
        }

        public RequestBuilder setProxyAuth(String userName, String password) {
            SimpleHttpInvoker.setProxyAuth(userName, password);
            return this;
        }

        public RequestBuilder setTimout(int connectTimout, int readTimeout) {
            SimpleHttpInvoker.setTimout(connectTimout, readTimeout);
            return this;
        }
    }

    private static class AuthHolder {
        private final String user;
        private final char[] pass;

        public AuthHolder(String user, String pass) {
            this.user = user;
            this.pass = pass.toCharArray();
        }
    }
}

