/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class StringSplitter {
    public static final String EMPTY = "";

    public static Collection<String> split(String str) {
        return StringSplitter.split(str, null, -1);
    }

    public static Collection<String> split(String str, char separatorChar) {
        return StringSplitter.splitWorker(str, separatorChar, false);
    }

    public static Collection<String> split(String str, String separatorChars) {
        return StringSplitter.splitWorker(str, separatorChars, -1, false);
    }

    public static Collection<String> split(String str, String separatorChars, int max) {
        return StringSplitter.splitWorker(str, separatorChars, max, false);
    }

    public static Collection<String> splitByCharacterType(String str) {
        return StringSplitter.splitByCharacterType(str, false);
    }

    private static Collection<String> splitByCharacterType(String str, boolean camelCase) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return Collections.emptyList();
        }
        char[] c = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        for (int pos = tokenStart + 1; pos < c.length; ++pos) {
            int type = Character.getType(c[pos]);
            if (type == currentType) continue;
            if (camelCase && type == 2 && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String(c, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            currentType = type;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list;
    }

    public static Collection<String> splitByCharacterTypeCamelCase(String str) {
        return StringSplitter.splitByCharacterType(str, true);
    }

    public static Collection<String> splitByWholeSeparator(String str, String separator) {
        return StringSplitter.splitByWholeSeparatorWorker(str, separator, -1, false);
    }

    public static Collection<String> splitByWholeSeparator(String str, String separator, int max) {
        return StringSplitter.splitByWholeSeparatorWorker(str, separator, max, false);
    }

    public static Collection<String> splitByWholeSeparatorPreserveAllTokens(String str, String separator) {
        return StringSplitter.splitByWholeSeparatorWorker(str, separator, -1, true);
    }

    public static Collection<String> splitByWholeSeparatorPreserveAllTokens(String str, String separator, int max) {
        return StringSplitter.splitByWholeSeparatorWorker(str, separator, max, true);
    }

    private static Collection<String> splitByWholeSeparatorWorker(String str, String separator, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        if (separator == null || EMPTY.equals(separator)) {
            return StringSplitter.splitWorker(str, null, max, preserveAllTokens);
        }
        int separatorLength = separator.length();
        LinkedList<String> substrings = new LinkedList<String>();
        int numberOfSubstrings = 0;
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(separator, beg);
            if (end > -1) {
                if (end > beg) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                        continue;
                    }
                    substrings.add(str.substring(beg, end));
                    beg = end + separatorLength;
                    continue;
                }
                if (preserveAllTokens) {
                    if (++numberOfSubstrings == max) {
                        end = len;
                        substrings.add(str.substring(beg));
                    } else {
                        substrings.add(EMPTY);
                    }
                }
                beg = end + separatorLength;
                continue;
            }
            substrings.add(str.substring(beg));
            end = len;
        }
        return substrings;
    }

    public static Collection<String> splitPreserveAllTokens(String str) {
        return StringSplitter.splitWorker(str, null, -1, true);
    }

    public static Collection<String> splitPreserveAllTokens(String str, char separatorChar) {
        return StringSplitter.splitWorker(str, separatorChar, true);
    }

    public static Collection<String> splitPreserveAllTokens(String str, String separatorChars) {
        return StringSplitter.splitWorker(str, separatorChars, -1, true);
    }

    public static Collection<String> splitPreserveAllTokens(String str, String separatorChars, int max) {
        return StringSplitter.splitWorker(str, separatorChars, max, true);
    }

    private static Collection<String> splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        LinkedList<String> list = new LinkedList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list;
    }

    private static Collection<String> splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        LinkedList<String> list = new LinkedList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list;
    }
}

