/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class ThrowablePrinter {
    private static final String CAUSE_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";

    public static void printStackTrace(Collection<String> out, Throwable throwable) {
        Set<Throwable> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        dejaVu.add(throwable);
        out.add(throwable.toString());
        StackTraceElement[] trace = throwable.getStackTrace();
        for (StackTraceElement stackTraceElement : trace) {
            out.add("\tat " + stackTraceElement);
        }
        for (Serializable serializable : throwable.getSuppressed()) {
            ThrowablePrinter.printEnclosedStackTrace(out, (Throwable)serializable, trace, SUPPRESSED_CAPTION, "\t", dejaVu);
        }
        Throwable ourCause = throwable.getCause();
        if (ourCause != null) {
            ThrowablePrinter.printEnclosedStackTrace(out, ourCause, trace, CAUSE_CAPTION, "", dejaVu);
        }
    }

    private static void printEnclosedStackTrace(Collection<String> out, Throwable throwable, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu) {
        if (dejaVu.contains(throwable)) {
            out.add("\t[CIRCULAR REFERENCE:" + throwable + "]");
        } else {
            dejaVu.add(throwable);
            StackTraceElement[] trace = throwable.getStackTrace();
            int m = trace.length - 1;
            for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
            }
            int framesInCommon = trace.length - 1 - m;
            out.add(prefix + caption + throwable);
            for (int i = 0; i <= m; ++i) {
                out.add(prefix + "\tat " + trace[i]);
            }
            if (framesInCommon != 0) {
                out.add(prefix + "\t... " + framesInCommon + " more");
            }
            for (Throwable se : throwable.getSuppressed()) {
                ThrowablePrinter.printEnclosedStackTrace(out, se, trace, SUPPRESSED_CAPTION, prefix + "\t", dejaVu);
            }
            Throwable ourCause = throwable.getCause();
            if (ourCause != null) {
                ThrowablePrinter.printEnclosedStackTrace(out, ourCause, trace, CAUSE_CAPTION, prefix, dejaVu);
            }
        }
    }
}

