/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit.monitor;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.Nullable;
import java.util.Collection;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor {
    private static final Logger log = LoggerFactory.getLogger(Monitor.class);

    public static void addRegistry(MeterRegistry registry) {
        Metrics.addRegistry((MeterRegistry)registry);
    }

    public static void removeRegistry(MeterRegistry registry) {
        Metrics.removeRegistry((MeterRegistry)registry);
    }

    public static Counter counter(String name, Iterable<Tag> tags) {
        return Metrics.counter((String)name, tags);
    }

    public static Counter counter(String name, String ... tags) {
        if (!Monitor.checkStringTags(tags)) {
            return Metrics.counter((String)name, (String[])new String[0]);
        }
        return Metrics.counter((String)name, (String[])tags);
    }

    public static DistributionSummary summary(String name, Iterable<Tag> tags) {
        return Metrics.summary((String)name, tags);
    }

    public static DistributionSummary summary(String name, String ... tags) {
        if (!Monitor.checkStringTags(tags)) {
            return Metrics.summary((String)name, (String[])new String[0]);
        }
        return Metrics.summary((String)name, (String[])tags);
    }

    public static Timer timer(String name, Iterable<Tag> tags) {
        return Metrics.timer((String)name, tags);
    }

    public static Timer timer(String name, String ... tags) {
        if (!Monitor.checkStringTags(tags)) {
            return Metrics.timer((String)name, (String[])new String[0]);
        }
        return Metrics.timer((String)name, (String[])tags);
    }

    public static Metrics.More more() {
        return Metrics.more();
    }

    @Nullable
    public static <T> T gauge(String name, Iterable<Tag> tags, T obj, ToDoubleFunction<T> valueFunction) {
        return (T)Metrics.gauge((String)name, tags, obj, valueFunction);
    }

    @Nullable
    public static <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return (T)Metrics.gauge((String)name, tags, number);
    }

    @Nullable
    public static <T extends Number> T gauge(String name, T number) {
        return (T)Metrics.gauge((String)name, number);
    }

    @Nullable
    public static <T> T gauge(String name, T obj, ToDoubleFunction<T> valueFunction) {
        return (T)Metrics.gauge((String)name, obj, valueFunction);
    }

    @Nullable
    public static <T extends Collection<?>> T gaugeCollectionSize(String name, Iterable<Tag> tags, T collection) {
        return (T)Metrics.gaugeCollectionSize((String)name, tags, collection);
    }

    @Nullable
    public static <T extends Map<?, ?>> T gaugeMapSize(String name, Iterable<Tag> tags, T map) {
        return (T)Metrics.gaugeMapSize((String)name, tags, map);
    }

    private static boolean checkStringTags(String ... tags) {
        if (tags == null) {
            return true;
        }
        if (tags.length % 2 != 0) {
            Monitor.counter("monitor_tags_num_error", new String[0]).increment();
            log.error("tags num error:{}", (Object)String.join((CharSequence)",", tags), (Object)new Throwable());
            return false;
        }
        return true;
    }
}

