/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit.safethread;

import com.alibaba.fastjson.JSONObject;
import com.virjar.vtoolkit.Inspector;
import com.virjar.vtoolkit.monitor.Monitor;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Looper
implements Executor,
Inspector.Collector {
    private static final Logger log = LoggerFactory.getLogger(Looper.class);
    private final LinkedBlockingDeque<Runnable> taskQueue = new LinkedBlockingDeque();
    private final LoopThread loopThread;
    private final long createTimestamp = System.currentTimeMillis();
    private static Looper lowPriorityLooper;
    private final Counter monitorExecuteCounter;
    private final Timer monitorTimer;
    private final AtomicInteger monitorLooperQueueSize;
    private static final ScheduledExecutorService scheduler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Looper getLowPriorityLooper() {
        if (lowPriorityLooper != null) {
            return lowPriorityLooper;
        }
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            lowPriorityLooper = new Looper("lowPriorityLooper").startLoop();
            // ** MonitorExit[var0] (shouldn't be in output)
            return lowPriorityLooper;
        }
    }

    public Looper(String looperName) {
        Tags tags = Tags.of((String)"name", (String)looperName);
        Inspector.addCollector("looper." + looperName, this);
        this.monitorExecuteCounter = Monitor.counter("looper.execute", (Iterable<Tag>)tags);
        this.monitorTimer = Monitor.timer("looper.time", (Iterable<Tag>)tags);
        this.monitorLooperQueueSize = new AtomicInteger(0);
        Monitor.gauge("looper.taskQueueSize", (Iterable<Tag>)tags, this.monitorLooperQueueSize);
        this.loopThread = new LoopThread(looperName);
        this.loopThread.setDaemon(true);
    }

    public Looper startLoop() {
        this.loopThread.start();
        return this;
    }

    public void post(Runnable runnable) {
        this.post(runnable, false);
    }

    public void post(Runnable runnable, boolean first) {
        if (!this.loopThread.isAlive()) {
            if (System.currentTimeMillis() - this.createTimestamp > 60000L) {
                log.warn("post task before looper startup,do you call :startLoop??", new Throwable());
            }
            runnable.run();
            return;
        }
        if (this.inLooper()) {
            runnable.run();
            return;
        }
        if (first) {
            this.taskQueue.offerFirst(runnable);
        } else {
            this.taskQueue.add(runnable);
        }
    }

    public void postDelay(Runnable runnable, long delay) {
        if (delay <= 0L) {
            this.post(runnable);
            return;
        }
        if (!this.loopThread.isAlive() && System.currentTimeMillis() - this.createTimestamp > 60000L) {
            log.warn("post task before looper startup,do you call :startLoop??", new Throwable());
        }
        scheduler.schedule(() -> this.post(runnable), delay, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public FixRateScheduleHandle scheduleWithRate(Runnable runnable, long rate) {
        return this.scheduleWithRate(runnable, new Long(rate));
    }

    public FixRateScheduleHandle scheduleWithRate(Runnable runnable, Number rate) {
        FixRateScheduleHandle fixRateScheduleHandle = new FixRateScheduleHandle(runnable, rate);
        if (rate.longValue() > 0L) {
            this.post(runnable);
        }
        this.postDelay(fixRateScheduleHandle, rate.longValue());
        return fixRateScheduleHandle;
    }

    @Override
    public void execute(Runnable command) {
        this.post(command);
    }

    @Override
    public void collect(Inspector.Callback callback) {
        this.execute(() -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)this.loopThread.getName());
            jsonObject.put("task", this.taskQueue.stream().map(runnable -> runnable.getClass().getName()).collect(Collectors.toList()));
            callback.onData(jsonObject);
        });
    }

    public boolean inLooper() {
        return Thread.currentThread().equals(this.loopThread) || !this.loopThread.isAlive();
    }

    public void checkLooper() {
        if (!this.inLooper()) {
            throw new IllegalStateException("run task not in looper");
        }
    }

    public void close() {
        this.loopThread.interrupt();
    }

    static {
        scheduler = Executors.newScheduledThreadPool(1);
    }

    private class LoopThread
    extends Thread {
        LoopThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Runnable take = (Runnable)Looper.this.taskQueue.take();
                    Looper.this.monitorExecuteCounter.increment();
                    Looper.this.monitorLooperQueueSize.set(Looper.this.taskQueue.size());
                    Looper.this.monitorTimer.wrap(take).run();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (Throwable throwable) {
                    log.error("group event loop error", throwable);
                }
            }
        }
    }

    public class FixRateScheduleHandle
    implements Runnable {
        private final Runnable runnable;
        private final Number rate;
        private boolean running;

        FixRateScheduleHandle(Runnable runnable, Number rate) {
            this.runnable = runnable;
            this.running = true;
            this.rate = rate;
        }

        public void cancel() {
            this.running = false;
        }

        @Override
        public void run() {
            if (this.running && this.rate.longValue() > 0L) {
                Looper.this.postDelay(this, this.rate.longValue());
            }
            this.runnable.run();
        }
    }
}

