/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit.safethread;

import com.virjar.vtoolkit.safethread.Looper;
import com.virjar.vtoolkit.safethread.ValueCallback;

public class ParallelExecutor<T>
implements ValueCallback<T> {
    private final Looper looper;
    private final int eventSize;
    private int eventIndex = 0;
    private boolean success = false;
    private final ParallelConnectEvent<T> parallelConnectEvent;

    public ParallelExecutor(Looper looper, int eventSize, ParallelConnectEvent<T> parallelConnectEvent) {
        this.looper = looper;
        this.eventSize = eventSize;
        this.parallelConnectEvent = parallelConnectEvent;
    }

    @Override
    public void onReceiveValue(ValueCallback.Value<T> value) {
        if (!this.looper.inLooper()) {
            this.looper.post(() -> this.onReceiveValue(value));
            return;
        }
        ++this.eventIndex;
        if (value.isSuccess()) {
            if (!this.success) {
                this.success = true;
                this.parallelConnectEvent.firstSuccess(value);
            } else {
                this.parallelConnectEvent.secondSuccess(value);
            }
            return;
        }
        if (!this.success && this.eventIndex >= this.eventSize) {
            this.parallelConnectEvent.finalFailed(value.e);
        }
    }

    public static interface ParallelConnectEvent<T> {
        public void firstSuccess(ValueCallback.Value<T> var1);

        public void secondSuccess(ValueCallback.Value<T> var1);

        public void finalFailed(Throwable var1);
    }
}

