/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit.safethread;

public interface ValueCallback<T> {
    public void onReceiveValue(Value<T> var1);

    public static <T> void success(ValueCallback<T> callback, T t) {
        callback.onReceiveValue(Value.success(t));
    }

    public static <T> void failed(ValueCallback<T> callback, Throwable e) {
        callback.onReceiveValue(Value.failed(e));
    }

    public static <T> void failed(ValueCallback<T> callback, String message) {
        callback.onReceiveValue(Value.failed(message));
    }

    public static class Value<T> {
        public T v;
        public Throwable e;

        public boolean isSuccess() {
            return this.e == null;
        }

        public static <T> Value<T> failed(Throwable e) {
            Value<T> value = new Value<T>();
            value.e = e;
            return value;
        }

        public static <T> Value<T> failed(String message) {
            return Value.failed(new RuntimeException(message));
        }

        public static <T> Value<T> success(T t) {
            Value<T> value = new Value<T>();
            value.v = t;
            return value;
        }

        public <N> Value<N> errorTransfer() {
            Value<T> value = new Value<T>();
            value.e = this.e;
            return value;
        }
    }
}

