/*
 * Decompiled with CFR 0.152.
 */
package com.virjar.vtoolkit.trace;

import com.virjar.vtoolkit.StringSplitter;
import com.virjar.vtoolkit.ThrowablePrinter;
import com.virjar.vtoolkit.safethread.Looper;
import com.virjar.vtoolkit.trace.Event;
import com.virjar.vtoolkit.trace.Recorder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class EventScene {
    private final boolean all;
    private final String name;
    private static final Logger log = LoggerFactory.getLogger((String)"EventTrace");
    private static final List<EventScene> instances = new CopyOnWriteArrayList<EventScene>();
    public static final EventScene OTHER = EventScene.valueOf("OTHER", false);
    private final Slot[] slots = new Slot[30];
    private static final Recorder nopRecorder = new Recorder("none"){

        @Override
        public void recordEvent(Recorder.MessageGetter messageGetter, Throwable throwable) {
        }
    };
    private static final Recorder otherRecorder = new RecorderImpl("other", OTHER);
    private static final Looper looper = new Looper("eventRecorder").startLoop();
    private LinkedList<WeakReference<RecorderImpl>> historyRecorders = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventScene valueOf(String name, boolean all) {
        for (EventScene eventScene : instances) {
            if (!eventScene.getName().equals(name)) continue;
            return eventScene;
        }
        Class<EventScene> clazz = EventScene.class;
        synchronized (EventScene.class) {
            for (EventScene eventScene2 : instances) {
                if (!eventScene2.getName().equals(name)) continue;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return eventScene2;
            }
            EventScene eventScene = new EventScene(name, all);
            instances.add(eventScene);
            // ** MonitorExit[clazz] (shouldn't be in output)
            return eventScene;
        }
    }

    private EventScene(String name, boolean all) {
        this.all = all;
        this.name = name;
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = new Slot();
        }
    }

    public static EventScene[] values() {
        return instances.toArray(new EventScene[0]);
    }

    public static void post(Runnable runnable) {
        looper.post(runnable);
    }

    Map<String, List<Event>> fetchEvents() {
        looper.checkLooper();
        HashMap<String, List<Event>> ret = new HashMap<String, List<Event>>();
        for (Slot slot : this.slots) {
            Recorder recorder = slot.recorder;
            if (!(recorder instanceof RecorderImpl)) continue;
            RecorderImpl recorderImpl = (RecorderImpl)recorder;
            ArrayList events = new ArrayList(recorderImpl.events);
            ret.put(recorderImpl.sessionId, events);
        }
        for (WeakReference weakReference : this.historyRecorders) {
            RecorderImpl recorderImpl = (RecorderImpl)weakReference.get();
            if (recorderImpl == null) continue;
            ArrayList events = new ArrayList(recorderImpl.events);
            ret.put(recorderImpl.sessionId, events);
        }
        return ret;
    }

    public Recorder acquireRecorder(String sessionId, boolean debug) {
        if (debug || this.isAll()) {
            return new RecorderImpl(sessionId, this);
        }
        long nowTime = System.currentTimeMillis();
        int slotIndex = (int)(nowTime / 1000L % 60L) / 2;
        long timeMinute = nowTime / 60000L;
        Slot slot = this.slots[slotIndex];
        long slotTime = slot.time.get();
        if (slotTime == timeMinute) {
            return nopRecorder;
        }
        if (slot.time.compareAndSet(slotTime, timeMinute)) {
            this.cacheRecordImpl(slot.recorder);
            slot.recorder = new RecorderImpl(sessionId, this);
            return slot.recorder;
        }
        return nopRecorder;
    }

    public static Recorder nop() {
        return nopRecorder;
    }

    public static Recorder other() {
        return otherRecorder;
    }

    private void cacheRecordImpl(Recorder recorder) {
        if (!(recorder instanceof RecorderImpl)) {
            return;
        }
        looper.post(() -> this.appendRecordImplImpl((RecorderImpl)recorder));
    }

    private void appendRecordImplImpl(RecorderImpl recorder) {
        if (!looper.inLooper()) {
            looper.post(() -> this.appendRecordImplImpl(recorder));
            return;
        }
        if (this.historyRecorders.size() > 150) {
            LinkedList<WeakReference<RecorderImpl>> newLinkList = new LinkedList<WeakReference<RecorderImpl>>();
            for (WeakReference weakReference : this.historyRecorders) {
                RecorderImpl recorderImpl = (RecorderImpl)weakReference.get();
                if (recorderImpl == null) continue;
                newLinkList.add(new WeakReference<RecorderImpl>(recorderImpl));
                if (newLinkList.size() <= 150) continue;
                break;
            }
            this.historyRecorders = newLinkList;
        }
        this.historyRecorders.addFirst(new WeakReference<RecorderImpl>(recorder));
    }

    public boolean isAll() {
        return this.all;
    }

    public String getName() {
        return this.name;
    }

    static /* synthetic */ Recorder access$100() {
        return nopRecorder;
    }

    private static class RecorderImpl
    extends Recorder {
        private final LinkedList<Event> events = new LinkedList();
        private final String sessionId;
        private final EventScene eventScene;

        RecorderImpl(String sessionId, EventScene eventScene) {
            super(sessionId);
            this.sessionId = sessionId;
            this.eventScene = eventScene;
        }

        private Collection<String> splitMsg(String msg, Throwable throwable) {
            Collection<String> strings = StringSplitter.split(msg, '\n');
            if (throwable == null) {
                return strings;
            }
            if (strings.isEmpty()) {
                strings = new LinkedList<String>();
            }
            ThrowablePrinter.printStackTrace(strings, throwable);
            return strings;
        }

        @Override
        public void recordEvent(Recorder.MessageGetter messageGetter, Throwable throwable) {
            looper.post(() -> {
                MDC.put((String)"Scene", (String)this.eventScene.getName());
                String subTitle = this.getSubTitle();
                String message = messageGetter.getMessage();
                Collection<String> msgLines = this.splitMsg(messageGetter.getMessage(), throwable);
                for (String line : msgLines) {
                    if (subTitle != null) {
                        log.info("sessionId:{} subTitle:{} -> {}", new Object[]{this.sessionId, subTitle, line});
                        continue;
                    }
                    log.info("sessionId:{} -> {}", (Object)this.sessionId, (Object)line);
                }
                Event event = new Event(System.currentTimeMillis(), message, throwable);
                this.events.addLast(event);
            });
        }

        @Override
        public boolean enable() {
            return true;
        }
    }

    private static class Slot {
        private final AtomicLong time = new AtomicLong(0L);
        private Recorder recorder = EventScene.access$100();

        private Slot() {
        }
    }
}

