/*
 * Decompiled with CFR 0.152.
 */
package com.virtusa.gto.nyql.db;

import com.virtusa.gto.nyql.Assign;
import com.virtusa.gto.nyql.CTE;
import com.virtusa.gto.nyql.Column;
import com.virtusa.gto.nyql.FunctionColumn;
import com.virtusa.gto.nyql.Join;
import com.virtusa.gto.nyql.QContextType;
import com.virtusa.gto.nyql.QResultProxy;
import com.virtusa.gto.nyql.Query;
import com.virtusa.gto.nyql.QueryInsert;
import com.virtusa.gto.nyql.QueryPart;
import com.virtusa.gto.nyql.QuerySelect;
import com.virtusa.gto.nyql.QueryTruncate;
import com.virtusa.gto.nyql.Table;
import com.virtusa.gto.nyql.TableAll;
import com.virtusa.gto.nyql.Where;
import com.virtusa.gto.nyql.WithClosure;
import com.virtusa.gto.nyql.db.QTranslator;
import com.virtusa.gto.nyql.db.SqlMisc;
import com.virtusa.gto.nyql.db.TranslatorOptions;
import com.virtusa.gto.nyql.exceptions.NyException;
import com.virtusa.gto.nyql.model.DbInfo;
import com.virtusa.gto.nyql.model.JoinType;
import com.virtusa.gto.nyql.model.ValueTable;
import com.virtusa.gto.nyql.model.units.AParam;
import com.virtusa.gto.nyql.utils.QOperator;
import com.virtusa.gto.nyql.utils.QUtils;
import com.virtusa.gto.nyql.utils.QueryType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractSQLTranslator
implements QTranslator {
    private static final String EMPTY = "";
    private final TranslatorOptions translatorOptions;
    private final Collection<String> keywords;
    private static final String NL = "\n";
    private static final String _AS_ = " AS ";
    private static final String COMMA = ", ";

    protected AbstractSQLTranslator() {
        this.translatorOptions = TranslatorOptions.empty();
        this.keywords = this.translatorOptions.getKeywords();
    }

    protected AbstractSQLTranslator(TranslatorOptions theOptions) {
        this.translatorOptions = theOptions != null ? theOptions : TranslatorOptions.empty();
        this.keywords = this.translatorOptions.getKeywords();
    }

    protected TranslatorOptions getTranslatorOptions() {
        return this.translatorOptions;
    }

    protected boolean isUnresolvedVersion(DbInfo dbInfo) {
        return dbInfo == null || dbInfo == DbInfo.UNRESOLVED;
    }

    protected abstract String getQuoteChar();

    protected String convertToAlias(String alias, String qChar) {
        return this.keywords.contains(alias.toUpperCase(Locale.getDefault())) ? QUtils.quote((String)alias, (String)qChar) : QUtils.quoteIfWS((String)alias, (String)qChar);
    }

    protected String tableSchema(Table table, String qChar) {
        if (table.get__schema() != null) {
            return QUtils.quote((String)table.get__schema(), (String)qChar) + ".";
        }
        return EMPTY;
    }

    protected String tableAlias(Table table, String qChar) {
        if (table.__aliasDefined()) {
            return this.convertToAlias(table.get__alias(), qChar);
        }
        return EMPTY;
    }

    protected String tableAliasAs(Table table, String qChar) {
        if (table.__aliasDefined()) {
            return _AS_ + this.convertToAlias(table.get__alias(), qChar);
        }
        return EMPTY;
    }

    protected String columnAlias(Column column, String qChar) {
        if (column.__aliasDefined()) {
            return this.convertToAlias(column.get__alias(), qChar);
        }
        return EMPTY;
    }

    protected String columnAliasAs(Column column, String qChar) {
        if (column.__aliasDefined()) {
            return _AS_ + this.convertToAlias(column.get__alias(), qChar);
        }
        return EMPTY;
    }

    protected final String tableName(String tblName) {
        return this.getTranslatorOptions().tableMapName(tblName);
    }

    protected final String columnName(String tblName, String colName) {
        return this.getTranslatorOptions().columnMapName(tblName, colName);
    }

    protected String generateTableJoinName(Join join, String joinType, QContextType contextType, List<AParam> paramOrder) {
        QResultProxy proxy;
        StringBuilder qstr = new StringBuilder();
        if (join.getTable1().__isResultOf()) {
            proxy = (QResultProxy)join.getTable1().get__resultOf();
            this.addAllSafely(paramOrder, proxy.getOrderedParameters());
        }
        qstr.append(this.___resolve(join.getTable1(), contextType, paramOrder));
        qstr.append(" ").append(joinType).append(" ");
        if (join.getTable2().__isResultOf()) {
            proxy = (QResultProxy)join.getTable2().get__resultOf();
            this.addAllSafely(paramOrder, proxy.getOrderedParameters());
        }
        qstr.append(this.___resolve(join.getTable2(), contextType, paramOrder));
        if (join.___hasCondition()) {
            qstr.append(" ON ").append(this.___expandConditions(join.getOnConditions(), paramOrder, QUtils.findDeleteContext((QContextType)contextType)));
        }
        return qstr.toString();
    }

    protected QResultProxy generateInsertQuery(QueryInsert q, String quoteChar) throws NyException {
        if (QUtils.isNullOrEmpty((Map)q.get_data()) && q.get_assigns() == null) {
            return this.___selectQuery((QuerySelect)q);
        }
        LinkedList<AParam> paramList = new LinkedList<AParam>();
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ").append(this.___resolve(q.getSourceTbl(), QContextType.INTO, paramList)).append(" (");
        LinkedList<String> colList = new LinkedList<String>();
        LinkedList<String> valList = new LinkedList<String>();
        if (q.get_data() != null) {
            for (Map.Entry entry : q.get_data().entrySet()) {
                colList.add(QUtils.quote((String)((String)entry.getKey()), (String)quoteChar));
                this.___scanForParameters(entry.getValue(), paramList);
                valList.add(String.valueOf(this.___resolve(entry.getValue(), QContextType.INSERT_DATA, paramList)));
            }
        }
        if (q.get_assigns() != null && q.get_assigns().__hasAssignments()) {
            for (Map.Entry object : q.get_assigns().getAssignments()) {
                if (!(object instanceof Assign.AnAssign)) continue;
                Assign.AnAssign anAssign = (Assign.AnAssign)object;
                if (anAssign.getLeftOp() instanceof Column) {
                    colList.add(String.valueOf(this.___resolve(anAssign.getLeftOp(), QContextType.INSERT_PROJECTION, paramList)));
                } else {
                    colList.add(QUtils.quote((String)anAssign.toString(), (String)quoteChar));
                }
                this.___scanForParameters(anAssign.getRightOp(), paramList);
                valList.add(String.valueOf(this.___resolve(anAssign.getRightOp(), QContextType.INSERT_DATA, paramList)));
            }
        }
        query.append(colList.stream().collect(Collectors.joining(COMMA))).append(") VALUES (").append(valList.stream().collect(Collectors.joining(COMMA))).append(")");
        QResultProxy resultProxy = this.createProxy(query.toString(), QueryType.INSERT, paramList, null, null);
        resultProxy.setReturnType(q.getReturnType());
        return resultProxy;
    }

    protected StringBuilder generateSelectQueryBody(QuerySelect q, List<AParam> paramList) throws NyException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        if (q.is_distinct()) {
            query.append("DISTINCT ");
        }
        query.append(this.___expandProjection(q.getProjection(), paramList, QContextType.SELECT)).append(NL);
        this.___selectQueryAfterFetchClause(q, query, paramList);
        if (q.get_joiningTable() != null) {
            query.append(" FROM ").append(this.___deriveSource(q.get_joiningTable(), paramList, QContextType.FROM)).append(NL);
        } else if (q.getSourceTbl() != null) {
            query.append(" FROM ").append(this.___deriveSource(q.getSourceTbl(), paramList, QContextType.FROM)).append(NL);
        }
        if (q.getWhereObj() != null && q.getWhereObj().__hasClauses()) {
            query.append(" WHERE ").append(this.___expandConditions(q.getWhereObj(), paramList, QContextType.CONDITIONAL)).append(NL);
        }
        if (QUtils.notNullNorEmpty((Collection)q.getGroupBy())) {
            this.___selectQueryGroupByClause(q, query, paramList);
        }
        if (q.getGroupHaving() != null) {
            query.append(NL).append(" HAVING ").append(this.___expandConditions(q.getGroupHaving(), paramList, QContextType.HAVING));
            query.append(NL);
        }
        if (QUtils.notNullNorEmpty((Collection)q.getOrderBy())) {
            String oClauses = QUtils.join((List)q.getOrderBy(), it -> this.___resolve(it, QContextType.ORDER_BY, paramList), (String)COMMA, (String)EMPTY, (String)EMPTY);
            query.append(" ORDER BY ").append(oClauses).append(NL);
        }
        if (q.get_limit() != null) {
            if (q.get_limit() instanceof Integer && (Integer)q.get_limit() > 0) {
                query.append(" LIMIT ").append(String.valueOf(q.get_limit())).append(NL);
            } else if (q.get_limit() instanceof AParam) {
                paramList.add((AParam)q.get_limit());
                query.append(" LIMIT ").append(this.___resolve(q.get_limit(), QContextType.ORDER_BY)).append(NL);
            }
        }
        if (q.getOffset() != null) {
            if (q.getOffset() instanceof Integer && (Integer)q.getOffset() >= 0) {
                query.append(" OFFSET ").append(String.valueOf(q.getOffset())).append(NL);
            } else if (q.getOffset() instanceof AParam) {
                paramList.add((AParam)q.getOffset());
                query.append(" OFFSET ").append(this.___resolve(q.getOffset(), QContextType.ORDER_BY)).append(NL);
            }
        }
        return query;
    }

    protected List<QResultProxy> generateCTE(CTE cte) throws NyException {
        LinkedList<AParam> paramList = new LinkedList<AParam>();
        LinkedList<String> qctes = new LinkedList<String>();
        int recCount = 0;
        for (Object item : cte.getWiths()) {
            Object query;
            StringBuilder iqStr = new StringBuilder();
            Map map = (Map)item;
            Table tbl = (Table)map.get("table");
            iqStr.append(this.___tableName(tbl, QContextType.INTO));
            List cols = (List)map.get("cols");
            if (QUtils.notNullNorEmpty((Collection)cols)) {
                iqStr.append(" (").append(String.join((CharSequence)COMMA, cols)).append(')');
            }
            if ((query = map.get("query")) instanceof QuerySelect) {
                QResultProxy proxy = this.___selectQuery((QuerySelect)query);
                iqStr.append(_AS_).append('(').append(proxy.getQuery()).append(')');
                paramList.addAll(proxy.getOrderedParameters());
            } else if (query instanceof WithClosure) {
                WithClosure withClosure = (WithClosure)query;
                QResultProxy proxy = this.___combinationQuery(withClosure.getCombineType(), Arrays.asList(withClosure.getAnchor(), withClosure.getRecursion()));
                iqStr.append(_AS_).append('(').append(proxy.getQuery()).append(')');
                paramList.addAll(proxy.getOrderedParameters());
                ++recCount;
            }
            qctes.add(iqStr.toString());
        }
        StringBuilder mq = new StringBuilder();
        mq.append("WITH ");
        if (recCount > 0) {
            mq.append("RECURSIVE ");
        }
        mq.append(String.join((CharSequence)COMMA, qctes));
        QResultProxy proxy = this.___selectQuery(cte.getQuerySelect());
        paramList.addAll(proxy.getOrderedParameters());
        mq.append(' ').append(proxy.getQuery());
        return Collections.singletonList(this.createProxy(mq.toString(), QueryType.CTE, paramList, null, null));
    }

    protected QResultProxy _generateSelectQFullJoin(QuerySelect q) throws NyException {
        int count = SqlMisc.countJoin(q.get_joiningTable(), JoinType.FULL_JOIN);
        if (count > 0) {
            LinkedList<String> qs = new LinkedList<String>();
            QResultProxy resultProxy = new QResultProxy();
            resultProxy.setOrderedParameters(new LinkedList());
            for (int i = count; i >= 0; --i) {
                QuerySelect qt = SqlMisc.cloneQuery(q);
                SqlMisc.flipNthFullJoin(qt.get_joiningTable(), i, 0);
                SqlMisc.appendNullableConstraints(qt, count - i - 1);
                StringBuilder qr = this.generateSelectQueryBody(qt, resultProxy.getOrderedParameters());
                qs.add(qr.toString());
            }
            resultProxy.setQueryType(QueryType.SELECT);
            resultProxy.setQuery(String.join((CharSequence)" UNION ALL ", qs));
            return resultProxy;
        }
        LinkedList<AParam> paramList = new LinkedList<AParam>();
        QueryType queryType = QueryType.SELECT;
        return this.createProxy(this.generateSelectQueryBody(q, paramList).toString(), queryType, paramList, null, null);
    }

    protected void ___selectQueryAfterFetchClause(QuerySelect q, StringBuilder query, List<AParam> paramList) throws NyException {
    }

    protected void ___selectQueryGroupByClause(QuerySelect q, StringBuilder query, List<AParam> paramList) throws NyException {
        String gClauses = QUtils.join((List)q.getGroupBy(), it -> this.___resolve(it, QContextType.GROUP_BY, paramList), (String)COMMA, (String)EMPTY, (String)EMPTY);
        query.append(" GROUP BY ").append(gClauses);
        if (q.getGroupByRollup()) {
            query.append(" WITH ROLLUP");
        }
    }

    public QResultProxy ___truncateQuery(QueryTruncate q) {
        String query = "TRUNCATE TABLE " + this.___tableName(q.getSourceTbl(), QContextType.TRUNCATE);
        return this.createProxy(query, QueryType.TRUNCATE, new ArrayList<AParam>(), null, null);
    }

    public QResultProxy ___partQuery(QueryPart q) throws NyException {
        LinkedList<AParam> paramList = new LinkedList<AParam>();
        StringBuilder query = new StringBuilder();
        QueryType queryType = QueryType.PART;
        if (q.get_allProjections() != null) {
            query.append(this.___expandProjection(q.get_allProjections(), paramList, QContextType.SELECT));
            return this.createProxy(query.toString(), queryType, paramList, q.get_allProjections(), (Query)q);
        }
        if (q.getSourceTbl() != null) {
            query.append(this.___deriveSource(q.getSourceTbl(), paramList, QContextType.FROM));
            return this.createProxy(query.toString(), queryType, paramList, q.getSourceTbl(), (Query)q);
        }
        if (q.getWhereObj() != null) {
            query.append(this.___expandConditions(q.getWhereObj(), paramList, QContextType.CONDITIONAL));
            return this.createProxy(query.toString(), queryType, paramList, q.getWhereObj(), (Query)q);
        }
        if (q.get_assigns() != null) {
            query.append(this.___expandAssignments(q.get_assigns(), paramList, QContextType.UPDATE_SET));
            return this.createProxy(query.toString(), queryType, paramList, q.get_assigns(), (Query)q);
        }
        if (QUtils.notNullNorEmpty((Collection)q.get_intoColumns())) {
            query.append(this.___expandProjection(q.get_intoColumns(), paramList, QContextType.INSERT_PROJECTION));
            return this.createProxy(query.toString(), queryType, paramList, q.get_intoColumns(), (Query)q);
        }
        if (!QUtils.isNullOrEmpty((Map)q.get_dataColumns())) {
            return this.createProxy(EMPTY, queryType, paramList, q.get_dataColumns(), (Query)q);
        }
        throw new NyException("Unknown or incomplete re-usable query clause!");
    }

    public QResultProxy ___valueTable(ValueTable valueTable) throws NyException {
        Object vals = valueTable.getValues();
        if (vals == null) {
            throw new NyException("Values cannot be null for creating table out of it!");
        }
        String col = valueTable.getColumnAlias();
        LinkedList params = new LinkedList();
        LinkedList<String> qItems = new LinkedList<String>();
        if (vals instanceof Collection) {
            Collection objVals = (Collection)vals;
            boolean first = true;
            for (Object item : objVals) {
                StringBuilder qi = new StringBuilder();
                qi.append("SELECT ");
                if (first) {
                    first = false;
                    if (item instanceof Map) {
                        qi.append(((Map)item).entrySet().stream().map(entry -> this.___resolve(entry.getValue(), QContextType.FROM, params) + _AS_ + this.convertToAlias((String)entry.getKey(), this.getQuoteChar())).collect(Collectors.joining(COMMA)));
                        qItems.add(qi.toString());
                        continue;
                    }
                    if (col != null) {
                        qi.append(this.___resolve(item, QContextType.FROM, params)).append(_AS_).append(this.convertToAlias(col, this.getQuoteChar()));
                        qItems.add(qi.toString());
                        continue;
                    }
                }
                if (item instanceof Map) {
                    qi.append((Object)((Map)item).values().stream().map(v -> this.___resolve(v, QContextType.FROM, params)).collect(Collectors.joining(COMMA)));
                } else {
                    qi.append(this.___resolve(item, QContextType.FROM, params));
                }
                qItems.add(qi.toString());
            }
            QResultProxy proxy = new QResultProxy();
            proxy.setQuery(String.join((CharSequence)" UNION ALL ", qItems));
            proxy.setOrderedParameters(params);
            proxy.setRawObject((Object)valueTable);
            return proxy;
        }
        throw new NyException("Values must be an instance of list!");
    }

    protected QResultProxy createProxy(String query, QueryType queryType, List<AParam> params, Object raw, Query queryObject) {
        QResultProxy proxy = new QResultProxy();
        proxy.setQuery(query);
        proxy.setQueryType(queryType);
        proxy.setOrderedParameters(params);
        proxy.setRawObject(raw);
        proxy.setqObject(queryObject);
        return proxy;
    }

    protected String ___expandProjection(List<Object> columns, List<AParam> paramList, QContextType contextType) throws NyException {
        ArrayList<String> cols = new ArrayList<String>();
        if (columns == null || columns.isEmpty()) {
            return "*";
        }
        LinkedList<Object> finalCols = new LinkedList<Object>();
        for (Object c : columns) {
            if (c instanceof QResultProxy) {
                if (((QResultProxy)c).getQueryType() != QueryType.PART) {
                    throw new NyException("Only query parts allowed to import within sql projection!");
                }
                List otherColumns = (List)((QResultProxy)c).getRawObject();
                finalCols.addAll(otherColumns);
                continue;
            }
            if (c instanceof List) {
                finalCols.addAll((List)c);
                continue;
            }
            finalCols.add(c);
        }
        for (Object c : finalCols) {
            if (!(c instanceof TableAll)) {
                this.___scanForParameters(c, paramList);
            }
            if (c instanceof TableAll) {
                cols.add(((TableAll)c).get__alias() + ".*");
                continue;
            }
            if (c instanceof Table) {
                String tbName = this.___tableName((Table)c, contextType);
                if (((Table)c).__isResultOf()) {
                    cols.add(tbName);
                    continue;
                }
                cols.add(tbName + ".*");
                continue;
            }
            if (c instanceof Column) {
                AbstractSQLTranslator.appendParamsFromColumn((Column)c, paramList);
                String cName = this.___columnName((Column)c, contextType, paramList);
                cols.add(cName);
                continue;
            }
            if (c instanceof String) {
                cols.add((String)c);
                continue;
            }
            cols.add(String.valueOf(this.___resolve(c, contextType, paramList)));
        }
        return cols.stream().collect(Collectors.joining(COMMA));
    }

    private static void appendParamsFromColumn(Column column, List<AParam> paramList) {
        if (column instanceof FunctionColumn) {
            if (((FunctionColumn)column).get_setOfCols()) {
                for (Object it : ((FunctionColumn)column).get_columns()) {
                    if (!(it instanceof QResultProxy) || ((QResultProxy)it).getOrderedParameters() == null) continue;
                    paramList.addAll(((QResultProxy)it).getOrderedParameters());
                }
            } else {
                Object wrap = ((FunctionColumn)column).get_wrapper();
                if (wrap instanceof QResultProxy && ((QResultProxy)wrap).getOrderedParameters() != null) {
                    paramList.addAll(((QResultProxy)wrap).getOrderedParameters());
                }
            }
        }
    }

    protected void ___scanForParameters(Object expression, List<AParam> paramOrder) {
        if (expression != null) {
            QResultProxy resultProxy;
            if (expression instanceof QResultProxy) {
                resultProxy = (QResultProxy)expression;
                if (resultProxy.getOrderedParameters() != null) {
                    paramOrder.addAll(resultProxy.getOrderedParameters());
                }
            } else if (expression instanceof Table && ((Table)expression).__isResultOf()) {
                resultProxy = (QResultProxy)((Table)expression).get__resultOf();
                if (resultProxy.getOrderedParameters() != null) {
                    paramOrder.addAll(resultProxy.getOrderedParameters());
                }
            } else if (expression instanceof FunctionColumn) {
                this.___expandColumn((Column)((FunctionColumn)expression), paramOrder);
            }
            if (expression instanceof List) {
                for (Object it : (List)expression) {
                    this.___scanForParameters(it, paramOrder);
                }
            }
        }
    }

    protected String ___deriveSource(Table table, List<AParam> paramOrder, QContextType contextType) {
        QResultProxy proxy;
        if (table instanceof Join) {
            return this.___tableJoinName((Join)table, contextType, paramOrder);
        }
        if (table.__isResultOf() && (proxy = (QResultProxy)table.get__resultOf()).getOrderedParameters() != null) {
            paramOrder.addAll(proxy.getOrderedParameters());
        }
        return this.___tableName(table, contextType);
    }

    protected void ___expandColumn(Column column, List<AParam> paramList) {
        if (column instanceof FunctionColumn && ((FunctionColumn)column).get_columns() != null) {
            for (Object it : ((FunctionColumn)column).get_columns()) {
                if (!(it instanceof FunctionColumn)) continue;
                this.___expandColumn((Column)((FunctionColumn)it), paramList);
            }
        }
    }

    protected String ___expandConditions(Where where, List<AParam> paramOrder, QContextType contextType) {
        StringBuilder builder = new StringBuilder();
        LinkedList<Object> clauses = where.getClauses();
        int ccount = 0;
        for (Object e : clauses) {
            String expr;
            if (e instanceof QOperator) {
                ++ccount;
                continue;
            }
            if (!(e instanceof String) || !(expr = String.valueOf(e).trim()).equals("AND") && !expr.equals("OR")) continue;
            ++ccount;
        }
        if (ccount == 0 && clauses.size() > 1) {
            LinkedList<Object> tmp = new LinkedList<Object>();
            boolean bl = false;
            for (Object c : where.getClauses()) {
                boolean bl2;
                if (bl2) {
                    tmp.add(QOperator.AND);
                }
                tmp.add(c);
                bl2 = true;
            }
            clauses = tmp;
        }
        for (Object e : clauses) {
            if (e instanceof String) {
                builder.append(e);
                continue;
            }
            if (e instanceof QOperator) {
                builder.append(' ').append(this.___convertOperator((QOperator)e)).append(' ');
                continue;
            }
            if (e instanceof Where.QCondition) {
                builder.append(this.___expandCondition((Where.QCondition)e, paramOrder, contextType));
                continue;
            }
            if (!(e instanceof Where.QConditionGroup)) continue;
            builder.append(QUtils.parenthesis((String)this.___expandConditionGroup((Where.QConditionGroup)e, paramOrder, contextType)));
        }
        return builder.toString();
    }

    protected String ___expandCondition(Where.QCondition c, List<AParam> paramOrder, QContextType contextType) {
        this.___scanForParameters(c.getLeftOp(), paramOrder);
        this.___scanForParameters(c.getRightOp(), paramOrder);
        boolean parenthesis = c.getRightOp() instanceof QResultProxy;
        if (c instanceof Where.QUnaryCondition) {
            QOperator op = c.getOp();
            return this.___convertOperator(op) + (op != QOperator.UNKNOWN ? " " : EMPTY) + (parenthesis ? QUtils.parenthesis((String)this.___resolve(((Where.QUnaryCondition)c).chooseOp(), contextType, paramOrder)) : this.___resolve(((Where.QUnaryCondition)c).chooseOp(), contextType, paramOrder));
        }
        return this.___resolveOperand(c.getLeftOp(), paramOrder, contextType) + (c.getOp() != QOperator.UNKNOWN ? ' ' + this.___convertOperator(c.getOp()) + ' ' : Character.valueOf(' ')) + (!parenthesis ? this.___resolveOperand(c.getRightOp(), paramOrder, contextType) : QUtils.parenthesis((String)this.___resolveOperand(c.getRightOp(), paramOrder, contextType)));
    }

    private String ___resolveOperand(Object operand, List<AParam> paramOrder, QContextType contextType) {
        if (operand instanceof Where.QCondition) {
            return this.___expandCondition((Where.QCondition)operand, paramOrder, contextType);
        }
        return this.___resolve(operand, contextType, paramOrder);
    }

    protected String ___expandConditionGroup(Where.QConditionGroup group, List<AParam> paramOrder, QContextType contextType) {
        String gCon = group.getCondConnector() == null ? EMPTY : " " + this.___convertOperator(group.getCondConnector()) + " ";
        LinkedList<String> list = new LinkedList<String>();
        for (Object clause : group.getWhere().getClauses()) {
            if (clause instanceof Where.QCondition) {
                list.add(this.___expandCondition((Where.QCondition)clause, paramOrder, contextType));
                continue;
            }
            if (clause instanceof Where.QConditionGroup) {
                list.add(QUtils.parenthesis((String)this.___expandConditionGroup((Where.QConditionGroup)clause, paramOrder, contextType)));
                continue;
            }
            list.add(this.___resolve(clause, contextType, paramOrder));
        }
        return list.stream().collect(Collectors.joining(gCon));
    }

    protected String ___expandAssignments(Assign assign, List<AParam> paramOrder, QContextType contextType) {
        List clauses = assign.getAssignments();
        ArrayList<String> derived = new ArrayList<String>();
        for (Object c : clauses) {
            if (c instanceof Assign.AnAssign) {
                Assign.AnAssign anAssign = (Assign.AnAssign)c;
                if (anAssign.getLeftOp() instanceof AParam) {
                    paramOrder.add((AParam)anAssign.getLeftOp());
                }
                this.___scanForParameters(anAssign.getRightOp(), paramOrder);
                String val = this.___resolve(anAssign.getLeftOp(), contextType, paramOrder) + ' ' + this.___convertOperator(anAssign.getOp()) + ' ' + this.___resolve(anAssign.getRightOp(), contextType, paramOrder);
                derived.add(val);
                continue;
            }
            derived.add(this.___resolve(c, contextType, paramOrder));
        }
        return derived.stream().collect(Collectors.joining(COMMA));
    }

    private <T> List<T> addSafely(List<T> list, T item) {
        if (list != null) {
            list.add(item);
        }
        return list;
    }

    private <T> List<T> addAllSafely(List<T> list, Collection<T> items) {
        if (list != null) {
            list.addAll(items);
        }
        return list;
    }
}

