/*
 * Decompiled with CFR 0.152.
 */
package com.viskan.cxf.xjc.hce;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Objects;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class UtilityPlugin
extends Plugin {
    private static final String JAVADOC = "Auto-generated by {@code com.viskan/cxf-xjc-hce}";

    public String getOptionName() {
        return "Xhashcode-equals";
    }

    public String getUsage() {
        return "  -Xhashcode-equals  :  Activate to add #hashCode and #equals implementations to generated classes";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        for (ClassOutline classOutline : outline.getClasses()) {
            this.addHashCode(outline, classOutline);
            this.addEquals(outline, classOutline);
        }
        return true;
    }

    private void addHashCode(Outline outline, ClassOutline classOutline) {
        FieldOutline[] fields;
        JDefinedClass implementation = classOutline.getImplClass();
        JMethod hashCode = implementation.method(1, Integer.TYPE, "hashCode");
        hashCode.annotate(Override.class);
        hashCode.javadoc().append((Object)JAVADOC);
        JClass objects = outline.getCodeModel().ref(Objects.class);
        JInvocation hash = objects.staticInvoke("hash");
        for (FieldOutline field : fields = classOutline.getDeclaredFields()) {
            String fieldName = field.getPropertyInfo().getName(false);
            hash.arg((JExpression)JExpr.ref((String)fieldName));
        }
        hashCode.body()._return((JExpression)hash);
    }

    private void addEquals(Outline outline, ClassOutline classOutline) {
        FieldOutline[] declaredFields;
        JDefinedClass implementation = classOutline.getImplClass();
        JMethod equals = implementation.method(1, Boolean.TYPE, "equals");
        equals.annotate(Override.class);
        equals.javadoc().append((Object)JAVADOC);
        JVar obj = equals.param(Object.class, "obj");
        JBlock body = equals.body();
        body._if(obj.eq(JExpr._this()))._then()._return(JExpr.lit((boolean)true));
        body._if(obj.eq(JExpr._null()).cor(obj.invoke("getClass").ne((JExpression)JExpr._this().invoke("getClass"))))._then()._return(JExpr.lit((boolean)false));
        JVar that = body.decl((JType)implementation, "that");
        body.assign((JAssignmentTarget)that, (JExpression)JExpr.cast((JType)implementation, (JExpression)obj));
        JVar isEqual = body.decl((JType)outline.getCodeModel().BOOLEAN, "isEqual");
        body.assign((JAssignmentTarget)isEqual, JExpr.TRUE);
        JClass objects = outline.getCodeModel().ref(Objects.class);
        for (FieldOutline fieldOutline : declaredFields = classOutline.getDeclaredFields()) {
            String fieldName = fieldOutline.getPropertyInfo().getName(false);
            boolean primitive = fieldOutline.getRawType().isPrimitive();
            if (primitive) {
                JExpression equalsOperator = JExpr._this().ref(fieldName).eq((JExpression)JExpr.ref((String)"that").ref(fieldName));
                body.assign((JAssignmentTarget)isEqual, isEqual.cand(equalsOperator));
                continue;
            }
            JInvocation equalsMethod = objects.staticInvoke("equals");
            equalsMethod.arg((JExpression)JExpr._this().ref(fieldName));
            equalsMethod.arg((JExpression)JExpr.ref((String)"that").ref(fieldName));
            body.assign((JAssignmentTarget)isEqual, isEqual.cand((JExpression)equalsMethod));
        }
        body._return((JExpression)isEqual);
    }
}

