/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.oracle;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.text.DecimalFormat;
import java.text.NumberFormat;

class OraGeom {
    public static final int NULL_DIMENSION = -1;
    private static NumberFormat fmt = new DecimalFormat("0.################");
    public static final String SQL_NULL = "NULL";
    int gType;
    int srid;
    double[] point = null;
    int[] elemInfo = null;
    double[] ordinates = null;
    private int geomType;
    private int ordDim;
    private int lrsDim;
    public static final String TYPE_GEOMETRY = "MDSYS.SDO_GEOMETRY";
    public static final String TYPE_ELEM_INFO_ARRAY = "MDSYS.SDO_ELEM_INFO_ARRAY";
    public static final String TYPE_ORDINATE_ARRAY = "MDSYS.SDO_ORDINATE_ARRAY";
    public static final String TYPE_POINT_TYPE = "MDSYS.SDO_POINT_TYPE";
    public static final int SRID_NULL = -1;

    public OraGeom(int gType, int srid, double[] ptType, int[] elemInfo, double[] ordinates) {
        this.gType = gType;
        this.srid = srid;
        this.point = ptType;
        this.elemInfo = elemInfo;
        this.ordinates = ordinates;
        this.geomType = OraGeom.gTypeGeomType(gType);
        this.ordDim = OraGeom.gTypeDim(gType);
        this.lrsDim = OraGeom.gTypeMeasureDim(gType);
    }

    public OraGeom(int gType, int srid, int[] elemInfo, double[] ordinates) {
        this(gType, srid, null, elemInfo, ordinates);
    }

    public OraGeom(int gType, int srid, double[] ptType) {
        this(gType, srid, ptType, null, null);
    }

    public int geomType() {
        return this.geomType;
    }

    public int ordDim() {
        return this.ordDim;
    }

    public int lrsDim() {
        return this.lrsDim;
    }

    public boolean isCompactPoint() {
        return this.lrsDim == 0 && this.geomType == 1 && this.point != null && this.elemInfo == null;
    }

    public boolean isEqual(OraGeom og) {
        if (this.gType != og.gType) {
            return false;
        }
        if (!this.isEqual(this.point, og.point)) {
            return false;
        }
        if (!this.isEqual(this.elemInfo, og.elemInfo)) {
            return false;
        }
        return this.isEqual(this.ordinates, og.ordinates);
    }

    private boolean isEqual(double[] a1, double[] a2) {
        if (a2 == null || a1 == null) {
            return a2 == a1;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a1.length) {
            if (!(Double.isNaN(a1[i]) && Double.isNaN(a2[i]) || a1[i] == a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isEqual(int[] a1, int[] a2) {
        if (a2 == null || a1 == null) {
            return a2 == a1;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a1.length) {
            if (a1[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.toSQLString();
    }

    public String toSQLString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SDO_GEOMETRY(");
        buf.append(this.gType);
        buf.append(",");
        buf.append(this.srid >= 0 ? String.valueOf(this.srid) : SQL_NULL);
        buf.append(",");
        buf.append(this.toStringPointType());
        buf.append(",");
        buf.append(this.toStringElemInfo());
        buf.append(",");
        buf.append(this.toStringOrdinates());
        buf.append(")");
        return buf.toString();
    }

    private String toString(double[] ordinates) {
        if (ordinates == null) {
            return SQL_NULL;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ordinates.length) {
            if (i > 0) {
                buf.append(",");
                if (i % this.ordDim == 0) {
                    buf.append("  ");
                }
            }
            buf.append(OraGeom.number(ordinates[i]));
            ++i;
        }
        return buf.toString();
    }

    private static String number(double d) {
        if (Double.isNaN(d)) {
            return SQL_NULL;
        }
        return fmt.format(d);
    }

    public static String toStringElemInfo(int[] elemInfo) {
        if (elemInfo == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < elemInfo.length) {
            if (i > 0) {
                buf.append(",");
                if (i % 3 == 0) {
                    buf.append("  ");
                }
            }
            buf.append(elemInfo[i]);
            ++i;
        }
        return buf.toString();
    }

    private Object toStringOrdinates() {
        if (this.ordinates == null) {
            return SQL_NULL;
        }
        return "SDO_ORDINATE_ARRAY(" + this.toString(this.ordinates) + ")";
    }

    private Object toStringElemInfo() {
        if (this.elemInfo == null) {
            return SQL_NULL;
        }
        return "SDO_ELEM_INFO_ARRAY(" + OraGeom.toStringElemInfo(this.elemInfo) + ")";
    }

    private Object toStringPointType() {
        if (this.point == null) {
            return SQL_NULL;
        }
        return "SDO_POINT_TYPE(" + OraGeom.number(this.point[0]) + "," + OraGeom.number(this.point[1]) + "," + OraGeom.number(this.point[2]) + ")";
    }

    public int startingOffset(int elemIndex) {
        if (elemIndex * 3 >= this.elemInfo.length) {
            return this.ordinates.length + 1;
        }
        return this.elemInfo[elemIndex * 3];
    }

    public int eType(int elemIndex) {
        if (elemIndex * 3 + 1 >= this.elemInfo.length) {
            return -1;
        }
        return this.elemInfo[elemIndex * 3 + 1];
    }

    public int interpretation(int elemIndex) {
        if (elemIndex * 3 + 2 >= this.elemInfo.length) {
            return -1;
        }
        return this.elemInfo[elemIndex * 3 + 2];
    }

    public int ordinateLen() {
        if (this.ordinates != null) {
            return this.ordinates.length;
        }
        return 0;
    }

    public int numElements() {
        if (this.elemInfo == null) {
            return 0;
        }
        return this.elemInfo.length / 3;
    }

    public static int gType(int dim, int lrsDim, int geomType) {
        return dim * 1000 + lrsDim * 100 + geomType;
    }

    static int geomType(Geometry geom) {
        if (geom == null) {
            return 0;
        }
        if (geom instanceof Point) {
            return 1;
        }
        if (geom instanceof LineString) {
            return 2;
        }
        if (geom instanceof Polygon) {
            return 3;
        }
        if (geom instanceof MultiPoint) {
            return 5;
        }
        if (geom instanceof MultiLineString) {
            return 6;
        }
        if (geom instanceof MultiPolygon) {
            return 7;
        }
        if (geom instanceof GeometryCollection) {
            return 4;
        }
        return 0;
    }

    static int gTypeMeasureDim(int gType) {
        return gType % 1000 / 100;
    }

    static int gTypeDim(int gType) {
        return gType / 1000;
    }

    static int gTypeGeomType(int gType) {
        return gType % 100;
    }

    static int startingOffset(int[] elemInfo, int tripletIndex) {
        if (tripletIndex * 3 + 0 >= elemInfo.length) {
            return -1;
        }
        return elemInfo[tripletIndex * 3 + 0];
    }

    static int interpretation(int[] elemInfo, int tripletIndex) {
        if (tripletIndex * 3 + 2 >= elemInfo.length) {
            return -1;
        }
        return elemInfo[tripletIndex * 3 + 2];
    }

    static int eType(int[] elemInfo, int tripletIndex) {
        if (tripletIndex * 3 + 1 >= elemInfo.length) {
            return -1;
        }
        return elemInfo[tripletIndex * 3 + 1];
    }

    static final class ETYPE {
        public static final int POINT = 1;
        public static final int LINE = 2;
        public static final int POLYGON = 3;
        public static final int POLYGON_EXTERIOR = 1003;
        public static final int POLYGON_INTERIOR = 2003;

        ETYPE() {
        }
    }

    static final class GEOM_TYPE {
        public static final int UNKNOWN_GEOMETRY = 0;
        public static final int POINT = 1;
        public static final int LINE = 2;
        public static final int POLYGON = 3;
        public static final int COLLECTION = 4;
        public static final int MULTIPOINT = 5;
        public static final int MULTILINE = 6;
        public static final int MULTIPOLYGON = 7;

        GEOM_TYPE() {
        }
    }

    static final class INTERP {
        public static final int POINT = 1;
        public static final int LINESTRING = 1;
        public static final int POLYGON = 1;
        public static final int RECTANGLE = 3;

        INTERP() {
        }
    }
}

