/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.oracle;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.oracle.OraGeom;
import com.vividsolutions.jts.io.oracle.OraUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class OraReader {
    private GeometryFactory geometryFactory;
    private int outputDimension = -1;

    public OraReader() {
        this(new GeometryFactory());
    }

    public OraReader(GeometryFactory gf) {
        if (gf == null) {
            throw new NullPointerException("Geometry Factory may not be Null");
        }
        this.geometryFactory = gf;
    }

    public int getDimension() {
        return this.outputDimension;
    }

    public void setDimension(int outputDimension) {
        if (outputDimension < 2) {
            throw new IllegalArgumentException("Output dimension must be >= 2");
        }
        this.outputDimension = outputDimension;
    }

    public Geometry read(STRUCT struct) throws SQLException {
        double[] ordinates;
        int[] elemInfo;
        double[] point;
        int SRID;
        if (struct == null) {
            return null;
        }
        Datum[] data = struct.getOracleAttributes();
        int gType = OraUtil.toInteger(data[0], 0);
        OraGeom oraGeom = new OraGeom(gType, SRID = OraUtil.toInteger(data[1], -1), point = OraUtil.toDoubleArray((STRUCT)data[2], Double.NaN), elemInfo = OraUtil.toIntArray((ARRAY)data[3], 0), ordinates = OraUtil.toDoubleArray((ARRAY)data[4], Double.NaN));
        Geometry geom = this.read(oraGeom);
        if (geom != null) {
            geom.setSRID(SRID);
        }
        return geom;
    }

    Geometry read(OraGeom oraGeom) {
        int ordDim = oraGeom.ordDim();
        if (ordDim < 2) {
            throw new IllegalArgumentException("Dimension D = " + ordDim + " is not supported by JTS. " + "Either specify a valid dimension or use Oracle Locator Version 9i or later");
        }
        if (oraGeom.isCompactPoint()) {
            CoordinateSequence ptCoord = this.extractCoords(oraGeom, oraGeom.point);
            return this.createPoint(ptCoord);
        }
        Object coords = null;
        switch (oraGeom.geomType()) {
            case 1: {
                return this.readPoint(oraGeom, 0);
            }
            case 2: {
                return this.readLine(oraGeom, 0);
            }
            case 3: {
                return this.readPolygon(oraGeom, 0);
            }
            case 5: {
                return this.readMultiPoint(oraGeom, 0);
            }
            case 6: {
                return this.readMultiLine(oraGeom);
            }
            case 7: {
                return this.readMultiPolygon(oraGeom);
            }
            case 4: {
                return this.readCollection(oraGeom);
            }
        }
        throw new IllegalArgumentException("GTYPE " + oraGeom.gType + " is not supported");
    }

    private GeometryCollection readCollection(OraGeom oraGeom) {
        OraReader.checkOrdinates(oraGeom, 0, "GeometryCollection");
        int nElem = oraGeom.numElements();
        ArrayList<LineString> geomList = new ArrayList<LineString>();
        boolean cont = true;
        int i = 0;
        while (cont && i < nElem) {
            block10: {
                LineString geom;
                int etype = oraGeom.eType(i);
                int interpretation = oraGeom.interpretation(i);
                switch (etype) {
                    case -1: {
                        cont = false;
                        break block10;
                    }
                    case 1: {
                        if (interpretation == 1) {
                            geom = this.readPoint(oraGeom, i);
                            break;
                        }
                        if (interpretation > 1) {
                            geom = this.readMultiPoint(oraGeom, i);
                            break;
                        }
                        throw new IllegalArgumentException("ETYPE.POINT requires INTERPRETATION >= 1");
                    }
                    case 2: {
                        geom = this.readLine(oraGeom, i);
                        break;
                    }
                    case 3: 
                    case 1003: {
                        geom = this.readPolygon(oraGeom, i);
                        i += ((Polygon)geom).getNumInteriorRing();
                        break;
                    }
                    case 2003: {
                        throw new IllegalArgumentException("ETYPE 2003 (Polygon Interior) not expected in a Collection");
                    }
                    default: {
                        throw new IllegalArgumentException("ETYPE " + etype + " not representable as a JTS Geometry." + "(Custom and Compound Straight and Curved Geometries not supported)");
                    }
                }
                geomList.add(geom);
            }
            ++i;
        }
        GeometryCollection geoms = this.geometryFactory.createGeometryCollection(GeometryFactory.toGeometryArray(geomList));
        return geoms;
    }

    private MultiPolygon readMultiPolygon(OraGeom oraGeom) {
        int nElem = oraGeom.numElements();
        ArrayList<Polygon> geoms = new ArrayList<Polygon>();
        int i = 0;
        while (i < nElem) {
            int etype = oraGeom.eType(i);
            if (etype != 3 && etype != 1003) break;
            Polygon poly = this.readPolygon(oraGeom, i);
            i += poly.getNumInteriorRing();
            geoms.add(poly);
            ++i;
        }
        MultiPolygon polys = this.geometryFactory.createMultiPolygon(GeometryFactory.toPolygonArray(geoms));
        return polys;
    }

    private MultiLineString readMultiLine(OraGeom oraGeom) {
        int nElem = oraGeom.numElements();
        ArrayList<LineString> geoms = new ArrayList<LineString>();
        int i = 0;
        while (i < nElem) {
            int etype = oraGeom.eType(i);
            if (etype != 2) break;
            geoms.add(this.readLine(oraGeom, i));
            ++i;
        }
        MultiLineString lines = this.geometryFactory.createMultiLineString(GeometryFactory.toLineStringArray(geoms));
        return lines;
    }

    private MultiPoint readMultiPoint(OraGeom oraGeom, int elemIndex) {
        CoordinateSequence seq;
        if (oraGeom.geomType() == 5) {
            seq = this.extractCoords(oraGeom, oraGeom.ordinates);
        } else {
            int etype = oraGeom.eType(elemIndex);
            int interpretation = oraGeom.interpretation(elemIndex);
            OraReader.checkOrdinates(oraGeom, elemIndex, "MultiPoint");
            OraReader.checkETYPE(etype, 1, "MultiPoint");
            if (interpretation < 1) {
                OraReader.errorInterpretation(interpretation, "MultiPoint");
            }
            seq = this.extractCoords(oraGeom, elemIndex);
        }
        MultiPoint points = this.geometryFactory.createMultiPoint(seq);
        return points;
    }

    private Polygon readPolygon(OraGeom oraGeom, int elemIndex) {
        int etype = oraGeom.eType(elemIndex);
        int interpretation = oraGeom.interpretation(elemIndex);
        OraReader.checkOrdinates(oraGeom, elemIndex, "Polygon");
        OraReader.checkETYPE(etype, 3, 1003, "Polygon");
        OraReader.checkInterpretation(interpretation, 1, 3, "Polygon");
        int nElem = oraGeom.numElements();
        LinearRing exteriorRing = this.readLinearRing(oraGeom, elemIndex);
        ArrayList<LinearRing> holeRings = new ArrayList<LinearRing>();
        int i = elemIndex + 1;
        while (i < nElem) {
            etype = oraGeom.eType(i);
            if (etype == 2003) {
                holeRings.add(this.readLinearRing(oraGeom, i));
            } else {
                boolean isHole;
                if (etype != 3) break;
                LinearRing ring = this.readLinearRing(oraGeom, i);
                boolean bl = isHole = !CGAlgorithms.isCCW((Coordinate[])ring.getCoordinates());
                if (!isHole) break;
                holeRings.add(ring);
            }
            ++i;
        }
        Polygon poly = this.geometryFactory.createPolygon(exteriorRing, GeometryFactory.toLinearRingArray(holeRings));
        return poly;
    }

    private LinearRing readLinearRing(OraGeom oraGeom, int elemIndex) {
        LinearRing ring;
        int etype = oraGeom.eType(elemIndex);
        int interpretation = oraGeom.interpretation(elemIndex);
        OraReader.checkOrdinates(oraGeom, elemIndex, "Polygon");
        OraReader.checkETYPE(etype, 3, 1003, 2003, "Polygon");
        OraReader.checkInterpretation(interpretation, 1, 3, "Polygon");
        CoordinateSequence seq = this.extractCoords(oraGeom, elemIndex);
        if (interpretation == 1) {
            ring = this.geometryFactory.createLinearRing(seq);
        } else {
            Coordinate min = seq.getCoordinate(0);
            Coordinate max = seq.getCoordinate(1);
            ring = this.geometryFactory.createLinearRing(new Coordinate[]{min, new Coordinate(max.x, min.y), max, new Coordinate(min.x, max.y), min});
        }
        return ring;
    }

    private LineString readLine(OraGeom oraGeom, int elemIndex) {
        int etype = oraGeom.eType(elemIndex);
        int interpretation = oraGeom.interpretation(elemIndex);
        OraReader.checkOrdinates(oraGeom, elemIndex, "LineString");
        OraReader.checkETYPE(etype, 2, "LineString");
        OraReader.checkInterpretation(interpretation, 1, "LineString");
        LineString line = this.geometryFactory.createLineString(this.extractCoords(oraGeom, elemIndex));
        return line;
    }

    private Point readPoint(OraGeom oraGeom, int elemIndex) {
        int etype = oraGeom.eType(elemIndex);
        int interpretation = oraGeom.interpretation(elemIndex);
        OraReader.checkOrdinates(oraGeom, elemIndex, "Point");
        OraReader.checkETYPE(etype, 1, "Point");
        OraReader.checkInterpretation(interpretation, 1, "Point");
        CoordinateSequence seq = this.extractCoords(oraGeom, elemIndex);
        return this.createPoint(seq);
    }

    private Point createPoint(CoordinateSequence coords) {
        return this.geometryFactory.createPoint(coords);
    }

    private CoordinateSequence extractCoords(OraGeom oraGeom, int elemIndex) {
        int start = oraGeom.startingOffset(elemIndex);
        int end = oraGeom.startingOffset(elemIndex + 1);
        return this.extractCoords(oraGeom, oraGeom.ordinates, start, end);
    }

    private CoordinateSequence extractCoords(OraGeom oraGeom, double[] ordinates) {
        return this.extractCoords(oraGeom, ordinates, 1, ordinates.length + 1);
    }

    private CoordinateSequence extractCoords(OraGeom oraGeom, double[] ordinates, int start, int end) {
        int ordDim;
        CoordinateSequenceFactory csFactory = this.geometryFactory.getCoordinateSequenceFactory();
        if (ordinates == null || ordinates.length == 0) {
            return csFactory.create(new Coordinate[0]);
        }
        int csDim = ordDim = oraGeom.ordDim();
        if (this.outputDimension != -1) {
            csDim = this.outputDimension;
        }
        int nCoord = ordDim == 0 ? 0 : (end - start) / ordDim;
        CoordinateSequence cs = csFactory.create(nCoord, csDim);
        int actualCSDim = cs.getDimension();
        int readDim = Math.min(actualCSDim, ordDim);
        int iCoord = 0;
        while (iCoord < nCoord) {
            int iDim = 0;
            while (iDim < readDim) {
                int ordIndex = start + iCoord * ordDim + iDim - 1;
                cs.setOrdinate(iCoord, iDim, ordinates[ordIndex]);
                ++iDim;
            }
            ++iCoord;
        }
        return cs;
    }

    private static void checkETYPE(int eType, int val1, String geomType) {
        OraReader.checkETYPE(eType, val1, -1, -1, geomType);
    }

    private static void checkETYPE(int eType, int val1, int val2, String geomType) {
        OraReader.checkETYPE(eType, val1, val2, -1, geomType);
    }

    private static void checkETYPE(int eType, int val1, int val2, int val3, String geomType) {
        if (eType == val1) {
            return;
        }
        if (val2 >= 0 && eType == val2) {
            return;
        }
        if (val3 >= 0 && eType == val3) {
            return;
        }
        throw new IllegalArgumentException("SDO_ETYPE " + eType + " is not supported when reading a " + geomType);
    }

    private static void checkInterpretation(int interpretation, int val1, String geomType) {
        OraReader.checkInterpretation(interpretation, val1, -1, geomType);
    }

    private static void checkInterpretation(int interpretation, int val1, int val2, String geomType) {
        if (interpretation == val1) {
            return;
        }
        if (val2 >= 0 && interpretation == val2) {
            return;
        }
        OraReader.errorInterpretation(interpretation, geomType);
    }

    private static void errorInterpretation(int interpretation, String geomType) {
        throw new IllegalArgumentException("SDO_INTERPRETATION " + interpretation + " is not supported when reading a " + geomType);
    }

    private static void checkOrdinates(OraGeom oraGeom, int elemIndex, String geomType) {
        int startOffset = oraGeom.startingOffset(elemIndex);
        int ordLen = oraGeom.ordinateLen();
        OraReader.checkOrdinates(oraGeom.elemInfo, elemIndex, startOffset, ordLen, geomType);
    }

    private static void checkOrdinates(int[] elemInfo, int elemIndex, int startOffset, int ordLen, String geomType) {
        if (startOffset > ordLen) {
            throw new IllegalArgumentException("STARTING_OFFSET " + startOffset + " inconsistent with ORDINATES length " + ordLen + " (Element " + elemIndex + " in SDO_ELEM_INFO " + OraGeom.toStringElemInfo(elemInfo) + ")");
        }
    }
}

