/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OraUtil {
    public static int toInteger(Datum datum, int defaultValue) throws SQLException {
        if (datum == null) {
            return defaultValue;
        }
        return ((NUMBER)datum).intValue();
    }

    public static int[] toIntArray(ARRAY array, int defaultValue) throws SQLException {
        if (array == null) {
            return null;
        }
        if (defaultValue == 0) {
            return array.getIntArray();
        }
        return OraUtil.toIntArray(array.getOracleArray(), defaultValue);
    }

    public static int[] toIntArray(Datum[] data, int defaultValue) throws SQLException {
        if (data == null) {
            return null;
        }
        int[] array = new int[data.length];
        int i = 0;
        while (i < data.length) {
            array[i] = OraUtil.toInteger(data[i], defaultValue);
            ++i;
        }
        return array;
    }

    public static double[] toDoubleArray(Datum[] data, double defaultValue) {
        if (data == null) {
            return null;
        }
        double[] array = new double[data.length];
        int i = 0;
        while (i < data.length) {
            array[i] = OraUtil.toDouble(data[i], defaultValue);
            ++i;
        }
        return array;
    }

    public static double[] toDoubleArray(ARRAY array, double defaultValue) throws SQLException {
        if (array == null) {
            return null;
        }
        if (defaultValue == 0.0) {
            return array.getDoubleArray();
        }
        return OraUtil.toDoubleArray(array.getOracleArray(), defaultValue);
    }

    public static double[] toDoubleArray(STRUCT struct, double defaultValue) throws SQLException {
        if (struct == null) {
            return null;
        }
        return OraUtil.toDoubleArray(struct.getOracleAttributes(), defaultValue);
    }

    public static double toDouble(Datum datum, double defaultValue) {
        if (datum == null) {
            return defaultValue;
        }
        return ((NUMBER)datum).doubleValue();
    }

    public static NUMBER toNUMBER(double number) throws SQLException {
        if (Double.isNaN(number)) {
            return null;
        }
        return new NUMBER(number);
    }

    public static ARRAY toARRAY(double[] doubles, String dataType, OracleConnection connection) throws SQLException {
        ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)dataType, (Connection)connection);
        return new ARRAY(descriptor, (Connection)connection, (Object)doubles);
    }

    public static ARRAY toARRAY(int[] ints, String dataType, OracleConnection connection) throws SQLException {
        ArrayDescriptor descriptor = ArrayDescriptor.createDescriptor((String)dataType, (Connection)connection);
        return new ARRAY(descriptor, (Connection)connection, (Object)ints);
    }

    public static STRUCT toSTRUCT(Datum[] attributes, String dataType, OracleConnection connection) throws SQLException {
        if (dataType.startsWith("*.")) {
            dataType = "DRA." + dataType.substring(2);
        }
        StructDescriptor descriptor = StructDescriptor.createDescriptor((String)dataType, (Connection)connection);
        return new STRUCT(descriptor, (Connection)connection, (Object[])attributes);
    }
}

